/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.portlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.MimeResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.wicket.protocol.http.portlet.WicketResponseState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WicketPortlet
extends GenericPortlet {
    private static final Logger log = LoggerFactory.getLogger(WicketPortlet.class);
    public static final String WICKET_URL_PORTLET_PARAMETER = "_wu";
    public static final String WICKET_URL_PORTLET_PARAMETER_ATTR = WicketPortlet.class.getName() + ".WICKET_URL_PORTLET_PARAMETER";
    public static final String WICKET_FILTER_PATH_PARAM = "wicketFilterPath";
    public static final String CONFIG_PARAM_PREFIX = WicketPortlet.class.getName() + ".";
    public static final String RESPONSE_STATE_ATTR = WicketResponseState.class.getName();
    public static final String WICKET_PORTLET_PROPERTIES = WicketPortlet.class.getName().replace('.', '/') + ".properties";
    public static final String WICKET_FILTER_PATH = WicketPortlet.class.getName() + ".FILTERPATH";
    public static final String WICKET_FILTER_QUERY = WicketPortlet.class.getName() + ".FILTERQUERY";
    public static final String PARAM_ACTION_PAGE = "actionPage";
    public static final String PARAM_CUSTOM_PAGE = "customPage";
    public static final String PARAM_EDIT_PAGE = "editPage";
    public static final String PARAM_HELP_PAGE = "helpPage";
    public static final String PARAM_VIEW_PAGE = "viewPage";
    private String wicketFilterPath;
    private String wicketFilterQuery;
    private final HashMap<String, String> defaultPages = new HashMap();

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.wicketFilterPath = this.buildWicketFilterPath(config.getInitParameter(WICKET_FILTER_PATH_PARAM));
        this.wicketFilterQuery = this.buildWicketFilterQuery(this.wicketFilterPath);
        this.defaultPages.put(PARAM_VIEW_PAGE, config.getInitParameter(PARAM_VIEW_PAGE));
        this.defaultPages.put(PARAM_ACTION_PAGE, config.getInitParameter(PARAM_ACTION_PAGE));
        this.defaultPages.put(PARAM_CUSTOM_PAGE, config.getInitParameter(PARAM_CUSTOM_PAGE));
        this.defaultPages.put(PARAM_HELP_PAGE, config.getInitParameter(PARAM_HELP_PAGE));
        this.defaultPages.put(PARAM_EDIT_PAGE, config.getInitParameter(PARAM_EDIT_PAGE));
        this.validateDefaultPages(this.defaultPages, this.wicketFilterPath, this.wicketFilterQuery);
    }

    public void destroy() {
        super.destroy();
    }

    protected String getDefaultPage(String pageType) {
        return this.defaultPages.get(pageType);
    }

    protected String buildWicketFilterPath(String filterPath) {
        if (filterPath == null || filterPath.length() == 0) {
            filterPath = "/";
        } else {
            if (!filterPath.startsWith("/")) {
                filterPath = "/" + filterPath;
            }
            if (filterPath.endsWith("*")) {
                filterPath = filterPath.substring(0, filterPath.length() - 1);
            }
            if (!filterPath.endsWith("/")) {
                filterPath = filterPath + "/";
            }
        }
        return filterPath;
    }

    protected String buildWicketFilterQuery(String wicketFilterPath) {
        if (wicketFilterPath.equals("/")) {
            return "?";
        }
        return wicketFilterPath.substring(0, wicketFilterPath.length() - 1) + "?";
    }

    protected String fixWicketUrl(String url, String wicketFilterPath, String wicketFilterQuery) {
        if (url == null) {
            return wicketFilterPath;
        }
        if (!url.startsWith(wicketFilterPath)) {
            if ((url + "/").equals(wicketFilterPath)) {
                url = wicketFilterPath;
            } else if (url.startsWith(wicketFilterQuery)) {
                url = wicketFilterPath + "?" + url.substring(wicketFilterQuery.length());
            }
        }
        return url;
    }

    protected void validateDefaultPages(Map defaultPages, String wicketFilterPath, String wicketFilterQuery) {
        String viewPage = this.fixWicketUrl((String)defaultPages.get(PARAM_VIEW_PAGE), wicketFilterPath, wicketFilterQuery);
        defaultPages.put(PARAM_VIEW_PAGE, viewPage.startsWith(wicketFilterPath) ? viewPage : wicketFilterPath);
        String defaultPage = (String)defaultPages.get(PARAM_ACTION_PAGE);
        if (defaultPage == null) {
            defaultPages.put(PARAM_ACTION_PAGE, viewPage);
        } else {
            defaultPages.put(PARAM_ACTION_PAGE, (defaultPage = this.fixWicketUrl(defaultPage, wicketFilterPath, wicketFilterQuery)).startsWith(wicketFilterPath) ? defaultPage : viewPage);
        }
        defaultPage = (String)defaultPages.get(PARAM_CUSTOM_PAGE);
        if (defaultPage == null) {
            defaultPages.put(PARAM_CUSTOM_PAGE, viewPage);
        } else {
            defaultPages.put(PARAM_CUSTOM_PAGE, (defaultPage = this.fixWicketUrl(defaultPage, wicketFilterPath, wicketFilterQuery)).startsWith(wicketFilterPath) ? defaultPage : viewPage);
        }
        defaultPage = (String)defaultPages.get(PARAM_HELP_PAGE);
        if (defaultPage == null) {
            defaultPages.put(PARAM_HELP_PAGE, viewPage);
        } else {
            defaultPages.put(PARAM_HELP_PAGE, (defaultPage = this.fixWicketUrl(defaultPage, wicketFilterPath, wicketFilterQuery)).startsWith(wicketFilterPath) ? defaultPage : viewPage);
        }
        defaultPage = (String)defaultPages.get(PARAM_EDIT_PAGE);
        if (defaultPage == null) {
            defaultPages.put(PARAM_EDIT_PAGE, viewPage);
        } else {
            defaultPages.put(PARAM_EDIT_PAGE, (defaultPage = this.fixWicketUrl(defaultPage, wicketFilterPath, wicketFilterQuery)).startsWith(wicketFilterPath) ? defaultPage : viewPage);
        }
    }

    protected Properties getWicketPortletProperties(Properties properties) throws PortletException {
        InputStream is;
        if (properties == null) {
            properties = new Properties();
        }
        if ((is = Thread.currentThread().getContextClassLoader().getResourceAsStream(WICKET_PORTLET_PROPERTIES)) != null) {
            try {
                properties.load(is);
            }
            catch (IOException e) {
                throw new PortletException("Failed to load WicketPortlet.properties from classpath", (Throwable)e);
            }
        }
        return properties;
    }

    protected String getWicketConfigParameter(PortletRequest request, String paramName, String defaultValue) {
        return defaultValue;
    }

    protected String getWicketUrlPortletParameter(PortletRequest request) {
        return WICKET_URL_PORTLET_PARAMETER;
    }

    protected String getWicketFilterPath() {
        return this.wicketFilterPath;
    }

    protected String getWicketURL(PortletRequest request, String pageType, String defaultPage) {
        String wicketURL = null;
        String wicketUrlParameterName = (String)request.getAttribute(WICKET_URL_PORTLET_PARAMETER_ATTR);
        if (request instanceof ActionRequest) {
            wicketURL = request.getParameter(wicketUrlParameterName);
        } else if (request instanceof ResourceRequest) {
            wicketURL = ((ResourceRequest)request).getResourceID();
        } else {
            String parameterName = wicketUrlParameterName + request.getPortletMode().toString();
            wicketURL = request.getParameter(parameterName);
        }
        if (wicketURL == null) {
            wicketURL = this.getWicketConfigParameter(request, CONFIG_PARAM_PREFIX + pageType, defaultPage);
        }
        return wicketURL;
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.processRequest((PortletRequest)request, (PortletResponse)response, PARAM_VIEW_PAGE);
    }

    protected void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.processRequest((PortletRequest)request, (PortletResponse)response, PARAM_EDIT_PAGE);
    }

    protected void doHelp(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.processRequest((PortletRequest)request, (PortletResponse)response, PARAM_HELP_PAGE);
    }

    protected void doCustom(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.processRequest((PortletRequest)request, (PortletResponse)response, PARAM_CUSTOM_PAGE);
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        this.processRequest((PortletRequest)request, (PortletResponse)response, PARAM_ACTION_PAGE);
    }

    public void serveResource(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        if (request.getResourceID() != null) {
            this.processRequest((PortletRequest)request, (PortletResponse)response, PARAM_VIEW_PAGE);
        }
    }

    protected void processRequest(PortletRequest request, PortletResponse response, String pageType) throws PortletException, IOException {
        String wicketURL = null;
        String wicketFilterPath = null;
        String wicketFilterQuery = null;
        request.setAttribute(WICKET_URL_PORTLET_PARAMETER_ATTR, (Object)this.getWicketUrlPortletParameter(request));
        wicketURL = this.getWicketURL(request, pageType, this.getDefaultPage(pageType));
        if (log.isDebugEnabled()) {
            log.debug("Portlet \"" + request.getAttribute("javax.portlet.lifecycle_phase") + "\" for wicket url:" + wicketURL);
        }
        wicketFilterPath = this.getWicketConfigParameter(request, WICKET_FILTER_PATH, this.wicketFilterPath);
        wicketFilterQuery = this.getWicketConfigParameter(request, WICKET_FILTER_QUERY, this.wicketFilterQuery);
        WicketResponseState responseState = new WicketResponseState(request, response);
        request.setAttribute(RESPONSE_STATE_ATTR, (Object)responseState);
        if (responseState.isActionResponse()) {
            PortletRequestDispatcher rd = this.getPortletContext().getRequestDispatcher(wicketURL);
            if (rd != null) {
                rd.include(request, response);
                if (log.isDebugEnabled()) {
                    log.debug("wicket filter inclusion complete");
                }
                this.processActionResponseState(wicketURL, wicketFilterPath, wicketFilterQuery, request, (ActionResponse)response, responseState);
            }
        } else if (responseState.isMimeResponse()) {
            this.processMimeResponseRequest(request, (MimeResponse)response, wicketURL, wicketFilterPath, wicketFilterQuery, responseState);
        } else {
            log.warn("Unsupported Portlet lifecycle: " + request.getAttribute("javax.portlet.lifecycle_phase"));
        }
        if (log.isDebugEnabled()) {
            wicketURL = this.getWicketURL(request, pageType, this.getDefaultPage(pageType));
            log.debug("end of request, wicket url:" + wicketURL);
        }
    }

    private void processMimeResponseRequest(PortletRequest request, MimeResponse response, String wicketURL, String wicketFilterPath, String wicketFilterQuery, WicketResponseState responseState) throws PortletException, IOException {
        PortletRequestDispatcher rd = null;
        String previousURL = null;
        while ((rd = this.getPortletContext().getRequestDispatcher(wicketURL)) != null) {
            rd.include(request, (PortletResponse)response);
            String redirectLocation = responseState.getRedirectLocation();
            if (log.isDebugEnabled()) {
                log.debug("redirect url after inclusion:" + redirectLocation);
            }
            if (redirectLocation != null) {
                boolean validWicketUrl = (redirectLocation = this.fixWicketUrl(redirectLocation, wicketFilterPath, wicketFilterQuery)).startsWith(wicketFilterPath);
                if (validWicketUrl) {
                    if (previousURL == null || previousURL != redirectLocation) {
                        previousURL = wicketURL;
                        wicketURL = redirectLocation;
                        response.reset();
                        responseState.clear();
                        continue;
                    }
                    responseState.clear();
                    break;
                }
                responseState.clear();
                if (responseState.isResourceResponse()) {
                    response.setProperty("portlet.http-status-code", Integer.toString(302));
                    response.setProperty("Location", redirectLocation);
                    break;
                }
                log.error("Wicket redirecting outside of its own application during Render which is unsupported. Target url: " + redirectLocation);
                break;
            }
            responseState.flush();
            break;
        }
    }

    protected void processActionResponseState(String wicketURL, String wicketFilterPath, String wicketFilterQuery, PortletRequest request, ActionResponse response, WicketResponseState responseState) throws PortletException, IOException {
        responseState.flush();
        String redirectLocationUrl = responseState.getRedirectLocation();
        if (log.isDebugEnabled()) {
            log.debug("redirectURL after include:" + redirectLocationUrl);
        }
        if (redirectLocationUrl != null) {
            wicketURL = this.fixWicketUrl(redirectLocationUrl, wicketFilterPath, wicketFilterQuery);
            if (wicketURL.startsWith(wicketFilterPath)) {
                String portletMode = request.getPortletMode().toString();
                String wicketUrlPrefix = (String)request.getAttribute(WICKET_URL_PORTLET_PARAMETER_ATTR);
                String redirectUrlKey = wicketUrlPrefix + portletMode;
                response.setRenderParameter(redirectUrlKey, wicketURL);
            } else {
                response.sendRedirect(redirectLocationUrl);
            }
        }
    }
}

