/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.target.component;

import org.apache.wicket.Page;
import org.apache.wicket.PageReference;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.request.target.component.IPageRequestTarget;

public class PageReferenceRequestTarget
implements IPageRequestTarget {
    private final PageReference reference;

    public PageReferenceRequestTarget(Page page) {
        if (page == null) {
            throw new IllegalArgumentException("Argument `page` cannot be null");
        }
        this.reference = page.getPageReference();
    }

    public PageReferenceRequestTarget(PageReference pageReference) {
        if (pageReference == null) {
            throw new IllegalArgumentException("Argument `pageId` cannot be null");
        }
        this.reference = pageReference;
    }

    public final PageReference getPageReference() {
        return this.reference;
    }

    public void respond(RequestCycle requestCycle) {
        Page page = this.reference.getPage();
        if (requestCycle.isRedirect()) {
            requestCycle.redirectTo(page);
        } else {
            page.renderPage();
        }
    }

    public void detach(RequestCycle requestCycle) {
        this.reference.getPage().detach();
    }

    public Page getPage() {
        return this.reference.getPage();
    }
}

