/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.resource.loader;

import java.util.Locale;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.resource.IPropertiesFactory;
import org.apache.wicket.resource.Properties;
import org.apache.wicket.resource.loader.IStringResourceLoader;
import org.apache.wicket.util.resource.locator.ResourceNameIterator;
import org.apache.wicket.validation.IValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorStringResourceLoader
implements IStringResourceLoader {
    private static final Logger log = LoggerFactory.getLogger(ValidatorStringResourceLoader.class);

    @Override
    public String loadStringResource(Class<?> clazz, String key, Locale locale, String style) {
        if (clazz == null || !IValidator.class.isAssignableFrom(clazz)) {
            return null;
        }
        IPropertiesFactory propertiesFactory = Application.get().getResourceSettings().getPropertiesFactory();
        do {
            String path = clazz.getName().replace('.', '/');
            ResourceNameIterator iter = new ResourceNameIterator(path, style, locale, null);
            while (iter.hasNext()) {
                String value;
                String newPath = iter.next();
                Properties props = propertiesFactory.load(clazz, newPath);
                if (props == null || (value = props.getString(key)) == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Found resource from: " + props + "; key: " + key);
                }
                return value;
            }
        } while ((clazz = clazz.getSuperclass()) != null && !Object.class.equals(clazz));
        return null;
    }

    @Override
    public String loadStringResource(Component component, String key) {
        if (component == null || !(component instanceof FormComponent)) {
            return null;
        }
        FormComponent fc = (FormComponent)component;
        Locale locale = component.getLocale();
        String style = component.getStyle();
        for (IValidator validator : fc.getValidators()) {
            String resource = this.loadStringResource(validator.getClass(), key, locale, style);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }
}

