/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.convert.converters;

import java.text.NumberFormat;
import java.util.Locale;
import org.apache.wicket.util.convert.converters.AbstractConverter;

public abstract class AbstractNumberConverter
extends AbstractConverter {
    private static final long serialVersionUID = 1L;

    public abstract NumberFormat getNumberFormat(Locale var1);

    protected Number parse(Object value, double min, double max, Locale locale) {
        NumberFormat numberFormat;
        Number number;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            String v = (String)value;
            value = v.replace(' ', '\u00a0');
        }
        if ((number = (Number)this.parse(numberFormat = this.getNumberFormat(locale), value, locale)) == null) {
            return null;
        }
        if (number.doubleValue() < min) {
            throw this.newConversionException("Value cannot be less than " + min, value, locale).setFormat(numberFormat);
        }
        if (number.doubleValue() > max) {
            throw this.newConversionException("Value cannot be greater than " + max, value, locale).setFormat(numberFormat);
        }
        return number;
    }

    public String convertToString(Object value, Locale locale) {
        NumberFormat fmt = this.getNumberFormat(locale);
        if (fmt != null) {
            return fmt.format(value);
        }
        return value.toString();
    }
}

