/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.io;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.apache.wicket.util.collections.IntHashMap;
import org.apache.wicket.util.io.ClassStreamHandler;
import org.apache.wicket.util.io.HandleArrayListStack;
import org.apache.wicket.util.lang.Generics;

public final class WicketObjectInputStream
extends ObjectInputStream {
    private final IntHashMap<Object> handledObjects = new IntHashMap();
    private short handleCounter = 0;
    private final DataInputStream in;
    private ClassStreamHandler currentStreamHandler;
    private HandleArrayListStack<Object> stack = new HandleArrayListStack();
    private HandleArrayListStack<Object> defaultRead = new HandleArrayListStack();

    public WicketObjectInputStream(InputStream in) throws IOException {
        this.in = new DataInputStream(in);
    }

    protected Object readObjectOverride() throws IOException, ClassNotFoundException {
        Object value = null;
        int token = this.in.read();
        if (token == 0) {
            return null;
        }
        if (token == 1) {
            short handle = this.in.readShort();
            value = this.handledObjects.get(handle);
            if (value == null) {
                throw new RuntimeException("Expected to find a handle for " + handle);
            }
        } else if (token == 2) {
            short classDef = this.in.readShort();
            ClassStreamHandler oldStreamHandler = this.currentStreamHandler;
            this.currentStreamHandler = ClassStreamHandler.lookup(classDef);
            if (this.currentStreamHandler.getStreamClass() == String.class) {
                value = this.in.readUTF();
                short s = this.handleCounter;
                this.handleCounter = (short)(s + 1);
                this.handledObjects.put(s, value);
            } else {
                try {
                    value = this.currentStreamHandler.createObject();
                    short s = this.handleCounter;
                    this.handleCounter = (short)(s + 1);
                    this.handledObjects.put(s, value);
                    this.stack.push(value);
                    if (!this.currentStreamHandler.invokeReadMethod(this, value)) {
                        this.currentStreamHandler.readFields(this, value);
                    }
                    value = this.currentStreamHandler.readResolve(value);
                    this.stack.pop();
                }
                catch (IllegalArgumentException ex) {
                    throw new RuntimeException(ex);
                }
                catch (InstantiationException ex) {
                    throw new RuntimeException(ex);
                }
                catch (IllegalAccessException ex) {
                    throw new RuntimeException(ex);
                }
                catch (InvocationTargetException ex) {
                    throw new RuntimeException(ex);
                }
            }
            this.currentStreamHandler = oldStreamHandler;
        } else if (token == 5) {
            short classDef = this.in.readShort();
            ClassStreamHandler lookup = ClassStreamHandler.lookup(classDef);
            value = lookup.getStreamClass();
        } else if (token == 3) {
            short classDef = this.in.readShort();
            ClassStreamHandler lookup = ClassStreamHandler.lookup(classDef);
            int length = this.in.readInt();
            Object[] array = (Object[])Array.newInstance(lookup.getStreamClass(), length);
            short s = this.handleCounter;
            this.handleCounter = (short)(s + 1);
            this.handledObjects.put(s, array);
            for (int i = 0; i < array.length; ++i) {
                array[i] = this.readObjectOverride();
            }
            value = array;
        } else if (token == 4) {
            short classDef = this.in.readShort();
            ClassStreamHandler lookup = ClassStreamHandler.lookup(classDef);
            value = lookup.readArray(this);
            short s = this.handleCounter;
            this.handleCounter = (short)(s + 1);
            this.handledObjects.put(s, value);
        } else {
            throw new RuntimeException("not a valid token found: " + token);
        }
        return value;
    }

    public void defaultReadObject() throws IOException, ClassNotFoundException {
        Object currentObject = this.stack.peek();
        if (!this.defaultRead.contains(currentObject)) {
            this.defaultRead.add(currentObject);
            this.currentStreamHandler.readFields(this, currentObject);
        }
    }

    public void close() throws IOException {
        this.stack = null;
        this.defaultRead = null;
        this.currentStreamHandler = null;
        this.in.close();
    }

    public boolean readBoolean() throws IOException {
        return this.in.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.in.readByte();
    }

    public int readUnsignedByte() throws IOException {
        return this.in.readUnsignedByte();
    }

    public char readChar() throws IOException {
        return this.in.readChar();
    }

    public short readShort() throws IOException {
        return this.in.readShort();
    }

    public int readUnsignedShort() throws IOException {
        return this.in.readUnsignedShort();
    }

    public int readInt() throws IOException {
        return this.in.readInt();
    }

    public long readLong() throws IOException {
        return this.in.readLong();
    }

    public float readFloat() throws IOException {
        return this.in.readFloat();
    }

    public double readDouble() throws IOException {
        return this.in.readDouble();
    }

    public void readFully(byte[] buf) throws IOException {
        this.in.readFully(buf, 0, buf.length);
    }

    public void readFully(byte[] buf, int off, int len) throws IOException {
        int endoff = off + len;
        if (off < 0 || len < 0 || endoff > buf.length || endoff < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.in.readFully(buf, off, len);
    }

    public String readUTF() throws IOException {
        String s = this.in.readUTF();
        return s;
    }

    public int read() throws IOException {
        return this.in.read();
    }

    public int read(byte[] b) throws IOException {
        return this.in.read(b);
    }

    public int read(byte[] buf, int off, int len) throws IOException {
        return this.in.read(buf, off, len);
    }

    public ObjectInputStream.GetField readFields() throws IOException, ClassNotFoundException {
        GetFieldImpl field = new GetFieldImpl();
        field.read();
        return field;
    }

    private class GetFieldImpl
    extends ObjectInputStream.GetField {
        private final HashMap<String, Object> values = Generics.newHashMap();

        private GetFieldImpl() {
        }

        private void read() throws IOException, ClassNotFoundException {
            String key;
            int i;
            int count;
            ClassStreamHandler lookup;
            short token = WicketObjectInputStream.this.readShort();
            if (token == (lookup = ClassStreamHandler.lookup(Boolean.TYPE)).getClassId()) {
                count = WicketObjectInputStream.this.readShort();
                for (i = 0; i < count; ++i) {
                    key = (String)WicketObjectInputStream.this.readObjectOverride();
                    this.values.put(key, WicketObjectInputStream.this.readBoolean() ? Boolean.TRUE : Boolean.FALSE);
                }
                token = WicketObjectInputStream.this.readShort();
                if (token == 0) {
                    return;
                }
            }
            if (token == (lookup = ClassStreamHandler.lookup(Byte.TYPE)).getClassId()) {
                count = WicketObjectInputStream.this.readShort();
                for (i = 0; i < count; ++i) {
                    key = (String)WicketObjectInputStream.this.readObjectOverride();
                    this.values.put(key, new Byte(WicketObjectInputStream.this.readByte()));
                }
                token = WicketObjectInputStream.this.readShort();
                if (token == 0) {
                    return;
                }
            }
            if (token == (lookup = ClassStreamHandler.lookup(Short.TYPE)).getClassId()) {
                count = WicketObjectInputStream.this.readShort();
                for (i = 0; i < count; ++i) {
                    key = (String)WicketObjectInputStream.this.readObjectOverride();
                    this.values.put(key, new Short(WicketObjectInputStream.this.readShort()));
                }
                token = WicketObjectInputStream.this.readShort();
                if (token == 0) {
                    return;
                }
            }
            if (token == (lookup = ClassStreamHandler.lookup(Character.TYPE)).getClassId()) {
                count = WicketObjectInputStream.this.readShort();
                for (i = 0; i < count; ++i) {
                    key = (String)WicketObjectInputStream.this.readObjectOverride();
                    this.values.put(key, new Character(WicketObjectInputStream.this.readChar()));
                }
                token = WicketObjectInputStream.this.readShort();
                if (token == 0) {
                    return;
                }
            }
            if (token == (lookup = ClassStreamHandler.lookup(Integer.TYPE)).getClassId()) {
                count = WicketObjectInputStream.this.readShort();
                for (i = 0; i < count; ++i) {
                    key = (String)WicketObjectInputStream.this.readObjectOverride();
                    this.values.put(key, new Integer(WicketObjectInputStream.this.readInt()));
                }
                token = WicketObjectInputStream.this.readShort();
                if (token == 0) {
                    return;
                }
            }
            if (token == (lookup = ClassStreamHandler.lookup(Long.TYPE)).getClassId()) {
                count = WicketObjectInputStream.this.readShort();
                for (i = 0; i < count; ++i) {
                    key = (String)WicketObjectInputStream.this.readObjectOverride();
                    this.values.put(key, new Long(WicketObjectInputStream.this.readLong()));
                }
                token = WicketObjectInputStream.this.readShort();
                if (token == 0) {
                    return;
                }
            }
            if (token == (lookup = ClassStreamHandler.lookup(Float.TYPE)).getClassId()) {
                count = WicketObjectInputStream.this.readShort();
                for (i = 0; i < count; ++i) {
                    key = (String)WicketObjectInputStream.this.readObjectOverride();
                    this.values.put(key, new Float(WicketObjectInputStream.this.readFloat()));
                }
                token = WicketObjectInputStream.this.readShort();
                if (token == 0) {
                    return;
                }
            }
            if (token == (lookup = ClassStreamHandler.lookup(Double.TYPE)).getClassId()) {
                count = WicketObjectInputStream.this.readShort();
                for (i = 0; i < count; ++i) {
                    key = (String)WicketObjectInputStream.this.readObjectOverride();
                    this.values.put(key, new Double(WicketObjectInputStream.this.readDouble()));
                }
                token = WicketObjectInputStream.this.readShort();
                if (token == 0) {
                    return;
                }
            }
            if (token == (lookup = ClassStreamHandler.lookup(Serializable.class)).getClassId()) {
                count = WicketObjectInputStream.this.readShort();
                for (i = 0; i < count; ++i) {
                    key = (String)WicketObjectInputStream.this.readObjectOverride();
                    this.values.put(key, WicketObjectInputStream.this.readObjectOverride());
                }
                token = WicketObjectInputStream.this.readShort();
            }
            if (token != 0) {
                throw new RuntimeException("Expected NULL end byte");
            }
        }

        public boolean defaulted(String name) throws IOException {
            return this.values.get(name) == null;
        }

        public byte get(String name, byte val) throws IOException {
            Object o = this.values.get(name);
            if (o instanceof Byte) {
                return (Byte)o;
            }
            return val;
        }

        public char get(String name, char val) throws IOException {
            Object o = this.values.get(name);
            if (o instanceof Character) {
                return ((Character)o).charValue();
            }
            return val;
        }

        public double get(String name, double val) throws IOException {
            Object o = this.values.get(name);
            if (o instanceof Double) {
                return (Double)o;
            }
            return val;
        }

        public float get(String name, float val) throws IOException {
            Object o = this.values.get(name);
            if (o instanceof Float) {
                return ((Float)o).floatValue();
            }
            return val;
        }

        public int get(String name, int val) throws IOException {
            Object o = this.values.get(name);
            if (o instanceof Integer) {
                return (Integer)o;
            }
            return val;
        }

        public long get(String name, long val) throws IOException {
            Object o = this.values.get(name);
            if (o instanceof Long) {
                return (Long)o;
            }
            return val;
        }

        public short get(String name, short val) throws IOException {
            Object o = this.values.get(name);
            if (o instanceof Short) {
                return (Short)o;
            }
            return val;
        }

        public boolean get(String name, boolean val) throws IOException {
            Object o = this.values.get(name);
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
            return val;
        }

        public Object get(String name, Object val) throws IOException {
            Object o = this.values.get(name);
            if (o != null) {
                return o;
            }
            return val;
        }

        public ObjectStreamClass getObjectStreamClass() {
            return null;
        }
    }
}

