/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.resource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import org.apache.wicket.Application;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.util.io.Connections;
import org.apache.wicket.util.resource.AbstractResourceStream;
import org.apache.wicket.util.resource.IFixedLocationResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlResourceStream
extends AbstractResourceStream
implements IFixedLocationResourceStream {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(UrlResourceStream.class);
    private transient InputStream inputStream;
    private final URL url;
    private File file;
    private int contentLength;
    private String contentType;
    private long lastModified;

    public UrlResourceStream(URL url) {
        this.url = url;
        URLConnection connection = null;
        try {
            connection = url.openConnection();
            this.contentLength = connection.getContentLength();
            this.contentType = connection.getContentType();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Invalid URL parameter " + url, ex);
        }
        finally {
            Connections.closeQuietly(connection);
        }
        try {
            this.file = new File(new URI(url.toExternalForm()));
            if (this.file != null && !this.file.exists()) {
                this.file = null;
            }
        }
        catch (Exception e) {
            log.debug("cannot convert url: " + url + " to file (" + e.getMessage() + "), falling back to the inputstream for polling");
        }
    }

    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
            this.inputStream = null;
        }
    }

    public String getContentType() {
        this.testContentType();
        return this.contentType;
    }

    private void testContentType() {
        if (this.contentType == null || this.contentType.indexOf("unknown") != -1) {
            Application application = Application.get();
            if (application instanceof WebApplication) {
                this.contentType = ((WebApplication)application).getServletContext().getMimeType(this.url.getFile());
                if (this.contentType == null) {
                    this.contentType = URLConnection.getFileNameMap().getContentTypeFor(this.url.getFile());
                }
            } else {
                this.contentType = URLConnection.getFileNameMap().getContentTypeFor(this.url.getFile());
            }
        }
    }

    public InputStream getInputStream() throws ResourceStreamNotFoundException {
        if (this.inputStream == null) {
            try {
                this.inputStream = this.url.openStream();
            }
            catch (IOException e) {
                throw new ResourceStreamNotFoundException("Resource " + this.url + " could not be opened", e);
            }
        }
        return this.inputStream;
    }

    public URL getURL() {
        return this.url;
    }

    public Time lastModifiedTime() {
        if (this.file != null) {
            if (!this.file.exists()) {
                return null;
            }
            long lastModified = this.file.lastModified();
            if (lastModified != this.lastModified) {
                this.lastModified = lastModified;
                this.contentLength = (int)this.file.length();
            }
        } else {
            try {
                long lastModified = Connections.getLastModified(this.url);
                if (lastModified != this.lastModified) {
                    this.lastModified = lastModified;
                    URLConnection connection = this.url.openConnection();
                    this.contentLength = connection.getContentLength();
                    Connections.close(connection);
                }
            }
            catch (IOException e) {
                if (this.url.toString().indexOf(".jar!") >= 0) {
                    if (log.isDebugEnabled()) {
                        log.debug("getLastModified for " + this.url + " failed: " + e.getMessage());
                    }
                } else {
                    log.warn("getLastModified for " + this.url + " failed: " + e.getMessage());
                }
                return null;
            }
        }
        return Time.milliseconds(this.lastModified);
    }

    public String toString() {
        return this.url.toString();
    }

    public long length() {
        return this.contentLength;
    }

    public String locationAsString() {
        return this.url.toExternalForm();
    }
}

