/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.tester;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.util.tester.WicketTester;

public class ExternalPageViewer {
    private static final List<String> browserPaths = new ArrayList<String>();
    private final WicketTester tester;

    public ExternalPageViewer(WicketTester tester) {
        this.tester = tester;
    }

    public static final void registerBrowserPath(String path) {
        browserPaths.add(path);
    }

    public final void viewInBrowser() {
        int webRootPathIndex = this.getThisClassFileURL().getPath().indexOf("/WEB-INF");
        String webRootPath = this.getThisClassFileURL().getPath().substring(0, webRootPathIndex);
        File temp = new File(webRootPath + "/" + this.getTemperaryDumpHtmlFileName());
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(temp);
            out.write(this.tester.getServletResponse().getDocument().getBytes(this.getHtmlEncoding()));
            out.flush();
        }
        catch (UnsupportedEncodingException e) {
            throw this.convertoUnexpect(e);
        }
        catch (IOException e) {
            throw this.convertoUnexpect(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw this.convertoUnexpect(e);
                }
            }
        }
        if (!new File(this.getBrowserPath()).exists()) {
            throw new IllegalStateException("No browser found at " + this.getBrowserPath());
        }
        throw new RuntimeException("Not yet supported");
    }

    private String getBrowserPath() {
        for (String path : browserPaths) {
            if (!new File(path).exists()) continue;
            return path;
        }
        throw new IllegalStateException("No browser found, please add definition");
    }

    protected String getTemperaryDumpHtmlFileName() {
        return ".del-wicketTestDump.html";
    }

    protected String getHtmlEncoding() {
        return "UTF-8";
    }

    private URL getThisClassFileURL() {
        URL url = this.getClass().getClassLoader().getResource(this.getClass().getName().replace('.', '/') + ".class");
        return url;
    }

    private RuntimeException convertoUnexpect(Exception e) {
        return new RuntimeException("tester: unexpect", e);
    }

    static {
        ExternalPageViewer.registerBrowserPath("C:/Program Files/Mozilla Firefox/firefox.exe");
        ExternalPageViewer.registerBrowserPath("C:/Program Files/Internet Explorer/iexplore.exe");
    }
}

