/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.tester;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.feedback.FeedbackMessagesModel;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.protocol.http.HttpSessionStore;
import org.apache.wicket.protocol.http.MockHttpServletResponse;
import org.apache.wicket.protocol.http.SecondLevelCacheSessionStore;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.session.ISessionStore;
import org.apache.wicket.util.diff.DiffUtil;
import org.apache.wicket.util.tester.BaseWicketTester;
import org.apache.wicket.util.tester.DummyHomePage;
import org.apache.wicket.util.tester.Result;
import org.apache.wicket.util.tester.WicketTesterHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WicketTester
extends BaseWicketTester {
    private static final Logger log = LoggerFactory.getLogger(WicketTester.class);

    public WicketTester() {
        this(new DummyWebApplication());
    }

    public WicketTester(final Class<? extends Page> homePage) {
        this(new WebApplication(){

            @Override
            public Class<? extends Page> getHomePage() {
                return homePage;
            }

            @Override
            protected ISessionStore newSessionStore() {
                return new HttpSessionStore(this);
            }

            @Override
            protected WebResponse newWebResponse(HttpServletResponse servletResponse) {
                return new WebResponse(servletResponse);
            }

            @Override
            protected void outputDevelopmentModeWarning() {
            }
        });
    }

    public WicketTester(WebApplication application) {
        this(application, null);
    }

    public WicketTester(WebApplication application, String path) {
        super(application, path);
    }

    public void assertAjaxLocation() {
        if (null != ((MockHttpServletResponse)this.getWicketResponse().getHttpServletResponse()).getRedirectLocation()) {
            throw new AssertionFailedError("Location header should *not* be present when using Ajax");
        }
        String ajaxLocation = ((MockHttpServletResponse)this.getWicketResponse().getHttpServletResponse()).getHeader("Ajax-Location");
        if (null == ajaxLocation) {
            throw new AssertionFailedError("Ajax-Location header should be present when using Ajax");
        }
        int statusCode = ((MockHttpServletResponse)this.getWicketResponse().getHttpServletResponse()).getStatus();
        if (statusCode != 200) {
            throw new AssertionFailedError("Expected HTTP status code to be 200 (OK)");
        }
    }

    public void assertComponent(String path, Class<? extends Component> expectedComponentClass) {
        this.assertResult(this.isComponent(path, expectedComponentClass));
    }

    public void assertComponentOnAjaxResponse(Component component) {
        Result result = this.isComponentOnAjaxResponse(component);
        this.assertResult(result);
    }

    public void assertComponentOnAjaxResponse(String componentPath) {
        this.assertComponentOnAjaxResponse(this.getComponentFromLastRenderedPage(componentPath));
    }

    public void assertContains(String pattern) {
        this.assertResult(this.ifContains(pattern));
    }

    public void assertErrorMessages(String[] expectedErrorMessages) {
        List<Serializable> actualMessages = this.getMessages(400);
        ArrayList<String> msgs = new ArrayList<String>();
        Iterator<Serializable> iterator = actualMessages.iterator();
        while (iterator.hasNext()) {
            msgs.add(iterator.next().toString());
        }
        WicketTesterHelper.assertEquals(Arrays.asList(expectedErrorMessages), msgs);
    }

    public void assertInfoMessages(String[] expectedInfoMessages) {
        List<Serializable> actualMessages = this.getMessages(200);
        WicketTesterHelper.assertEquals(Arrays.asList(expectedInfoMessages), actualMessages);
    }

    public void assertFeedback(String path, String[] messages) {
        FeedbackPanel fbp = (FeedbackPanel)this.getComponentFromLastRenderedPage(path);
        FeedbackMessagesModel model = fbp.getFeedbackMessagesModel();
        List renderedMessages = (List)model.getObject();
        if (renderedMessages == null) {
            this.fail("feedback panel at path [" + path + "] returned null messages");
        }
        if (messages.length != renderedMessages.size()) {
            this.fail("you expected " + messages.length + " messages for the feedback panel [" + path + "], but there were actually " + renderedMessages.size());
        }
        for (int i = 0; i < messages.length && i < renderedMessages.size(); ++i) {
            String expected = messages[i];
            String actual = ((FeedbackMessage)renderedMessages.get(i)).getMessage().toString();
            this.assertResult(this.isEqual(expected, actual));
        }
    }

    public void assertInvisible(String path) {
        this.assertResult(this.isInvisible(path));
    }

    public void assertLabel(String path, String expectedLabelText) {
        Label label = (Label)this.getComponentFromLastRenderedPage(path);
        Assert.assertEquals((String)expectedLabelText, (String)label.getDefaultModelObjectAsString());
    }

    public void assertModelValue(String path, Object expectedValue) {
        Component component = this.getComponentFromLastRenderedPage(path);
        Assert.assertEquals((Object)expectedValue, (Object)component.getDefaultModelObject());
    }

    @Override
    public void assertListView(String path, List<?> expectedList) {
        ListView listView = (ListView)this.getComponentFromLastRenderedPage(path);
        WicketTesterHelper.assertEquals(expectedList, listView.getList());
    }

    public void assertNoErrorMessage() {
        List<Serializable> messages = this.getMessages(400);
        Assert.assertTrue((String)("expect no error message, but contains\n" + WicketTesterHelper.asLined(messages)), (boolean)messages.isEmpty());
    }

    public void assertNoInfoMessage() {
        List<Serializable> messages = this.getMessages(200);
        Assert.assertTrue((String)("expect no info message, but contains\n" + WicketTesterHelper.asLined(messages)), (boolean)messages.isEmpty());
    }

    public void assertPageLink(String path, Class<? extends Page> expectedPageClass) {
        this.assertResult(this.isPageLink(path, expectedPageClass));
    }

    public void assertBookmarkablePageLink(String id, Class<? extends WebPage> pageClass, String parameters) {
        BookmarkablePageLink pageLink = null;
        try {
            pageLink = (BookmarkablePageLink)this.getComponentFromLastRenderedPage(id);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Component with id:" + id + " is not a BookmarkablePageLink");
        }
        Assert.assertEquals((String)("BookmarkablePageLink: " + id + " is pointing to the wrong page"), pageClass, pageLink.getPageClass());
        Assert.assertEquals((String)("One or more of the parameters associated with the BookmarkablePageLink: " + id + " do not match"), (Object)new PageParameters(parameters), (Object)pageLink.getPageParameters());
    }

    public void assertRenderedPage(Class<? extends Page> expectedRenderedPageClass) {
        this.assertResult(this.isRenderedPage(expectedRenderedPageClass));
    }

    @Override
    public void assertResultPage(Class<?> clazz, String filename) throws Exception {
        String document = this.getServletResponse().getDocument();
        DiffUtil.validatePage(document, clazz, filename, true);
    }

    public void assertResultPage(String expectedDocument) throws Exception {
        String document = this.getServletResponse().getDocument();
        Assert.assertEquals((String)expectedDocument, (String)document);
    }

    public void assertVisible(String path) {
        this.assertResult(this.isVisible(path));
    }

    public void assertEnabled(String path) {
        this.assertResult(this.isEnabled(path));
    }

    public void assertDisabled(String path) {
        this.assertResult(this.isDisabled(path));
    }

    public void assertRequired(String path) {
        this.assertResult(this.isRequired(path));
    }

    private void assertResult(Result result) {
        if (result.wasFailed()) {
            throw new AssertionFailedError(result.getMessage());
        }
    }

    public static class NonPageCachingDummyWebApplication
    extends DummyWebApplication {
        protected ISessionStore newSessionStore() {
            return new SecondLevelCacheSessionStore(this, new SecondLevelCacheSessionStore.IPageStore(){

                public void destroy() {
                }

                public Page getPage(String sessionId, String pagemap, int id, int versionNumber, int ajaxVersionNumber) {
                    return null;
                }

                public void pageAccessed(String sessionId, Page page) {
                }

                public void removePage(String sessionId, String pagemap, int id) {
                }

                public void storePage(String sessionId, Page page) {
                }

                public void unbind(String sessionId) {
                }

                public boolean containsPage(String sessionId, String pageMapName, int pageId, int pageVersion) {
                    return false;
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DummyWebApplication
    extends WebApplication {
        @Override
        public Class<? extends Page> getHomePage() {
            return DummyHomePage.class;
        }

        @Override
        protected ISessionStore newSessionStore() {
            return new HttpSessionStore(this);
        }

        @Override
        protected WebResponse newWebResponse(HttpServletResponse servletResponse) {
            return new WebResponse(servletResponse);
        }

        @Override
        protected void outputDevelopmentModeWarning() {
        }
    }
}

