/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.validation.validator;

import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.validator.AbstractValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreditCardValidator
extends AbstractValidator<String> {
    private static final long serialVersionUID = 1L;
    private String creditCardNumber = null;
    private int cardId = -1;
    public static final int INVALID = -1;
    public static final int AMERICAN_EXPRESS = 0;
    public static final int CHINA_UNIONPAY = 1;
    public static final int DINERS_CLUB_CARTE_BLANCHE = 2;
    public static final int DINERS_CLUB_INTERNATIONAL = 3;
    public static final int DINERS_CLUB_US_AND_CANADA = 4;
    public static final int DISCOVER_CARD = 5;
    public static final int JCB = 6;
    public static final int LASER = 7;
    public static final int MAESTRO = 8;
    public static final int MASTERCARD = 9;
    public static final int SOLO = 10;
    public static final int SWITCH = 11;
    public static final int VISA = 12;
    public static final int VISA_ELECTRON = 13;
    private static final String[] creditCardNames = new String[]{"American Express", "China UnionPay", "Diners Club Carte Blanche", "Diners Club International", "Diners Club US & Canada", "Discover Card", "JCB", "Laser", "Maestro", "MasterCard", "Solo", "Switch", "Visa", "Visa Electron"};

    @Override
    protected void onValidate(IValidatable<String> validatable) {
        this.creditCardNumber = validatable.getValue();
        try {
            if (!this.isLengthAndPrefixCorrect(this.creditCardNumber)) {
                this.error(validatable);
            }
        }
        catch (NumberFormatException _) {
            this.error(validatable);
        }
    }

    private boolean isLengthAndPrefixCorrect(String creditCardNumber) {
        if (creditCardNumber != null) {
            creditCardNumber = creditCardNumber.replaceAll("[ -]", "");
        }
        if (creditCardNumber != null && creditCardNumber.length() >= 12 && creditCardNumber.length() <= 19) {
            if (this.isAmericanExpress(creditCardNumber)) {
                return true;
            }
            if (this.isChinaUnionPay(creditCardNumber)) {
                return true;
            }
            if (this.isDinersClubCarteBlanche(creditCardNumber)) {
                return true;
            }
            if (this.isDinersClubInternational(creditCardNumber)) {
                return true;
            }
            if (this.isDinersClubUsAndCanada(creditCardNumber)) {
                return true;
            }
            if (this.isDiscoverCard(creditCardNumber)) {
                return true;
            }
            if (this.isJCB(creditCardNumber)) {
                return true;
            }
            if (this.isLaser(creditCardNumber)) {
                return true;
            }
            if (this.isMaestro(creditCardNumber)) {
                return true;
            }
            if (this.isMastercard(creditCardNumber)) {
                return true;
            }
            if (this.isSolo(creditCardNumber)) {
                return true;
            }
            if (this.isSwitch(creditCardNumber)) {
                return true;
            }
            if (this.isVisa(creditCardNumber)) {
                return true;
            }
            if (this.isVisaElectron(creditCardNumber)) {
                return true;
            }
            if (this.isUnknown(creditCardNumber)) {
                return true;
            }
        }
        return false;
    }

    protected boolean isUnknown(String creditCardNumber) {
        return false;
    }

    private boolean isAmericanExpress(String creditCardNumber) {
        this.cardId = -1;
        boolean returnValue = false;
        if (creditCardNumber.length() == 15 && (creditCardNumber.startsWith("34") || creditCardNumber.startsWith("37")) && this.isChecksumCorrect(creditCardNumber)) {
            this.cardId = 0;
            returnValue = true;
        }
        return returnValue;
    }

    private boolean isChinaUnionPay(String creditCardNumber) {
        int firstDigits;
        this.cardId = -1;
        boolean returnValue = false;
        if (creditCardNumber.length() >= 16 && creditCardNumber.length() <= 19 && creditCardNumber.startsWith("622") && (firstDigits = Integer.parseInt(creditCardNumber.substring(0, 5))) >= 622126 && firstDigits <= 622925) {
            this.cardId = 1;
            returnValue = true;
        }
        return returnValue;
    }

    private boolean isDinersClubCarteBlanche(String creditCardNumber) {
        int firstDigits;
        this.cardId = -1;
        boolean returnValue = false;
        if (creditCardNumber.length() == 14 && creditCardNumber.startsWith("30") && (firstDigits = Integer.parseInt(creditCardNumber.substring(0, 3))) >= 300 && firstDigits <= 305 && this.isChecksumCorrect(creditCardNumber)) {
            this.cardId = 2;
            returnValue = true;
        }
        return returnValue;
    }

    private boolean isDinersClubInternational(String creditCardNumber) {
        this.cardId = -1;
        boolean returnValue = false;
        if (creditCardNumber.length() == 14 && creditCardNumber.startsWith("36") && this.isChecksumCorrect(creditCardNumber)) {
            this.cardId = 3;
            returnValue = true;
        }
        return returnValue;
    }

    private boolean isDinersClubUsAndCanada(String creditCardNumber) {
        this.cardId = -1;
        boolean returnValue = false;
        if (creditCardNumber.length() == 16 && (creditCardNumber.startsWith("54") || creditCardNumber.startsWith("55")) && this.isChecksumCorrect(creditCardNumber)) {
            this.cardId = 4;
            returnValue = true;
        }
        return returnValue;
    }

    private boolean isDiscoverCard(String creditCardNumber) {
        this.cardId = -1;
        boolean returnValue = false;
        if (creditCardNumber.length() == 16 && creditCardNumber.startsWith("6") && this.isChecksumCorrect(creditCardNumber)) {
            int firstThreeDigits = Integer.parseInt(creditCardNumber.substring(0, 3));
            int firstSixDigits = Integer.parseInt(creditCardNumber.substring(0, 6));
            if (creditCardNumber.startsWith("6011") || creditCardNumber.startsWith("65") || firstThreeDigits >= 644 && firstThreeDigits <= 649 || firstSixDigits >= 622126 && firstSixDigits <= 622925) {
                this.cardId = 5;
                returnValue = true;
            }
        }
        return returnValue;
    }

    private boolean isJCB(String creditCardNumber) {
        int firstFourDigits;
        this.cardId = -1;
        boolean returnValue = false;
        if (creditCardNumber.length() == 16 && this.isChecksumCorrect(creditCardNumber) && (firstFourDigits = Integer.parseInt(creditCardNumber.substring(0, 4))) >= 3528 && firstFourDigits <= 3589) {
            this.cardId = 6;
            returnValue = true;
        }
        return returnValue;
    }

    private boolean isLaser(String creditCardNumber) {
        this.cardId = -1;
        boolean returnValue = false;
        if (creditCardNumber.length() >= 16 && creditCardNumber.length() <= 19 && this.isChecksumCorrect(creditCardNumber) && (creditCardNumber.startsWith("6304") || creditCardNumber.startsWith("6706") || creditCardNumber.startsWith("6771") || creditCardNumber.startsWith("6709"))) {
            this.cardId = 7;
            returnValue = true;
        }
        return returnValue;
    }

    private boolean isMaestro(String creditCardNumber) {
        this.cardId = -1;
        boolean returnValue = false;
        if (creditCardNumber.length() >= 12 && creditCardNumber.length() <= 19 && this.isChecksumCorrect(creditCardNumber) && (creditCardNumber.startsWith("5018") || creditCardNumber.startsWith("5020") || creditCardNumber.startsWith("5038") || creditCardNumber.startsWith("6304") || creditCardNumber.startsWith("6759") || creditCardNumber.startsWith("6761") || creditCardNumber.startsWith("6763"))) {
            this.cardId = 8;
            returnValue = true;
        }
        return returnValue;
    }

    private boolean isSolo(String creditCardNumber) {
        this.cardId = -1;
        boolean returnValue = false;
        if ((creditCardNumber.length() == 16 || creditCardNumber.length() == 18 || creditCardNumber.length() == 19) && this.isChecksumCorrect(creditCardNumber) && (creditCardNumber.startsWith("6334") || creditCardNumber.startsWith("6767"))) {
            this.cardId = 10;
            returnValue = true;
        }
        return returnValue;
    }

    private boolean isSwitch(String creditCardNumber) {
        this.cardId = -1;
        boolean returnValue = false;
        if ((creditCardNumber.length() == 16 || creditCardNumber.length() == 18 || creditCardNumber.length() == 19) && this.isChecksumCorrect(creditCardNumber) && (creditCardNumber.startsWith("4903") || creditCardNumber.startsWith("4905") || creditCardNumber.startsWith("4911") || creditCardNumber.startsWith("4936") || creditCardNumber.startsWith("564182") || creditCardNumber.startsWith("633110") || creditCardNumber.startsWith("6333") || creditCardNumber.startsWith("6759"))) {
            this.cardId = 11;
            returnValue = true;
        }
        return returnValue;
    }

    private boolean isVisa(String creditCardNumber) {
        this.cardId = -1;
        boolean returnValue = false;
        if ((creditCardNumber.length() == 13 || creditCardNumber.length() == 16) && creditCardNumber.startsWith("4")) {
            this.cardId = 11;
            returnValue = true;
        }
        return returnValue;
    }

    private boolean isVisaElectron(String creditCardNumber) {
        this.cardId = -1;
        boolean returnValue = false;
        if (creditCardNumber.length() == 16 && (creditCardNumber.startsWith("417500") || creditCardNumber.startsWith("4917") || creditCardNumber.startsWith("4913") || creditCardNumber.startsWith("4508") || creditCardNumber.startsWith("4844"))) {
            this.cardId = 13;
            returnValue = true;
        }
        return returnValue;
    }

    private boolean isMastercard(String creditCardNumber) {
        int firstTwoDigits;
        this.cardId = -1;
        boolean returnValue = false;
        if (creditCardNumber.length() == 16 && this.isChecksumCorrect(creditCardNumber) && (firstTwoDigits = Integer.parseInt(creditCardNumber.substring(0, 2))) >= 51 && firstTwoDigits <= 55) {
            this.cardId = 9;
            returnValue = true;
        }
        return returnValue;
    }

    private String getCardName() {
        return this.cardId > -1 && this.cardId < creditCardNames.length ? creditCardNames[this.cardId] : "";
    }

    private boolean isChecksumCorrect(String creditCardNumber) {
        String input = creditCardNumber;
        String numberToCheck = input.replaceAll("[ -]", "");
        int nulOffset = 48;
        int sum = 0;
        for (int i = 1; i <= numberToCheck.length(); ++i) {
            int currentDigit = numberToCheck.charAt(numberToCheck.length() - i) - nulOffset;
            if (i % 2 == 0) {
                currentDigit = (currentDigit *= 2) > 9 ? currentDigit - 9 : currentDigit;
                sum += currentDigit;
                continue;
            }
            sum += currentDigit;
        }
        return sum % 10 == 0;
    }
}

