/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.Locale;
import org.jboss.as.controller.AbstractModelUpdateHandler;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class NamespaceAddHandler
extends AbstractModelUpdateHandler
implements DescriptionProvider {
    public static final String OPERATION_NAME = "add-namespace";
    public static final NamespaceAddHandler INSTANCE = new NamespaceAddHandler();
    private final ParameterValidator validator = new ModelTypeValidator(ModelType.STRING);

    public static ModelNode getAddNamespaceOperation(ModelNode address, String prefix, String uri) {
        ModelNode op = new ModelNode();
        op.get("operation").set(OPERATION_NAME);
        op.get("address").set(address);
        op.get("namespace").set(prefix);
        op.get("uri").set(uri);
        return op;
    }

    private NamespaceAddHandler() {
    }

    @Override
    protected void updateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        ModelNode ns = operation.get("namespace");
        ModelNode uri = operation.get("uri");
        ModelNode namespaces = model.get("namespaces");
        this.validate(ns, uri, namespaces);
        namespaces.add(ns.asString(), uri.asString());
    }

    @Override
    protected boolean requiresRuntime(OperationContext context) {
        return false;
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        return CommonDescriptions.getAddNamespaceOperation(locale);
    }

    private void validate(ModelNode namespace, ModelNode uri, ModelNode namespaces) throws OperationFailedException {
        this.validator.validateParameter("namespace", namespace);
        this.validator.validateParameter("uri", uri);
        if (namespaces.isDefined()) {
            String namespaceString = namespace.asString();
            for (ModelNode node : namespaces.asList()) {
                if (!namespaceString.equals(node.asProperty().getName())) continue;
                throw new OperationFailedException(new ModelNode().set(ControllerMessages.MESSAGES.namespaceAlreadyRegistered(namespaceString, node.asProperty().getValue().asString())));
            }
        }
    }
}

