/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.AbstractPluginService;
import org.jboss.osgi.framework.internal.BundleManager;
import org.jboss.osgi.framework.internal.InternalServices;
import org.jboss.osgi.framework.internal.ServiceState;
import org.jboss.osgi.framework.util.NoFilter;
import org.jboss.osgi.framework.util.RemoveOnlyCollection;
import org.jboss.osgi.spi.ConstantsHelper;
import org.osgi.framework.AllServiceListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.hooks.service.EventHook;
import org.osgi.framework.hooks.service.ListenerHook;

final class FrameworkEventsPlugin
extends AbstractPluginService<FrameworkEventsPlugin> {
    final Logger log = Logger.getLogger(FrameworkEventsPlugin.class);
    private final InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();
    private final InjectedValue<BundleContext> injectedSystemContext = new InjectedValue();
    private final Map<AbstractBundleState, List<BundleListener>> bundleListeners = new ConcurrentHashMap<AbstractBundleState, List<BundleListener>>();
    private final Map<AbstractBundleState, List<FrameworkListener>> frameworkListeners = new ConcurrentHashMap<AbstractBundleState, List<FrameworkListener>>();
    private final Map<AbstractBundleState, List<ServiceListenerRegistration>> serviceListeners = new ConcurrentHashMap<AbstractBundleState, List<ServiceListenerRegistration>>();
    private Set<Integer> asyncBundleEvents = new HashSet<Integer>();
    private Set<String> infoEvents = new HashSet<String>();
    private final ExecutorService bundleEventExecutor;
    private final ExecutorService frameworkEventExecutor;

    static void addService(ServiceTarget serviceTarget) {
        FrameworkEventsPlugin service = new FrameworkEventsPlugin();
        ServiceBuilder builder = serviceTarget.addService(InternalServices.FRAMEWORK_EVENTS_PLUGIN, (Service)service);
        builder.addDependency(Services.BUNDLE_MANAGER, BundleManager.class, service.injectedBundleManager);
        builder.addDependency(Services.SYSTEM_CONTEXT, BundleContext.class, service.injectedSystemContext);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
    }

    private FrameworkEventsPlugin() {
        this.asyncBundleEvents.add(new Integer(1));
        this.asyncBundleEvents.add(new Integer(32));
        this.asyncBundleEvents.add(new Integer(2));
        this.asyncBundleEvents.add(new Integer(4));
        this.asyncBundleEvents.add(new Integer(8));
        this.asyncBundleEvents.add(new Integer(64));
        this.asyncBundleEvents.add(new Integer(16));
        this.infoEvents.add(ConstantsHelper.frameworkEvent((int)4));
        this.infoEvents.add(ConstantsHelper.frameworkEvent((int)2));
        this.infoEvents.add(ConstantsHelper.frameworkEvent((int)16));
        this.infoEvents.add(ConstantsHelper.frameworkEvent((int)32));
        this.infoEvents.add(ConstantsHelper.bundleEvent((int)1));
        this.infoEvents.add(ConstantsHelper.bundleEvent((int)2));
        this.infoEvents.add(ConstantsHelper.bundleEvent((int)4));
        this.infoEvents.add(ConstantsHelper.bundleEvent((int)16));
        this.bundleEventExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable run) {
                Thread thread = new Thread(run);
                thread.setName("OSGi BundleEvent Thread");
                thread.setDaemon(true);
                return thread;
            }
        });
        this.frameworkEventExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable run) {
                Thread thread = new Thread(run);
                thread.setName("OSGi FrameworkEvent Thread");
                thread.setDaemon(true);
                return thread;
            }
        });
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
    }

    @Override
    public void stop(StopContext context) {
        super.stop(context);
        this.bundleListeners.clear();
        this.serviceListeners.clear();
        this.frameworkListeners.clear();
    }

    public FrameworkEventsPlugin getValue() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addBundleListener(AbstractBundleState bundleState, BundleListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener");
        }
        Map<AbstractBundleState, List<BundleListener>> map = this.bundleListeners;
        synchronized (map) {
            List<BundleListener> listeners = this.bundleListeners.get(bundleState);
            if (listeners == null) {
                listeners = new CopyOnWriteArrayList<BundleListener>();
                this.bundleListeners.put(bundleState, listeners);
            }
            if (!listeners.contains(listener)) {
                listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeBundleListener(AbstractBundleState bundleState, BundleListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener");
        }
        Map<AbstractBundleState, List<BundleListener>> map = this.bundleListeners;
        synchronized (map) {
            List<BundleListener> listeners = this.bundleListeners.get(bundleState);
            if (listeners != null) {
                if (listeners.size() > 1) {
                    listeners.remove(listener);
                } else {
                    this.removeBundleListeners(bundleState);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeBundleListeners(AbstractBundleState bundleState) {
        Map<AbstractBundleState, List<BundleListener>> map = this.bundleListeners;
        synchronized (map) {
            this.bundleListeners.remove(bundleState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFrameworkListener(AbstractBundleState bundleState, FrameworkListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener");
        }
        Map<AbstractBundleState, List<FrameworkListener>> map = this.frameworkListeners;
        synchronized (map) {
            List<FrameworkListener> listeners = this.frameworkListeners.get(bundleState);
            if (listeners == null) {
                listeners = new CopyOnWriteArrayList<FrameworkListener>();
                this.frameworkListeners.put(bundleState, listeners);
            }
            if (!listeners.contains(listener)) {
                listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFrameworkListener(AbstractBundleState bundleState, FrameworkListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener");
        }
        Map<AbstractBundleState, List<FrameworkListener>> map = this.frameworkListeners;
        synchronized (map) {
            List<FrameworkListener> listeners = this.frameworkListeners.get(bundleState);
            if (listeners != null) {
                if (listeners.size() > 1) {
                    listeners.remove(listener);
                } else {
                    this.removeFrameworkListeners(bundleState);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFrameworkListeners(AbstractBundleState bundleState) {
        Map<AbstractBundleState, List<FrameworkListener>> map = this.frameworkListeners;
        synchronized (map) {
            this.frameworkListeners.remove(bundleState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addServiceListener(AbstractBundleState bundleState, ServiceListener listener, String filterstr) throws InvalidSyntaxException {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener");
        }
        Map<AbstractBundleState, List<ServiceListenerRegistration>> map = this.serviceListeners;
        synchronized (map) {
            List<ServiceListenerRegistration> listeners = this.serviceListeners.get(bundleState);
            if (listeners == null) {
                listeners = new CopyOnWriteArrayList<ServiceListenerRegistration>();
                this.serviceListeners.put(bundleState, listeners);
            }
            this.removeServiceListener(bundleState, listener);
            Filter filter = filterstr != null ? FrameworkUtil.createFilter((String)filterstr) : NoFilter.INSTANCE;
            ServiceListenerRegistration slreg = new ServiceListenerRegistration(bundleState, listener, filter);
            for (ListenerHook hook : this.getServiceListenerHooks()) {
                try {
                    hook.added(Collections.singleton(slreg.getListenerInfo()));
                }
                catch (RuntimeException ex) {
                    this.log.errorf((Throwable)ex, "Error processing ListenerHook: %s", (Object)hook);
                }
            }
            listeners.add(slreg);
        }
    }

    Collection<ListenerHook.ListenerInfo> getServiceListenerInfos(AbstractBundleState bundleState) {
        ArrayList<ListenerHook.ListenerInfo> listeners = new ArrayList<ListenerHook.ListenerInfo>();
        for (Map.Entry<AbstractBundleState, List<ServiceListenerRegistration>> entry : this.serviceListeners.entrySet()) {
            if (bundleState != null && !bundleState.equals(entry.getKey())) continue;
            for (ServiceListenerRegistration aux : entry.getValue()) {
                ListenerHook.ListenerInfo info = aux.getListenerInfo();
                listeners.add(info);
            }
        }
        return Collections.unmodifiableCollection(listeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeServiceListener(AbstractBundleState bundleState, ServiceListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener");
        }
        Map<AbstractBundleState, List<ServiceListenerRegistration>> map = this.serviceListeners;
        synchronized (map) {
            ServiceListenerRegistration slreg;
            int index;
            List<ServiceListenerRegistration> listeners = this.serviceListeners.get(bundleState);
            if (listeners != null && (index = listeners.indexOf(slreg = new ServiceListenerRegistration(bundleState, listener, NoFilter.INSTANCE))) >= 0) {
                slreg = listeners.remove(index);
                for (ListenerHook hook : this.getServiceListenerHooks()) {
                    try {
                        ListenerInfoImpl info = (ListenerInfoImpl)slreg.getListenerInfo();
                        info.setRemoved(true);
                        hook.removed(Collections.singleton(info));
                    }
                    catch (RuntimeException ex) {
                        this.log.errorf((Throwable)ex, "Error processing ListenerHook: %s", (Object)hook);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeServiceListeners(AbstractBundleState bundleState) {
        Map<AbstractBundleState, List<ServiceListenerRegistration>> map = this.serviceListeners;
        synchronized (map) {
            Collection<ListenerHook.ListenerInfo> listenerInfos = this.getServiceListenerInfos(bundleState);
            this.serviceListeners.remove(bundleState);
            for (ListenerHook hook : this.getServiceListenerHooks()) {
                try {
                    hook.removed(listenerInfos);
                }
                catch (RuntimeException ex) {
                    this.log.errorf((Throwable)ex, "Error processing ListenerHook: %s", (Object)hook);
                }
            }
        }
    }

    private List<ListenerHook> getServiceListenerHooks() {
        BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
        if (!bundleManager.isFrameworkActive()) {
            return Collections.emptyList();
        }
        BundleContext context = (BundleContext)this.injectedSystemContext.getValue();
        ServiceReference[] srefs = null;
        try {
            srefs = context.getServiceReferences(ListenerHook.class.getName(), null);
        }
        catch (InvalidSyntaxException e) {
            // empty catch block
        }
        if (srefs == null) {
            return Collections.emptyList();
        }
        ArrayList<ListenerHook> hooks = new ArrayList<ListenerHook>();
        for (ServiceReference sref : srefs) {
            hooks.add((ListenerHook)context.getService(sref));
        }
        return Collections.unmodifiableList(hooks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireBundleEvent(final AbstractBundleState bundleState, final int type) {
        final ArrayList<BundleListener> listeners = new ArrayList<BundleListener>();
        Map<AbstractBundleState, List<BundleListener>> map = this.bundleListeners;
        synchronized (map) {
            for (Map.Entry<AbstractBundleState, List<BundleListener>> entry : this.bundleListeners.entrySet()) {
                for (BundleListener listener : entry.getValue()) {
                    listeners.add(listener);
                }
            }
        }
        final BundleEventImpl event = new BundleEventImpl(type, bundleState);
        final String typeName = ConstantsHelper.bundleEvent((int)event.getType());
        this.log.tracef("AbstractBundleState %s: %s", (Object)typeName, (Object)bundleState);
        BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
        if (!bundleManager.isFrameworkActive()) {
            return;
        }
        if (listeners.isEmpty()) {
            return;
        }
        for (BundleListener listener : listeners) {
            try {
                if (!(listener instanceof SynchronousBundleListener)) continue;
                listener.bundleChanged((BundleEvent)event);
            }
            catch (Throwable th) {
                this.log.warnf(th, "Error while firing %s for bundleState: %s", (Object)typeName, (Object)bundleState);
            }
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (FrameworkEventsPlugin.this.asyncBundleEvents.contains(type)) {
                    for (BundleListener listener : listeners) {
                        try {
                            if (listener instanceof SynchronousBundleListener) continue;
                            listener.bundleChanged(event);
                        }
                        catch (Throwable th) {
                            FrameworkEventsPlugin.this.log.warnf(th, "Error while firing %s for bundleState: ", (Object)typeName, (Object)bundleState);
                        }
                    }
                }
            }
        };
        this.bundleEventExecutor.execute(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireFrameworkEvent(final AbstractBundleState bundleState, final int type, Throwable th) {
        final ArrayList<FrameworkListener> listeners = new ArrayList<FrameworkListener>();
        Map<AbstractBundleState, List<FrameworkListener>> map = this.frameworkListeners;
        synchronized (map) {
            for (Map.Entry<AbstractBundleState, List<FrameworkListener>> entry : this.frameworkListeners.entrySet()) {
                for (FrameworkListener listener : entry.getValue()) {
                    listeners.add(listener);
                }
            }
        }
        final FrameworkEventImpl event = new FrameworkEventImpl(type, bundleState, th);
        final String typeName = ConstantsHelper.frameworkEvent((int)event.getType());
        switch (event.getType()) {
            case 2: {
                this.log.errorf(th, "Framework %s", (Object)typeName);
                break;
            }
            case 16: {
                this.log.warnf(th, "Framework %s", (Object)typeName);
                break;
            }
            default: {
                this.log.tracef(th, "Framework %s", (Object)typeName);
            }
        }
        BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
        if (!bundleManager.isFrameworkActive()) {
            return;
        }
        if (listeners.isEmpty()) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (FrameworkListener listener : listeners) {
                    try {
                        listener.frameworkEvent(event);
                    }
                    catch (RuntimeException ex) {
                        FrameworkEventsPlugin.this.log.warnf((Throwable)ex, "Error while firing %s for framework", (Object)typeName);
                        if (type == 2) continue;
                        FrameworkEventsPlugin.this.fireFrameworkEvent(bundleState, 2, ex);
                    }
                    catch (Throwable th) {
                        FrameworkEventsPlugin.this.log.warnf(th, "Error while firing %s for framework", (Object)typeName);
                    }
                }
            }
        };
        this.frameworkEventExecutor.execute(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireServiceEvent(AbstractBundleState bundleState, int type, ServiceState serviceState) {
        List<ServiceListenerRegistration> listenerRegs = new ArrayList<ServiceListenerRegistration>();
        Map<AbstractBundleState, List<ServiceListenerRegistration>> map = this.serviceListeners;
        synchronized (map) {
            for (Map.Entry<AbstractBundleState, List<ServiceListenerRegistration>> entry : this.serviceListeners.entrySet()) {
                for (ServiceListenerRegistration listener : entry.getValue()) {
                    BundleContext context = listener.getBundleContext();
                    if (context == null) continue;
                    listenerRegs.add(listener);
                }
            }
        }
        ServiceEventImpl event = new ServiceEventImpl(type, serviceState);
        String typeName = ConstantsHelper.serviceEvent((int)event.getType());
        this.log.tracef("Service %s: %s", (Object)typeName, (Object)serviceState);
        BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
        if (!bundleManager.isFrameworkActive()) {
            return;
        }
        BundleContext systemContext = (BundleContext)this.injectedSystemContext.getValue();
        listenerRegs = this.processEventHooks(systemContext, listenerRegs, event);
        if (listenerRegs.isEmpty()) {
            return;
        }
        for (ServiceListenerRegistration listenerReg : listenerRegs) {
            if (!listenerReg.isAllServiceListener()) {
                String[] clazzes;
                AbstractBundleState owner = listenerReg.getBundleState();
                boolean assignableToOwner = true;
                for (String clazz : clazzes = (String[])serviceState.getProperty("objectClass")) {
                    if (serviceState.isAssignableTo(owner, clazz)) continue;
                    assignableToOwner = false;
                    break;
                }
                if (!assignableToOwner) continue;
            }
            try {
                String filterstr = listenerReg.filter.toString();
                if (listenerReg.filter.match((ServiceReference)serviceState)) {
                    listenerReg.listener.serviceChanged((ServiceEvent)event);
                    continue;
                }
                if (filterstr == null || 2 != event.getType() || !listenerReg.filter.match(serviceState.getPreviousProperties())) continue;
                event = new ServiceEventImpl(8, serviceState);
                listenerReg.listener.serviceChanged((ServiceEvent)event);
            }
            catch (Throwable th) {
                this.log.warnf(th, "Error while firing %s for service: %s", (Object)typeName, (Object)serviceState);
            }
        }
    }

    private List<ServiceListenerRegistration> processEventHooks(BundleContext systemContext, List<ServiceListenerRegistration> listeners, ServiceEvent event) {
        Collection<BundleContext> contexts = new HashSet();
        for (ServiceListenerRegistration listener : listeners) {
            BundleContext context = listener.getBundleContext();
            if (context == null) continue;
            contexts.add(context);
        }
        contexts = new RemoveOnlyCollection(contexts);
        List<EventHook> eventHooks = this.getEventHooks(systemContext);
        for (EventHook hook : eventHooks) {
            try {
                hook.event(event, contexts);
            }
            catch (Exception ex) {
                this.log.warnf((Throwable)ex, "Error while calling EventHook: %s", (Object)hook);
            }
        }
        if (contexts.size() != listeners.size()) {
            Iterator<ServiceListenerRegistration> it = listeners.iterator();
            while (it.hasNext()) {
                ServiceListenerRegistration slreg = it.next();
                if (contexts.contains(slreg.getBundleContext())) continue;
                it.remove();
            }
        }
        return listeners;
    }

    private List<EventHook> getEventHooks(BundleContext systemContext) {
        ArrayList<EventHook> hooks = new ArrayList<EventHook>();
        ServiceReference[] srefs = null;
        try {
            srefs = systemContext.getServiceReferences(EventHook.class.getName(), null);
        }
        catch (InvalidSyntaxException e) {
            // empty catch block
        }
        if (srefs != null) {
            ArrayList<ServiceReference> sortedRefs = new ArrayList<ServiceReference>(Arrays.asList(srefs));
            Collections.reverse(sortedRefs);
            for (ServiceReference sref : sortedRefs) {
                hooks.add((EventHook)systemContext.getService(sref));
            }
        }
        return hooks;
    }

    static class ServiceEventImpl
    extends ServiceEvent {
        private static final long serialVersionUID = 62018288275708239L;

        public ServiceEventImpl(int type, ServiceState serviceState) {
            super(type, serviceState.getReference());
        }

        public String toString() {
            return "ServiceEvent[type=" + ConstantsHelper.serviceEvent((int)this.getType()) + ",source=" + this.getSource() + "]";
        }
    }

    static class BundleEventImpl
    extends BundleEvent {
        private static final long serialVersionUID = -2705304702665185935L;

        public BundleEventImpl(int type, AbstractBundleState bundleState) {
            super(type, (Bundle)bundleState);
        }

        public String toString() {
            return "BundleEvent[type=" + ConstantsHelper.bundleEvent((int)this.getType()) + ",source=" + this.getSource() + "]";
        }
    }

    static class FrameworkEventImpl
    extends FrameworkEvent {
        private static final long serialVersionUID = 6505331543651318189L;

        public FrameworkEventImpl(int type, AbstractBundleState bundleState, Throwable throwable) {
            super(type, (Bundle)bundleState, throwable);
        }

        public String toString() {
            return "FrameworkEvent[type=" + ConstantsHelper.frameworkEvent((int)this.getType()) + ",source=" + this.getSource() + "]";
        }
    }

    static class ListenerInfoImpl
    implements ListenerHook.ListenerInfo {
        private BundleContext context;
        private ServiceListener listener;
        private String filter;
        private boolean removed;

        ListenerInfoImpl(ServiceListenerRegistration slreg) {
            this.context = slreg.bundleState.getBundleContext();
            this.listener = slreg.listener;
            this.filter = slreg.filter.toString();
        }

        public BundleContext getBundleContext() {
            return this.context;
        }

        public String getFilter() {
            return this.filter;
        }

        public boolean isRemoved() {
            return this.removed;
        }

        public void setRemoved(boolean removed) {
            this.removed = removed;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        public String toString() {
            String className = this.listener.getClass().getName();
            return "ListenerInfo[" + this.context + "," + className + "," + this.removed + "]";
        }
    }

    static class ServiceListenerRegistration {
        private AbstractBundleState bundleState;
        private ServiceListener listener;
        private Filter filter;
        private ListenerHook.ListenerInfo info;
        AccessControlContext accessControlContext;

        ServiceListenerRegistration(AbstractBundleState bundleState, ServiceListener listener, Filter filter) {
            if (bundleState == null) {
                throw new IllegalArgumentException("Null bundleState");
            }
            if (listener == null) {
                throw new IllegalArgumentException("Null listener");
            }
            if (filter == null) {
                throw new IllegalArgumentException("Null filter");
            }
            this.bundleState = bundleState;
            this.listener = listener;
            this.filter = filter;
            this.info = new ListenerInfoImpl(this);
            if (System.getSecurityManager() != null) {
                this.accessControlContext = AccessController.getContext();
            }
        }

        AbstractBundleState getBundleState() {
            return this.bundleState;
        }

        BundleContext getBundleContext() {
            return this.bundleState.getBundleContext();
        }

        ListenerHook.ListenerInfo getListenerInfo() {
            return this.info;
        }

        boolean isAllServiceListener() {
            return this.listener instanceof AllServiceListener;
        }

        public int hashCode() {
            return this.listener.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ServiceListenerRegistration)) {
                return false;
            }
            ServiceListenerRegistration other = (ServiceListenerRegistration)obj;
            return other.listener.equals(this.listener);
        }

        public String toString() {
            String className = this.listener.getClass().getName();
            return "ServiceListener[" + this.bundleState + "," + className + "," + this.filter + "]";
        }
    }
}

