/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.Stack;
import org.jboss.logging.Logger;
import org.jboss.osgi.framework.internal.HostBundleState;

final class LazyActivationTracker {
    static final Logger log = Logger.getLogger(LazyActivationTracker.class);
    private static final ThreadLocal<Stack<HostBundleState>> stackAssociation = new ThreadLocal();
    private static final ThreadLocal<HostBundleState> initiatorAssociation = new ThreadLocal();

    LazyActivationTracker() {
    }

    static void startTracking(HostBundleState hostBundle, String className) {
        log.tracef("startTracking %s from: %s", (Object)className, (Object)hostBundle);
        initiatorAssociation.set(hostBundle);
    }

    static void processLoadedClass(Class<?> loadedClass) {
        if (initiatorAssociation.get() == null) {
            throw new IllegalStateException("No activation initiator");
        }
        log.tracef("processLoadedClass: %s", (Object)loadedClass.getName());
        LazyActivationTracker.processActivationStack();
    }

    static void preDefineClass(HostBundleState hostBundle, String className) {
        log.tracef("preDefineClass %s from: %s", (Object)className, (Object)hostBundle);
        LazyActivationTracker.addDefinedClass(hostBundle, className);
    }

    static void postDefineClass(HostBundleState hostBundle, Class<?> definedClass) {
        log.tracef("postDefineClass %s from: %s", (Object)definedClass.getName(), (Object)hostBundle);
        if (initiatorAssociation.get() == null) {
            LazyActivationTracker.processActivationStack();
        }
    }

    static void stopTracking(HostBundleState hostBundle, String className) {
        log.tracef("stopTracking %s from: %s", (Object)className, (Object)hostBundle);
        initiatorAssociation.remove();
        stackAssociation.remove();
    }

    private static void addDefinedClass(HostBundleState hostBundle, String className) {
        if (hostBundle.awaitLazyActivation() && !hostBundle.isAlreadyStarting()) {
            Stack<HostBundleState> stack = stackAssociation.get();
            if (stack == null) {
                stack = new Stack();
                stackAssociation.set(stack);
            }
            if (!stack.contains(hostBundle)) {
                log.tracef("addDefinedClass %s from: %s", (Object)className, (Object)hostBundle);
                stack.push(hostBundle);
            }
        }
    }

    private static void processActivationStack() {
        Stack<HostBundleState> stack = stackAssociation.get();
        if (stack != null) {
            log.tracef("processActivationStack: %s", stack);
            while (!stack.isEmpty()) {
                HostBundleState hostBundle = stack.pop();
                if (!hostBundle.awaitLazyActivation()) continue;
                try {
                    hostBundle.activateLazily();
                }
                catch (Throwable th) {
                    log.errorf(th, "Cannot activate lazily: %s", (Object)hostBundle);
                }
            }
        }
    }
}

