/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceName;
import org.jboss.osgi.framework.internal.AbstractBundleContext;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.BundleManager;
import org.jboss.osgi.framework.internal.ModuleManagerPlugin;
import org.jboss.osgi.framework.internal.ServiceState;
import org.jboss.osgi.modules.ModuleActivator;
import org.jboss.osgi.modules.ModuleContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

final class ModuleActivatorBridge
implements BundleActivator {
    private BundleManager bundleManager;
    private ModuleActivator moduleActivator;
    private ModuleContext moduleContext;

    ModuleActivatorBridge(ModuleActivator moduleActivator) {
        this.moduleActivator = moduleActivator;
    }

    public void start(BundleContext context) throws Exception {
        AbstractBundleState bundleState = AbstractBundleContext.assertBundleContext(context).getBundleState();
        this.bundleManager = bundleState.getBundleManager();
        ModuleManagerPlugin moduleManager = this.bundleManager.getFrameworkState().getModuleManagerPlugin();
        ModuleIdentifier identifier = bundleState.getModuleIdentifier();
        Module module = moduleManager.getModule(identifier);
        ServiceContainer serviceContainer = this.bundleManager.getServiceContainer();
        BundleContext systemContext = this.bundleManager.getSystemBundle().getBundleContext();
        this.moduleContext = new ModuleContextImpl(serviceContainer, module, systemContext, context.getBundle());
        this.moduleActivator.start(this.moduleContext);
    }

    public void stop(BundleContext context) throws Exception {
        this.moduleActivator.stop(this.moduleContext);
    }

    class ModuleContextImpl
    implements ModuleContext {
        private ServiceContainer serviceContainer;
        private Module module;
        private BundleContext systemContext;
        private Bundle bundle;

        ModuleContextImpl(ServiceContainer serviceContainer, Module module, BundleContext systemContext, Bundle bundle) {
            if (serviceContainer == null) {
                throw new IllegalArgumentException("Null serviceContainer");
            }
            if (module == null) {
                throw new IllegalArgumentException("Null module");
            }
            if (systemContext == null) {
                throw new IllegalArgumentException("Null systemContext");
            }
            if (bundle == null) {
                throw new IllegalArgumentException("Null bundle");
            }
            this.serviceContainer = serviceContainer;
            this.module = module;
            this.systemContext = systemContext;
            this.bundle = bundle;
        }

        @Override
        public ServiceName getServiceName(Class<?> service) {
            if (service == null) {
                throw new IllegalArgumentException("Null service");
            }
            return ServiceState.createXServiceName(service.getName());
        }

        @Override
        public ServiceContainer getServiceContainer() {
            return this.serviceContainer;
        }

        @Override
        public Module getModule() {
            return this.module;
        }

        @Override
        public BundleContext getSystemContext() {
            return this.systemContext;
        }

        @Override
        public Bundle getBundle() {
            return this.bundle;
        }
    }
}

