/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.extractor;

import org.apache.xerces.parsers.AbstractSAXParser;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.cyberneko.html.HTMLConfiguration;

public class HTMLParser
extends AbstractSAXParser {
    private StringBuffer buffer;

    public HTMLParser() {
        super((XMLParserConfiguration)new HTMLConfiguration());
    }

    public void startDocument(XMLLocator arg0, String arg1, NamespaceContext arg2, Augmentations arg3) throws XNIException {
        super.startDocument(arg0, arg1, arg2, arg3);
        this.buffer = new StringBuffer();
    }

    public void characters(XMLString xmlString, Augmentations augmentations) throws XNIException {
        super.characters(xmlString, augmentations);
        this.buffer.append(xmlString.toString());
    }

    private String filterAndJoin(String text) {
        boolean space = false;
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\n' || c == ' ' || Character.isWhitespace(c)) {
                if (space) continue;
                space = true;
                buffer.append(' ');
                continue;
            }
            if (!Character.isLetterOrDigit(c)) {
                if (space) continue;
                space = true;
                buffer.append(' ');
                continue;
            }
            space = false;
            buffer.append(c);
        }
        return buffer.toString();
    }

    public String getContents() {
        String text = this.filterAndJoin(this.buffer.toString());
        return text;
    }
}

