/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi.commons;

import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.LoginException;
import javax.jcr.MergeException;
import javax.jcr.NamespaceException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.PathNotFoundException;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.SimpleCredentials;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.spi.Batch;
import org.apache.jackrabbit.spi.EventBundle;
import org.apache.jackrabbit.spi.EventFilter;
import org.apache.jackrabbit.spi.ItemId;
import org.apache.jackrabbit.spi.LockInfo;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.PropertyId;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QueryInfo;
import org.apache.jackrabbit.spi.SessionInfo;
import org.apache.jackrabbit.spi.Subscription;
import org.apache.jackrabbit.spi.commons.AbstractRepositoryService;
import org.apache.jackrabbit.spi.commons.SessionInfoImpl;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceMapping;
import org.apache.jackrabbit.spi.commons.nodetype.compact.CompactNodeTypeDefReader;
import org.apache.jackrabbit.spi.commons.nodetype.compact.ParseException;
import org.apache.jackrabbit.spi.commons.nodetype.compact.QNodeTypeDefinitionsBuilderImpl;

public abstract class AbstractReadableRepositoryService
extends AbstractRepositoryService {
    protected static final Set WRITE_ACTIONS = new HashSet<String>(Arrays.asList("add_node", "set_property", "remove"));
    protected final Map descriptors;
    protected final NamespaceMapping namespaces = new NamespaceMapping();
    protected final Map nodeTypeDefs = new HashMap();
    protected QNodeDefinition rootNodeDefinition;
    protected final List wspNames;

    public AbstractReadableRepositoryService(Map descriptors, Map namespaces, Reader cnd, List wspNames) throws RepositoryException, ParseException {
        this.descriptors = Collections.unmodifiableMap(new HashMap(descriptors));
        Iterator it = namespaces.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            this.namespaces.setMapping((String)entry.getKey(), (String)entry.getValue());
        }
        CompactNodeTypeDefReader reader = new CompactNodeTypeDefReader(cnd, "", this.namespaces, new QNodeTypeDefinitionsBuilderImpl());
        Iterator it2 = reader.getNodeTypeDefs().iterator();
        while (it2.hasNext()) {
            QNodeTypeDefinition def = (QNodeTypeDefinition)it2.next();
            this.nodeTypeDefs.put(def.getName(), def);
        }
        this.wspNames = Collections.unmodifiableList(new ArrayList(wspNames));
    }

    protected abstract QNodeDefinition createRootNodeDefinition() throws RepositoryException;

    protected abstract void checkCredentials(Credentials var1, String var2) throws LoginException;

    protected void checkSessionInfo(SessionInfo sessionInfo) throws RepositoryException {
        if (sessionInfo instanceof SessionInfoImpl) {
            return;
        }
        throw new RepositoryException("SessionInfo not of type " + SessionInfoImpl.class.getName());
    }

    protected SessionInfo createSessionInfo(String userId, String workspaceName) {
        SessionInfoImpl s = new SessionInfoImpl();
        s.setUserID(userId);
        s.setWorkspacename(workspaceName);
        return s;
    }

    public SessionInfo obtain(Credentials credentials, String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        this.checkCredentials(credentials, workspaceName);
        if (!this.wspNames.contains(workspaceName)) {
            throw new NoSuchWorkspaceException(workspaceName);
        }
        String userId = null;
        if (credentials instanceof SimpleCredentials) {
            userId = ((SimpleCredentials)credentials).getUserID();
        }
        return this.createSessionInfo(userId, workspaceName);
    }

    public SessionInfo obtain(SessionInfo sessionInfo, String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.createSessionInfo(sessionInfo.getUserID(), workspaceName);
    }

    public SessionInfo impersonate(SessionInfo sessionInfo, Credentials credentials) throws LoginException, RepositoryException {
        return this.obtain(credentials, sessionInfo.getWorkspaceName());
    }

    public void dispose(SessionInfo sessionInfo) throws RepositoryException {
    }

    public Iterator getItemInfos(SessionInfo sessionInfo, NodeId nodeId) throws ItemNotFoundException, RepositoryException {
        return Collections.singleton(this.getNodeInfo(sessionInfo, nodeId)).iterator();
    }

    public Map getRepositoryDescriptors() throws RepositoryException {
        return this.descriptors;
    }

    public String[] getWorkspaceNames(SessionInfo sessionInfo) throws RepositoryException {
        this.checkSessionInfo(sessionInfo);
        return this.wspNames.toArray(new String[this.wspNames.size()]);
    }

    public boolean isGranted(SessionInfo sessionInfo, ItemId itemId, String[] actions) throws RepositoryException {
        this.checkSessionInfo(sessionInfo);
        for (int i = 0; i < actions.length; ++i) {
            if (!WRITE_ACTIONS.contains(actions[i])) continue;
            return false;
        }
        return true;
    }

    public Iterator getQNodeTypeDefinitions(SessionInfo sessionInfo) throws RepositoryException {
        this.checkSessionInfo(sessionInfo);
        return this.nodeTypeDefs.values().iterator();
    }

    public Iterator getQNodeTypeDefinitions(SessionInfo sessionInfo, Name[] nodetypeNames) throws RepositoryException {
        this.checkSessionInfo(sessionInfo);
        ArrayList ntDefs = new ArrayList();
        for (int i = 0; i < nodetypeNames.length; ++i) {
            Object def = this.nodeTypeDefs.get(nodetypeNames[i]);
            if (def == null) {
                throw new RepositoryException("unknown node type: " + nodetypeNames[i]);
            }
            ntDefs.add(def);
        }
        return ntDefs.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QNodeDefinition getNodeDefinition(SessionInfo sessionInfo, NodeId nodeId) throws RepositoryException {
        this.checkSessionInfo(sessionInfo);
        if (nodeId.getUniqueID() == null && nodeId.getPath().denotesRoot()) {
            AbstractReadableRepositoryService abstractReadableRepositoryService = this;
            synchronized (abstractReadableRepositoryService) {
                if (this.rootNodeDefinition == null) {
                    this.rootNodeDefinition = this.createRootNodeDefinition();
                }
                return this.rootNodeDefinition;
            }
        }
        throw new UnsupportedRepositoryOperationException();
    }

    public QPropertyDefinition getPropertyDefinition(SessionInfo sessionInfo, PropertyId propertyId) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public Map getRegisteredNamespaces(SessionInfo sessionInfo) throws RepositoryException {
        this.checkSessionInfo(sessionInfo);
        return this.namespaces.getPrefixToURIMapping();
    }

    public String getNamespaceURI(SessionInfo sessionInfo, String prefix) throws NamespaceException, RepositoryException {
        this.checkSessionInfo(sessionInfo);
        return this.namespaces.getURI(prefix);
    }

    public String getNamespacePrefix(SessionInfo sessionInfo, String uri) throws NamespaceException, RepositoryException {
        this.checkSessionInfo(sessionInfo);
        return this.namespaces.getPrefix(uri);
    }

    public Batch createBatch(SessionInfo sessionInfo, ItemId itemId) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void submit(Batch batch) throws PathNotFoundException, ItemNotFoundException, NoSuchNodeTypeException, ValueFormatException, VersionException, LockException, ConstraintViolationException, AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void importXml(SessionInfo sessionInfo, NodeId parentId, InputStream xmlStream, int uuidBehaviour) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void move(SessionInfo sessionInfo, NodeId srcNodeId, NodeId destParentNodeId, Name destName) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void copy(SessionInfo sessionInfo, String srcWorkspaceName, NodeId srcNodeId, NodeId destParentNodeId, Name destName) throws NoSuchWorkspaceException, ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void update(SessionInfo sessionInfo, NodeId nodeId, String srcWorkspaceName) throws NoSuchWorkspaceException, AccessDeniedException, LockException, InvalidItemStateException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void clone(SessionInfo sessionInfo, String srcWorkspaceName, NodeId srcNodeId, NodeId destParentNodeId, Name destName, boolean removeExisting) throws NoSuchWorkspaceException, ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public LockInfo lock(SessionInfo sessionInfo, NodeId nodeId, boolean deep, boolean sessionScoped) throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public LockInfo lock(SessionInfo sessionInfo, NodeId nodeId, boolean deep, boolean sessionScoped, long timeoutHint, String ownerHint) throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public LockInfo getLockInfo(SessionInfo sessionInfo, NodeId nodeId) throws AccessDeniedException, RepositoryException {
        return null;
    }

    public void refreshLock(SessionInfo sessionInfo, NodeId nodeId) throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void unlock(SessionInfo sessionInfo, NodeId nodeId) throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public NodeId checkin(SessionInfo sessionInfo, NodeId nodeId) throws VersionException, UnsupportedRepositoryOperationException, InvalidItemStateException, LockException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void checkout(SessionInfo sessionInfo, NodeId nodeId) throws UnsupportedRepositoryOperationException, LockException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void removeVersion(SessionInfo sessionInfo, NodeId versionHistoryId, NodeId versionId) throws ReferentialIntegrityException, AccessDeniedException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void restore(SessionInfo sessionInfo, NodeId nodeId, NodeId versionId, boolean removeExisting) throws VersionException, PathNotFoundException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void restore(SessionInfo sessionInfo, NodeId[] versionIds, boolean removeExisting) throws ItemExistsException, UnsupportedRepositoryOperationException, VersionException, LockException, InvalidItemStateException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public Iterator merge(SessionInfo sessionInfo, NodeId nodeId, String srcWorkspaceName, boolean bestEffort) throws NoSuchWorkspaceException, AccessDeniedException, MergeException, LockException, InvalidItemStateException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void resolveMergeConflict(SessionInfo sessionInfo, NodeId nodeId, NodeId[] mergeFailedIds, NodeId[] predecessorIds) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void addVersionLabel(SessionInfo sessionInfo, NodeId versionHistoryId, NodeId versionId, Name label, boolean moveLabel) throws VersionException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void removeVersionLabel(SessionInfo sessionInfo, NodeId versionHistoryId, NodeId versionId, Name label) throws VersionException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public EventFilter createEventFilter(SessionInfo sessionInfo, int eventTypes, Path absPath, boolean isDeep, String[] uuid, Name[] nodeTypeName, boolean noLocal) throws UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public Subscription createSubscription(SessionInfo sessionInfo, EventFilter[] filters) throws UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void updateEventFilters(Subscription subscription, EventFilter[] filters) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public EventBundle[] getEvents(Subscription subscription, long timeout) throws RepositoryException, InterruptedException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void dispose(Subscription subscription) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void registerNamespace(SessionInfo sessionInfo, String prefix, String uri) throws NamespaceException, UnsupportedRepositoryOperationException, AccessDeniedException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void unregisterNamespace(SessionInfo sessionInfo, String uri) throws NamespaceException, UnsupportedRepositoryOperationException, AccessDeniedException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public String[] getSupportedQueryLanguages(SessionInfo sessionInfo) throws RepositoryException {
        this.checkSessionInfo(sessionInfo);
        return new String[0];
    }

    public void checkQueryStatement(SessionInfo sessionInfo, String statement, String language, Map namespaces) throws InvalidQueryException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public QueryInfo executeQuery(SessionInfo sessionInfo, String statement, String language, Map namespaces) throws RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }
}

