/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi.commons;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.spi.Event;
import org.apache.jackrabbit.spi.EventFilter;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.Path;

public class EventFilterImpl
implements EventFilter,
Serializable {
    private final int eventTypes;
    private final boolean isDeep;
    private final Path absPath;
    private final Set uuids;
    private final Set nodeTypeNames;
    private final boolean noLocal;

    public EventFilterImpl(int eventTypes, Path absPath, boolean isDeep, String[] uuids, Set nodeTypeNames, boolean noLocal) {
        this.eventTypes = eventTypes;
        this.absPath = absPath;
        this.isDeep = isDeep;
        this.uuids = uuids != null ? new HashSet<String>(Arrays.asList(uuids)) : null;
        this.nodeTypeNames = nodeTypeNames != null ? new HashSet(nodeTypeNames) : null;
        this.noLocal = noLocal;
    }

    public boolean accept(Event event, boolean isLocal) {
        int type = event.getType();
        if ((type & this.eventTypes) == 0) {
            return false;
        }
        if (isLocal && this.noLocal) {
            return false;
        }
        NodeId parentId = event.getParentId();
        if (this.uuids != null) {
            if (parentId.getPath() == null) {
                if (!this.uuids.contains(parentId.getUniqueID())) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (this.nodeTypeNames != null) {
            HashSet<Name> eventTypes = new HashSet<Name>();
            eventTypes.addAll(Arrays.asList(event.getMixinTypeNames()));
            eventTypes.add(event.getPrimaryNodeTypeName());
            eventTypes.retainAll(this.nodeTypeNames);
            if (eventTypes.isEmpty()) {
                return false;
            }
        }
        try {
            Path eventPath = event.getPath().getAncestor(1);
            boolean match = eventPath.equals(this.absPath);
            if (!match && this.isDeep) {
                match = eventPath.isDescendantOf(this.absPath);
            }
            return match;
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public int getEventTypes() {
        return this.eventTypes;
    }

    public boolean isDeep() {
        return this.isDeep;
    }

    public Path getAbsPath() {
        return this.absPath;
    }

    public String[] getUUIDs() {
        if (this.uuids == null) {
            return null;
        }
        return this.uuids.toArray(new String[this.uuids.size()]);
    }

    public Set getNodeTypeNames() {
        if (this.nodeTypeNames == null) {
            return null;
        }
        return Collections.unmodifiableSet(this.nodeTypeNames);
    }

    public boolean getNoLocal() {
        return this.noLocal;
    }

    public String toString() {
        return this.getClass().getName() + "[" + "eventTypes: " + this.eventTypes + ", " + "absPath: " + this.absPath + ", " + "isDeep: " + this.isDeep + ", " + "uuids: " + this.uuids + ", " + "nodeTypeNames: " + this.nodeTypeNames + ", " + "noLocal: " + this.noLocal + "]";
    }
}

