/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.server.rpc.impl;

import com.google.gwt.user.client.rpc.IncompatibleRemoteServiceException;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.client.rpc.impl.AbstractSerializationStreamReader;
import com.google.gwt.user.server.rpc.RPC;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.google.gwt.user.server.rpc.SerializationPolicyProvider;
import com.google.gwt.user.server.rpc.impl.SerializabilityUtil;
import com.google.gwt.user.server.rpc.impl.SerializedInstanceReference;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServerSerializationStreamReader
extends AbstractSerializationStreamReader {
    private static final Map<Class<?>, ValueReader> CLASS_TO_VALUE_READER = new IdentityHashMap();
    private static final Map<Class<?>, VectorReader> CLASS_TO_VECTOR_READER = new IdentityHashMap();
    private final ClassLoader classLoader;
    private SerializationPolicy serializationPolicy = RPC.getDefaultSerializationPolicy();
    private final SerializationPolicyProvider serializationPolicyProvider;
    private String[] stringTable;
    private final ArrayList<String> tokenList = new ArrayList();
    private int tokenListIndex;

    public ServerSerializationStreamReader(ClassLoader classLoader, SerializationPolicyProvider serializationPolicyProvider) {
        CLASS_TO_VECTOR_READER.put(boolean[].class, VectorReader.BOOLEAN_VECTOR);
        CLASS_TO_VECTOR_READER.put(byte[].class, VectorReader.BYTE_VECTOR);
        CLASS_TO_VECTOR_READER.put(char[].class, VectorReader.CHAR_VECTOR);
        CLASS_TO_VECTOR_READER.put(double[].class, VectorReader.DOUBLE_VECTOR);
        CLASS_TO_VECTOR_READER.put(float[].class, VectorReader.FLOAT_VECTOR);
        CLASS_TO_VECTOR_READER.put(int[].class, VectorReader.INT_VECTOR);
        CLASS_TO_VECTOR_READER.put(long[].class, VectorReader.LONG_VECTOR);
        CLASS_TO_VECTOR_READER.put(Object[].class, VectorReader.OBJECT_VECTOR);
        CLASS_TO_VECTOR_READER.put(short[].class, VectorReader.SHORT_VECTOR);
        CLASS_TO_VECTOR_READER.put(String[].class, VectorReader.STRING_VECTOR);
        CLASS_TO_VALUE_READER.put(Boolean.TYPE, ValueReader.BOOLEAN);
        CLASS_TO_VALUE_READER.put(Byte.TYPE, ValueReader.BYTE);
        CLASS_TO_VALUE_READER.put(Character.TYPE, ValueReader.CHAR);
        CLASS_TO_VALUE_READER.put(Double.TYPE, ValueReader.DOUBLE);
        CLASS_TO_VALUE_READER.put(Float.TYPE, ValueReader.FLOAT);
        CLASS_TO_VALUE_READER.put(Integer.TYPE, ValueReader.INT);
        CLASS_TO_VALUE_READER.put(Long.TYPE, ValueReader.LONG);
        CLASS_TO_VALUE_READER.put(Object.class, ValueReader.OBJECT);
        CLASS_TO_VALUE_READER.put(Short.TYPE, ValueReader.SHORT);
        CLASS_TO_VALUE_READER.put(String.class, ValueReader.STRING);
        this.classLoader = classLoader;
        this.serializationPolicyProvider = serializationPolicyProvider;
    }

    public Object deserializeValue(Class<?> type) throws SerializationException {
        ValueReader valueReader = CLASS_TO_VALUE_READER.get(type);
        if (valueReader != null) {
            return valueReader.readValue(this);
        }
        return ValueReader.OBJECT.readValue(this);
    }

    public SerializationPolicy getSerializationPolicy() {
        return this.serializationPolicy;
    }

    @Override
    public void prepareToRead(String encodedTokens) throws SerializationException {
        int nextIdx;
        this.tokenList.clear();
        this.tokenListIndex = 0;
        this.stringTable = null;
        int idx = 0;
        while (-1 != (nextIdx = encodedTokens.indexOf(65535, idx))) {
            String current = encodedTokens.substring(idx, nextIdx);
            this.tokenList.add(current);
            idx = nextIdx + 1;
        }
        super.prepareToRead(encodedTokens);
        if (this.getVersion() != 4) {
            throw new IncompatibleRemoteServiceException("Expecting version 4 from client, got " + this.getVersion() + ".");
        }
        this.deserializeStringTable();
        String moduleBaseURL = this.readString();
        String strongName = this.readString();
        if (this.serializationPolicyProvider != null) {
            this.serializationPolicy = this.serializationPolicyProvider.getSerializationPolicy(moduleBaseURL, strongName);
            if (this.serializationPolicy == null) {
                throw new NullPointerException("serializationPolicyProvider.getSerializationPolicy()");
            }
        }
    }

    @Override
    public boolean readBoolean() {
        return !this.extract().equals("0");
    }

    @Override
    public byte readByte() {
        return Byte.parseByte(this.extract());
    }

    @Override
    public char readChar() {
        return (char)Integer.parseInt(this.extract());
    }

    @Override
    public double readDouble() {
        return Double.parseDouble(this.extract());
    }

    @Override
    public float readFloat() {
        return (float)Double.parseDouble(this.extract());
    }

    @Override
    public int readInt() {
        return Integer.parseInt(this.extract());
    }

    @Override
    public long readLong() {
        return (long)this.readDouble() + (long)this.readDouble();
    }

    @Override
    public short readShort() {
        return Short.parseShort(this.extract());
    }

    @Override
    public String readString() {
        return this.getString(this.readInt());
    }

    @Override
    protected Object deserialize(String typeSignature) throws SerializationException {
        Object instance = null;
        SerializedInstanceReference serializedInstRef = SerializabilityUtil.decodeSerializedInstanceReference(typeSignature);
        try {
            Class<?> instanceClass = Class.forName(serializedInstRef.getName(), false, this.classLoader);
            assert (this.serializationPolicy != null);
            this.serializationPolicy.validateDeserialize(instanceClass);
            this.validateTypeVersions(instanceClass, serializedInstRef);
            Class<?> customSerializer = SerializabilityUtil.hasCustomFieldSerializer(instanceClass);
            int index = this.reserveDecodedObjectIndex();
            instance = this.instantiate(customSerializer, instanceClass);
            this.rememberDecodedObject(index, instance);
            Object replacement = this.deserializeImpl(customSerializer, instanceClass, instance);
            if (instance != replacement) {
                this.rememberDecodedObject(index, replacement);
                instance = replacement;
            }
            return instance;
        }
        catch (ClassNotFoundException e) {
            throw new SerializationException(e);
        }
        catch (InstantiationException e) {
            throw new SerializationException(e);
        }
        catch (IllegalAccessException e) {
            throw new SerializationException(e);
        }
        catch (IllegalArgumentException e) {
            throw new SerializationException(e);
        }
        catch (InvocationTargetException e) {
            throw new SerializationException(e);
        }
        catch (NoSuchMethodException e) {
            throw new SerializationException(e);
        }
    }

    @Override
    protected String getString(int index) {
        if (index == 0) {
            return null;
        }
        assert (index > 0);
        assert (index <= this.stringTable.length);
        return this.stringTable[index - 1];
    }

    private Object deserializeArray(Class<?> instanceClass, Object instance) throws SerializationException {
        assert (instanceClass.isArray());
        BoundedList buffer = (BoundedList)instance;
        VectorReader instanceReader = CLASS_TO_VECTOR_READER.get(instanceClass);
        if (instanceReader != null) {
            return instanceReader.read(this, buffer);
        }
        return VectorReader.OBJECT_VECTOR.read(this, buffer);
    }

    private void deserializeClass(Class<?> instanceClass, Object instance) throws SerializationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, ClassNotFoundException {
        Field[] serializableFields;
        for (Field declField : serializableFields = SerializabilityUtil.applyFieldSerializationPolicy(instanceClass)) {
            boolean needsAccessOverride;
            assert (declField != null);
            Object value = this.deserializeValue(declField.getType());
            boolean isAccessible = declField.isAccessible();
            boolean bl = needsAccessOverride = !isAccessible && !Modifier.isPublic(declField.getModifiers());
            if (needsAccessOverride) {
                declField.setAccessible(true);
            }
            declField.set(instance, value);
        }
        Class<?> superClass = instanceClass.getSuperclass();
        if (this.serializationPolicy.shouldDeserializeFields(superClass)) {
            this.deserializeImpl(SerializabilityUtil.hasCustomFieldSerializer(superClass), superClass, instance);
        }
    }

    private Object deserializeImpl(Class<?> customSerializer, Class<?> instanceClass, Object instance) throws NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, SerializationException, ClassNotFoundException {
        if (customSerializer != null) {
            this.deserializeWithCustomFieldDeserializer(customSerializer, instanceClass, instance);
        } else if (instanceClass.isArray()) {
            instance = this.deserializeArray(instanceClass, instance);
        } else if (!instanceClass.isEnum()) {
            this.deserializeClass(instanceClass, instance);
        }
        return instance;
    }

    private void deserializeStringTable() throws SerializationException {
        int typeNameCount = this.readInt();
        BoundedList<String> buffer = new BoundedList<String>(String.class, typeNameCount);
        for (int typeNameIndex = 0; typeNameIndex < typeNameCount; ++typeNameIndex) {
            buffer.add(this.extract());
        }
        if (buffer.size() != buffer.getExpectedSize()) {
            throw new SerializationException("Expected " + buffer.getExpectedSize() + " string table elements; received " + buffer.size());
        }
        this.stringTable = buffer.toArray(new String[buffer.getExpectedSize()]);
    }

    private void deserializeWithCustomFieldDeserializer(Class<?> customSerializer, Class<?> instanceClass, Object instance) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        assert (!instanceClass.isArray());
        for (Method method : customSerializer.getMethods()) {
            if (!"deserialize".equals(method.getName())) continue;
            method.invoke(null, this, instance);
            return;
        }
        throw new NoSuchMethodException("deserialize");
    }

    private String extract() {
        return this.tokenList.get(this.tokenListIndex++);
    }

    private Object instantiate(Class<?> customSerializer, Class<?> instanceClass) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException {
        if (customSerializer != null) {
            for (Method method : customSerializer.getMethods()) {
                if (!"instantiate".equals(method.getName())) continue;
                return method.invoke(null, this);
            }
        }
        if (instanceClass.isArray()) {
            int length = this.readInt();
            return new BoundedList(instanceClass.getComponentType(), length);
        }
        if (instanceClass.isEnum()) {
            Enum[] enumConstants = (Enum[])instanceClass.getEnumConstants();
            int ordinal = this.readInt();
            assert (ordinal >= 0 && ordinal < enumConstants.length);
            return enumConstants[ordinal];
        }
        Constructor<?> constructor = instanceClass.getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        return constructor.newInstance(new Object[0]);
    }

    private void validateTypeVersions(Class<?> instanceClass, SerializedInstanceReference serializedInstRef) throws SerializationException {
        String clientTypeSignature = serializedInstRef.getSignature();
        if (clientTypeSignature.length() == 0) {
            throw new SerializationException("Missing type signature for " + instanceClass.getName());
        }
        String serverTypeSignature = SerializabilityUtil.getSerializationSignature(instanceClass);
        if (!clientTypeSignature.equals(serverTypeSignature)) {
            throw new SerializationException("Invalid type signature for " + instanceClass.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum VectorReader {
        BOOLEAN_VECTOR{

            protected Object readSingleValue(ServerSerializationStreamReader stream) throws SerializationException {
                return stream.readBoolean();
            }

            protected void setSingleValue(Object array, int index, Object value) {
                Array.setBoolean(array, index, (Boolean)value);
            }
        }
        ,
        BYTE_VECTOR{

            protected Object readSingleValue(ServerSerializationStreamReader stream) throws SerializationException {
                return stream.readByte();
            }

            protected void setSingleValue(Object array, int index, Object value) {
                Array.setByte(array, index, (Byte)value);
            }
        }
        ,
        CHAR_VECTOR{

            protected Object readSingleValue(ServerSerializationStreamReader stream) throws SerializationException {
                return Character.valueOf(stream.readChar());
            }

            protected void setSingleValue(Object array, int index, Object value) {
                Array.setChar(array, index, ((Character)value).charValue());
            }
        }
        ,
        DOUBLE_VECTOR{

            protected Object readSingleValue(ServerSerializationStreamReader stream) throws SerializationException {
                return stream.readDouble();
            }

            protected void setSingleValue(Object array, int index, Object value) {
                Array.setDouble(array, index, (Double)value);
            }
        }
        ,
        FLOAT_VECTOR{

            protected Object readSingleValue(ServerSerializationStreamReader stream) throws SerializationException {
                return Float.valueOf(stream.readFloat());
            }

            protected void setSingleValue(Object array, int index, Object value) {
                Array.setFloat(array, index, ((Float)value).floatValue());
            }
        }
        ,
        INT_VECTOR{

            protected Object readSingleValue(ServerSerializationStreamReader stream) throws SerializationException {
                return stream.readInt();
            }

            protected void setSingleValue(Object array, int index, Object value) {
                Array.setInt(array, index, (Integer)value);
            }
        }
        ,
        LONG_VECTOR{

            protected Object readSingleValue(ServerSerializationStreamReader stream) throws SerializationException {
                return stream.readLong();
            }

            protected void setSingleValue(Object array, int index, Object value) {
                Array.setLong(array, index, (Long)value);
            }
        }
        ,
        OBJECT_VECTOR{

            protected Object readSingleValue(ServerSerializationStreamReader stream) throws SerializationException {
                return stream.readObject();
            }

            protected void setSingleValue(Object array, int index, Object value) {
                Array.set(array, index, value);
            }
        }
        ,
        SHORT_VECTOR{

            protected Object readSingleValue(ServerSerializationStreamReader stream) throws SerializationException {
                return stream.readShort();
            }

            protected void setSingleValue(Object array, int index, Object value) {
                Array.setShort(array, index, (Short)value);
            }
        }
        ,
        STRING_VECTOR{

            protected Object readSingleValue(ServerSerializationStreamReader stream) throws SerializationException {
                return stream.readString();
            }

            protected void setSingleValue(Object array, int index, Object value) {
                Array.set(array, index, value);
            }
        };


        protected abstract Object readSingleValue(ServerSerializationStreamReader var1) throws SerializationException;

        protected abstract void setSingleValue(Object var1, int var2, Object var3);

        protected Object toArray(Class<?> componentType, BoundedList<Object> buffer) throws SerializationException {
            if (buffer.getExpectedSize() != buffer.size()) {
                throw new SerializationException("Inconsistent number of elements received. Received " + buffer.size() + " but expecting " + buffer.getExpectedSize());
            }
            Object arr = Array.newInstance(componentType, buffer.size());
            int n = buffer.size();
            for (int i = 0; i < n; ++i) {
                this.setSingleValue(arr, i, buffer.removeFirst());
            }
            return arr;
        }

        Object read(ServerSerializationStreamReader stream, BoundedList<Object> instance) throws SerializationException {
            int n = instance.getExpectedSize();
            for (int i = 0; i < n; ++i) {
                instance.add(this.readSingleValue(stream));
            }
            return this.toArray(instance.getComponentType(), instance);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ValueReader {
        BOOLEAN{

            Object readValue(ServerSerializationStreamReader stream) {
                return stream.readBoolean();
            }
        }
        ,
        BYTE{

            Object readValue(ServerSerializationStreamReader stream) {
                return stream.readByte();
            }
        }
        ,
        CHAR{

            Object readValue(ServerSerializationStreamReader stream) {
                return Character.valueOf(stream.readChar());
            }
        }
        ,
        DOUBLE{

            Object readValue(ServerSerializationStreamReader stream) {
                return stream.readDouble();
            }
        }
        ,
        FLOAT{

            Object readValue(ServerSerializationStreamReader stream) {
                return Float.valueOf(stream.readFloat());
            }
        }
        ,
        INT{

            Object readValue(ServerSerializationStreamReader stream) {
                return stream.readInt();
            }
        }
        ,
        LONG{

            Object readValue(ServerSerializationStreamReader stream) {
                return stream.readLong();
            }
        }
        ,
        OBJECT{

            Object readValue(ServerSerializationStreamReader stream) throws SerializationException {
                return stream.readObject();
            }
        }
        ,
        SHORT{

            Object readValue(ServerSerializationStreamReader stream) {
                return stream.readShort();
            }
        }
        ,
        STRING{

            Object readValue(ServerSerializationStreamReader stream) {
                return stream.readString();
            }
        };


        abstract Object readValue(ServerSerializationStreamReader var1) throws SerializationException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BoundedList<T>
    extends LinkedList<T> {
        private final Class<?> componentType;
        private final int expectedSize;

        public BoundedList(Class<?> componentType, int expectedSize) {
            this.componentType = componentType;
            this.expectedSize = expectedSize;
        }

        @Override
        public boolean add(T o) {
            assert (this.size() < this.getExpectedSize());
            return super.add(o);
        }

        public Class<?> getComponentType() {
            return this.componentType;
        }

        public int getExpectedSize() {
            return this.expectedSize;
        }
    }
}

