/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.reveng;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.hibernate.cfg.reveng.AssociationInfo;
import org.hibernate.cfg.reveng.JDBCToHibernateTypeHelper;
import org.hibernate.cfg.reveng.ReverseEngineeringRuntimeInfo;
import org.hibernate.cfg.reveng.ReverseEngineeringSettings;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategyUtil;
import org.hibernate.cfg.reveng.TableIdentifier;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultReverseEngineeringStrategy
implements ReverseEngineeringStrategy {
    private static final Logger log = LoggerFactory.getLogger(DefaultReverseEngineeringStrategy.class);
    private static Set AUTO_OPTIMISTICLOCK_COLUMNS = new HashSet();
    private ReverseEngineeringSettings settings = new ReverseEngineeringSettings(this);
    private ReverseEngineeringRuntimeInfo runtimeInfo;

    public String columnToPropertyName(TableIdentifier table, String columnName) {
        String decapitalize = Introspector.decapitalize(this.toUpperCamelCase(columnName));
        return this.keywordCheck(decapitalize);
    }

    private String keywordCheck(String possibleKeyword) {
        if (ReverseEngineeringStrategyUtil.isReservedJavaKeyword(possibleKeyword)) {
            possibleKeyword = possibleKeyword + "_";
        }
        return possibleKeyword;
    }

    protected String toUpperCamelCase(String s) {
        return ReverseEngineeringStrategyUtil.toUpperCamelCase(s);
    }

    public String foreignKeyToCollectionName(String keyname, TableIdentifier fromTable, List fromColumns, TableIdentifier referencedTable, List referencedColumns, boolean uniqueReference) {
        String propertyName = Introspector.decapitalize(StringHelper.unqualify((String)this.getRoot().tableToClassName(fromTable)));
        propertyName = this.pluralize(propertyName);
        if (!uniqueReference) {
            if (fromColumns != null && fromColumns.size() == 1) {
                String columnName = ((Column)fromColumns.get(0)).getName();
                propertyName = propertyName + "For" + this.toUpperCamelCase(columnName);
            } else {
                propertyName = propertyName + "For" + this.toUpperCamelCase(keyname);
            }
        }
        return propertyName;
    }

    protected String pluralize(String singular) {
        return ReverseEngineeringStrategyUtil.simplePluralize(singular);
    }

    public String foreignKeyToInverseEntityName(String keyname, TableIdentifier fromTable, List fromColumnNames, TableIdentifier referencedTable, List referencedColumnNames, boolean uniqueReference) {
        return this.foreignKeyToEntityName(keyname, fromTable, fromColumnNames, referencedTable, referencedColumnNames, uniqueReference);
    }

    public String foreignKeyToEntityName(String keyname, TableIdentifier fromTable, List fromColumnNames, TableIdentifier referencedTable, List referencedColumnNames, boolean uniqueReference) {
        String propertyName = Introspector.decapitalize(StringHelper.unqualify((String)this.getRoot().tableToClassName(referencedTable)));
        if (!uniqueReference) {
            if (fromColumnNames != null && fromColumnNames.size() == 1) {
                String columnName = ((Column)fromColumnNames.get(0)).getName();
                propertyName = propertyName + "By" + this.toUpperCamelCase(columnName);
            } else {
                propertyName = propertyName + "By" + this.toUpperCamelCase(keyname);
            }
        }
        return propertyName;
    }

    public String columnToHibernateTypeName(TableIdentifier table, String columnName, int sqlType, int length, int precision, int scale, boolean nullable, boolean generatedIdentifier) {
        String preferredHibernateType = JDBCToHibernateTypeHelper.getPreferredHibernateType(sqlType, length, precision, scale, nullable, generatedIdentifier);
        String location = "<no info>";
        if (log.isDebugEnabled()) {
            String info = " t:" + JDBCToHibernateTypeHelper.getJDBCTypeName(sqlType) + " l:" + length + " p:" + precision + " s:" + scale + " n:" + nullable + " id:" + generatedIdentifier;
            location = table != null ? Table.qualify((String)table.getCatalog(), (String)table.getSchema(), (String)table.getName()) + "." + columnName + info : location + " Column: " + columnName + info;
        }
        if (preferredHibernateType == null) {
            log.debug("No default type found for [" + location + "] falling back to [serializable]");
            return "serializable";
        }
        log.debug("Default type found for [" + location + "] to [" + preferredHibernateType + "]");
        return preferredHibernateType;
    }

    public boolean excludeTable(TableIdentifier ti) {
        return false;
    }

    public boolean excludeColumn(TableIdentifier identifier, String columnName) {
        return false;
    }

    public String tableToClassName(TableIdentifier tableIdentifier) {
        String pkgName = this.settings.getDefaultPackageName();
        String className = this.toUpperCamelCase(tableIdentifier.getName());
        if (pkgName.length() > 0) {
            return StringHelper.qualify((String)pkgName, (String)className);
        }
        return className;
    }

    public List getForeignKeys(TableIdentifier referencedTable) {
        return Collections.EMPTY_LIST;
    }

    public String getTableIdentifierStrategyName(TableIdentifier identifier) {
        return null;
    }

    public Properties getTableIdentifierProperties(TableIdentifier identifier) {
        return null;
    }

    public List getPrimaryKeyColumnNames(TableIdentifier identifier) {
        return null;
    }

    public String classNameToCompositeIdName(String className) {
        return className + "Id";
    }

    public void configure(ReverseEngineeringRuntimeInfo rti) {
        this.runtimeInfo = rti;
    }

    public void close() {
    }

    public String getOptimisticLockColumnName(TableIdentifier identifier) {
        return null;
    }

    public boolean useColumnForOptimisticLock(TableIdentifier identifier, String column) {
        if (this.settings.getDetectOptimsticLock()) {
            return AUTO_OPTIMISTICLOCK_COLUMNS.contains(column.toLowerCase());
        }
        return false;
    }

    public List getSchemaSelections() {
        return null;
    }

    public String tableToIdentifierPropertyName(TableIdentifier tableIdentifier) {
        return null;
    }

    public String tableToCompositeIdName(TableIdentifier identifier) {
        return null;
    }

    public boolean excludeForeignKeyAsCollection(String keyname, TableIdentifier fromTable, List fromColumns, TableIdentifier referencedTable, List referencedColumns) {
        return !this.settings.createCollectionForForeignKey();
    }

    public boolean excludeForeignKeyAsManytoOne(String keyname, TableIdentifier fromTable, List fromColumns, TableIdentifier referencedTable, List referencedColumns) {
        return !this.settings.createManyToOneForForeignKey();
    }

    public boolean isForeignKeyCollectionInverse(String name, TableIdentifier foreignKeyTable, List columns, TableIdentifier foreignKeyReferencedTable, List referencedColumns) {
        Table fkTable = this.getRuntimeInfo().getTable(foreignKeyTable);
        if (fkTable == null) {
            return true;
        }
        if (this.isManyToManyTable(fkTable)) {
            Column column = fkTable.getColumn(0);
            Column fkColumn = (Column)referencedColumns.get(0);
            return fkColumn.equals(column);
        }
        return true;
    }

    public boolean isForeignKeyCollectionLazy(String name, TableIdentifier foreignKeyTable, List columns, TableIdentifier foreignKeyReferencedTable, List referencedColumns) {
        return true;
    }

    public void setSettings(ReverseEngineeringSettings settings) {
        this.settings = settings;
    }

    public boolean isOneToOne(ForeignKey foreignKey) {
        if (this.settings.getDetectOneToOne()) {
            List fkColumns = foreignKey.getColumns();
            List pkForeignTableColumns = null;
            if (foreignKey.getTable().hasPrimaryKey()) {
                pkForeignTableColumns = foreignKey.getTable().getPrimaryKey().getColumns();
            }
            boolean equals = fkColumns != null && pkForeignTableColumns != null && fkColumns.size() == pkForeignTableColumns.size();
            Iterator columns = foreignKey.getColumnIterator();
            while (equals && columns.hasNext()) {
                Column fkColumn = (Column)columns.next();
                equals = equals && pkForeignTableColumns.contains(fkColumn);
            }
            return equals;
        }
        return false;
    }

    public boolean isManyToManyTable(Table table) {
        if (this.settings.getDetectManyToMany()) {
            PrimaryKey pk = table.getPrimaryKey();
            if (pk == null || pk.getColumns().size() != table.getColumnSpan()) {
                return false;
            }
            Iterator foreignKeyIterator = table.getForeignKeyIterator();
            ArrayList<ForeignKey> foreignKeys = new ArrayList<ForeignKey>();
            while (foreignKeyIterator.hasNext()) {
                ForeignKey fkey = (ForeignKey)foreignKeyIterator.next();
                foreignKeys.add(fkey);
                if (foreignKeys.size() <= 2) continue;
                return false;
            }
            if (foreignKeys.size() != 2) {
                return false;
            }
            HashSet<Column> columns = new HashSet<Column>();
            Iterator columnIterator = table.getColumnIterator();
            while (columnIterator.hasNext()) {
                Column column = (Column)columnIterator.next();
                columns.add(column);
            }
            foreignKeyIterator = table.getForeignKeyIterator();
            while (!columns.isEmpty() && foreignKeyIterator.hasNext()) {
                ForeignKey element = (ForeignKey)foreignKeyIterator.next();
                columns.removeAll(element.getColumns());
            }
            return columns.isEmpty();
        }
        return false;
    }

    protected ReverseEngineeringStrategy getRoot() {
        return this.settings.getRootStrategy();
    }

    protected ReverseEngineeringRuntimeInfo getRuntimeInfo() {
        return this.runtimeInfo;
    }

    public String foreignKeyToManyToManyName(ForeignKey fromKey, TableIdentifier middleTable, ForeignKey toKey, boolean uniqueReference) {
        String propertyName = Introspector.decapitalize(StringHelper.unqualify((String)this.getRoot().tableToClassName(TableIdentifier.create(toKey.getReferencedTable()))));
        propertyName = this.pluralize(propertyName);
        if (!uniqueReference) {
            if (toKey.getColumns() != null && toKey.getColumns().size() == 1) {
                String columnName = ((Column)toKey.getColumns().get(0)).getName();
                propertyName = propertyName + "For" + this.toUpperCamelCase(columnName);
            } else {
                propertyName = propertyName + "For" + this.toUpperCamelCase(toKey.getName());
            }
        }
        return propertyName;
    }

    public Map tableToMetaAttributes(TableIdentifier tableIdentifier) {
        return null;
    }

    public Map columnToMetaAttributes(TableIdentifier identifier, String column) {
        return null;
    }

    public AssociationInfo foreignKeyToAssociationInfo(ForeignKey foreignKey) {
        return null;
    }

    public AssociationInfo foreignKeyToInverseAssociationInfo(ForeignKey foreignKey) {
        return null;
    }

    static {
        AUTO_OPTIMISTICLOCK_COLUMNS.add("version");
        AUTO_OPTIMISTICLOCK_COLUMNS.add("timestamp");
    }
}

