/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ant;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.Task;
import org.dbunit.DatabaseUnitException;
import org.dbunit.ant.DbUnitTaskStep;
import org.dbunit.ant.Query;
import org.dbunit.ant.QuerySet;
import org.dbunit.ant.Table;
import org.dbunit.database.CachedResultSetTableFactory;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.ForwardOnlyResultSetTableFactory;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.IResultSetTableFactory;
import org.dbunit.database.QueryDataSet;
import org.dbunit.dataset.CachedDataSet;
import org.dbunit.dataset.CompositeDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.csv.CsvProducer;
import org.dbunit.dataset.stream.IDataSetProducer;
import org.dbunit.dataset.stream.StreamingDataSet;
import org.dbunit.dataset.xml.FlatDtdProducer;
import org.dbunit.dataset.xml.FlatXmlProducer;
import org.dbunit.dataset.xml.XmlProducer;
import org.xml.sax.InputSource;

public abstract class AbstractStep
implements DbUnitTaskStep {
    public static final String FORMAT_FLAT = "flat";
    public static final String FORMAT_XML = "xml";
    public static final String FORMAT_DTD = "dtd";
    public static final String FORMAT_CSV = "csv";
    private Task parentTask;

    protected IDataSet getDatabaseDataSet(IDatabaseConnection connection, List tables, boolean forwardonly) throws DatabaseUnitException {
        try {
            IResultSetTableFactory factory = null;
            factory = forwardonly ? new ForwardOnlyResultSetTableFactory() : new CachedResultSetTableFactory();
            DatabaseConfig config = connection.getConfig();
            config.setProperty("http://www.dbunit.org/properties/resultSetTableFactory", factory);
            if (tables.size() == 0) {
                return connection.createDataSet();
            }
            ArrayList<QueryDataSet> queryDataSets = new ArrayList<QueryDataSet>();
            QueryDataSet queryDataSet = new QueryDataSet(connection);
            Iterator it = tables.iterator();
            while (it.hasNext()) {
                Object item = it.next();
                if (item instanceof QuerySet) {
                    if (queryDataSet.getTableNames().length > 0) {
                        queryDataSets.add(queryDataSet);
                    }
                    queryDataSets.add(this.getQueryDataSetForQuerySet(connection, (QuerySet)item));
                    queryDataSet = new QueryDataSet(connection);
                    continue;
                }
                if (item instanceof Query) {
                    Query queryItem = (Query)item;
                    queryDataSet.addTable(queryItem.getName(), queryItem.getSql());
                    continue;
                }
                Table tableItem = (Table)item;
                queryDataSet.addTable(tableItem.getName());
            }
            if (queryDataSet.getTableNames().length > 0) {
                queryDataSets.add(queryDataSet);
            }
            IDataSet[] dataSetsArray = new IDataSet[queryDataSets.size()];
            return new CompositeDataSet(queryDataSets.toArray(dataSetsArray));
        }
        catch (SQLException e) {
            throw new DatabaseUnitException(e);
        }
    }

    protected IDataSet getSrcDataSet(File src, String format, boolean forwardonly) throws DatabaseUnitException {
        try {
            IDataSetProducer producer = null;
            if (format.equalsIgnoreCase(FORMAT_XML)) {
                producer = new XmlProducer(new InputSource(src.toURL().toString()));
            } else if (format.equalsIgnoreCase(FORMAT_CSV)) {
                producer = new CsvProducer(src);
            } else if (format.equalsIgnoreCase(FORMAT_FLAT)) {
                producer = new FlatXmlProducer(new InputSource(src.toURL().toString()));
            } else if (format.equalsIgnoreCase(FORMAT_DTD)) {
                producer = new FlatDtdProducer(new InputSource(src.toURL().toString()));
            } else {
                throw new IllegalArgumentException("Type must be either 'flat'(default), 'xml', 'csv' or 'dtd' but was: " + format);
            }
            if (forwardonly) {
                return new StreamingDataSet(producer);
            }
            return new CachedDataSet(producer);
        }
        catch (IOException e) {
            throw new DatabaseUnitException(e);
        }
    }

    private QueryDataSet getQueryDataSetForQuerySet(IDatabaseConnection connection, QuerySet querySet) throws SQLException {
        String refid = querySet.getRefid();
        if (refid != null) {
            QuerySet referenced = (QuerySet)this.getParentTask().getProject().getReference(refid);
            querySet.copyQueriesFrom(referenced);
        }
        QueryDataSet partialDataSet = new QueryDataSet(connection);
        Iterator queriesIter = querySet.getQueries().iterator();
        while (queriesIter.hasNext()) {
            Query query = (Query)queriesIter.next();
            partialDataSet.addTable(query.getName(), query.getSql());
        }
        return partialDataSet;
    }

    public Task getParentTask() {
        return this.parentTask;
    }

    public void setParentTask(Task task) {
        this.parentTask = task;
    }

    public void log(String msg, int level) {
        if (this.parentTask != null) {
            this.parentTask.log(msg, level);
        }
    }

    public abstract String getLogMessage();

    public abstract void execute(IDatabaseConnection var1) throws DatabaseUnitException;
}

