/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTableMetaData;
import org.dbunit.dataset.csv.CsvParserException;
import org.dbunit.dataset.csv.CsvParserImpl;
import org.dbunit.dataset.csv.IllegalInputCharacterException;
import org.dbunit.dataset.csv.handlers.PipelineException;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.stream.DefaultConsumer;
import org.dbunit.dataset.stream.IDataSetConsumer;
import org.dbunit.dataset.stream.IDataSetProducer;

public class CsvProducer
implements IDataSetProducer {
    private static final IDataSetConsumer EMPTY_CONSUMER = new DefaultConsumer();
    private IDataSetConsumer _consumer = EMPTY_CONSUMER;
    private String _theDirectory;

    public CsvProducer(String theDirectory) {
        this._theDirectory = theDirectory;
    }

    public CsvProducer(File theDirectory) {
        this._theDirectory = theDirectory.getAbsolutePath();
    }

    public void setConsumer(IDataSetConsumer consumer) throws DataSetException {
        this._consumer = consumer;
    }

    public void produce() throws DataSetException {
        File dir = new File(this._theDirectory);
        if (!dir.isDirectory()) {
            throw new DataSetException("'" + this._theDirectory + "' should be a directory");
        }
        this._consumer.startDataSet();
        try {
            List tableSpecs = CsvProducer.getTables(dir.toURL(), "table-ordering.txt");
            Iterator tableIter = tableSpecs.iterator();
            while (tableIter.hasNext()) {
                String table = (String)tableIter.next();
                try {
                    this.produceFromFile(new File(dir, table + ".csv"));
                }
                catch (CsvParserException e) {
                    throw new DataSetException("error producing dataset for table '" + table + "'", e);
                }
                catch (DataSetException e) {
                    throw new DataSetException("error producing dataset for table '" + table + "'", e);
                }
            }
            this._consumer.endDataSet();
        }
        catch (IOException e) {
            throw new DataSetException("error getting list of tables", e);
        }
    }

    private void produceFromFile(File theDataFile) throws DataSetException, CsvParserException {
        try {
            CsvParserImpl parser = new CsvParserImpl();
            List readData = parser.parse(theDataFile);
            List readColumns = (List)readData.get(0);
            Column[] columns = new Column[readColumns.size()];
            int i = 0;
            while (i < readColumns.size()) {
                columns[i] = new Column((String)readColumns.get(i), DataType.UNKNOWN);
                ++i;
            }
            String tableName = theDataFile.getName().substring(0, theDataFile.getName().indexOf(".csv"));
            DefaultTableMetaData metaData = new DefaultTableMetaData(tableName, columns);
            this._consumer.startTable(metaData);
            int i2 = 1;
            while (i2 < readData.size()) {
                List rowList = (List)readData.get(i2);
                Object[] row = rowList.toArray();
                int col = 0;
                while (col < row.length) {
                    row[col] = row[col].equals("null") ? null : row[col];
                    ++col;
                }
                this._consumer.row(row);
                ++i2;
            }
            this._consumer.endTable();
        }
        catch (PipelineException e) {
            throw new DataSetException(e);
        }
        catch (IllegalInputCharacterException e) {
            throw new DataSetException(e);
        }
        catch (IOException e) {
            throw new DataSetException(e);
        }
    }

    public static List getTables(URL base, String tableList) throws IOException {
        ArrayList<String> orderedNames = new ArrayList<String>();
        InputStream tableListStream = new URL(base, tableList).openStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(tableListStream));
        String line = null;
        while ((line = reader.readLine()) != null) {
            String table = line.trim();
            if (table.length() <= 0) continue;
            orderedNames.add(table);
        }
        reader.close();
        return orderedNames;
    }
}

