/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.datatype;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.datatype.AbstractDataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.dbunit.util.Base64;

public class BytesDataType
extends AbstractDataType {
    private static final int MAX_URI_LENGTH = 256;
    static /* synthetic */ Class array$B;

    BytesDataType(String name, int sqlType) {
        super(name, sqlType, array$B == null ? (array$B = BytesDataType.class$("[B")) : array$B, false);
    }

    private byte[] toByteArray(InputStream in, int length) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(length);
        in = new BufferedInputStream(in);
        int i = in.read();
        while (i != -1) {
            out.write(i);
            i = in.read();
        }
        return out.toByteArray();
    }

    public Object typeCast(Object value) throws TypeCastException {
        if (value == null || value == ITable.NO_VALUE) {
            return null;
        }
        if (value instanceof byte[]) {
            return value;
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            if (stringValue.length() == 0 || stringValue.length() > 256) {
                return Base64.decode((String)value);
            }
            try {
                try {
                    URL url = new URL(stringValue);
                    return this.toByteArray(url.openStream(), 0);
                }
                catch (MalformedURLException e1) {
                    try {
                        File file = new File(stringValue);
                        return this.toByteArray(new FileInputStream(file), (int)file.length());
                    }
                    catch (FileNotFoundException e2) {
                        return Base64.decode((String)value);
                    }
                }
            }
            catch (IOException e) {
                throw new TypeCastException(value, this, e);
            }
        }
        if (value instanceof Blob) {
            try {
                Blob blobValue = (Blob)value;
                return blobValue.getBytes(1L, (int)blobValue.length());
            }
            catch (SQLException e) {
                throw new TypeCastException(value, this, e);
            }
        }
        if (value instanceof URL) {
            try {
                return this.toByteArray(((URL)value).openStream(), 0);
            }
            catch (IOException e) {
                throw new TypeCastException(value, this, e);
            }
        }
        if (value instanceof File) {
            try {
                File file = (File)value;
                return this.toByteArray(new FileInputStream(file), (int)file.length());
            }
            catch (IOException e) {
                throw new TypeCastException(value, this, e);
            }
        }
        throw new TypeCastException(value, this);
    }

    public int compare(Object o1, Object o2) throws TypeCastException {
        try {
            byte[] value1 = (byte[])this.typeCast(o1);
            byte[] value2 = (byte[])this.typeCast(o2);
            if (value1 == null && value2 == null) {
                return 0;
            }
            if (value1 == null && value2 != null) {
                return -1;
            }
            if (value1 != null && value2 == null) {
                return 1;
            }
            return this.compare(value1, value2);
        }
        catch (ClassCastException e) {
            throw new TypeCastException(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    public int compare(byte[] v1, byte[] v2) throws TypeCastException {
        block3: {
            len1 = v1.length;
            len2 = v2.length;
            n = Math.min(len1, len2);
            i = 0;
            j = 0;
            if (i != j) ** GOTO lbl19
            k = i;
            lim = n + i;
            while (k < lim) {
                c1 = v1[k];
                c2 = v2[k];
                if (c1 != c2) {
                    return c1 - c2;
                }
                ++k;
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                if ((c1 = v1[i++]) == (c2 = v2[j++])) continue;
                return c1 - c2;
lbl19:
                // 2 sources

                ** while (n-- != 0)
            }
        }
        return len1 - len2;
    }

    public Object getSqlValue(int column, ResultSet resultSet) throws SQLException, TypeCastException {
        byte[] value = resultSet.getBytes(column);
        if (value == null || resultSet.wasNull()) {
            return null;
        }
        return value;
    }

    public void setSqlValue(Object value, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        super.setSqlValue(value, column, statement);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

