/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.datatype;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dbunit.dataset.datatype.BlobDataType;
import org.dbunit.dataset.datatype.BooleanDataType;
import org.dbunit.dataset.datatype.BytesDataType;
import org.dbunit.dataset.datatype.ClobDataType;
import org.dbunit.dataset.datatype.DataTypeException;
import org.dbunit.dataset.datatype.DateDataType;
import org.dbunit.dataset.datatype.DoubleDataType;
import org.dbunit.dataset.datatype.FloatDataType;
import org.dbunit.dataset.datatype.IntegerDataType;
import org.dbunit.dataset.datatype.LongDataType;
import org.dbunit.dataset.datatype.NumberDataType;
import org.dbunit.dataset.datatype.StringDataType;
import org.dbunit.dataset.datatype.TimeDataType;
import org.dbunit.dataset.datatype.TimestampDataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.dbunit.dataset.datatype.UnknownDataType;

public abstract class DataType {
    public static final DataType UNKNOWN = new UnknownDataType();
    public static final DataType CHAR = new StringDataType("CHAR", 1);
    public static final DataType VARCHAR = new StringDataType("VARCHAR", 12);
    public static final DataType LONGVARCHAR = new StringDataType("LONGVARCHAR", -1);
    public static final DataType CLOB = new ClobDataType();
    public static final DataType NUMERIC = new NumberDataType("NUMERIC", 2);
    public static final DataType DECIMAL = new NumberDataType("DECIMAL", 3);
    public static final DataType BOOLEAN = new BooleanDataType();
    public static final DataType TINYINT = new IntegerDataType("TINYINT", -6);
    public static final DataType SMALLINT = new IntegerDataType("SMALLINT", 5);
    public static final DataType INTEGER = new IntegerDataType("INTEGER", 4);
    public static final DataType BIGINT = new LongDataType();
    public static final DataType REAL = new FloatDataType();
    public static final DataType FLOAT = new DoubleDataType("FLOAT", 6);
    public static final DataType DOUBLE = new DoubleDataType("DOUBLE", 8);
    public static final DataType DATE = new DateDataType();
    public static final DataType TIME = new TimeDataType();
    public static final DataType TIMESTAMP = new TimestampDataType();
    public static final DataType BINARY = new BytesDataType("BINARY", -2);
    public static final DataType VARBINARY = new BytesDataType("VARBINARY", -3);
    public static final DataType LONGVARBINARY = new BytesDataType("LONGVARBINARY", -4);
    public static final DataType BLOB = new BlobDataType();
    private static final DataType[] TYPES = new DataType[]{VARCHAR, CHAR, LONGVARCHAR, CLOB, NUMERIC, DECIMAL, BOOLEAN, INTEGER, TINYINT, SMALLINT, BIGINT, REAL, DOUBLE, FLOAT, DATE, TIME, TIMESTAMP, VARBINARY, BINARY, LONGVARBINARY, BLOB};

    public abstract Object typeCast(Object var1) throws TypeCastException;

    public abstract int compare(Object var1, Object var2) throws TypeCastException;

    public abstract int getSqlType();

    public abstract Class getTypeClass();

    public abstract boolean isNumber();

    public abstract boolean isDateTime();

    public abstract Object getSqlValue(int var1, ResultSet var2) throws SQLException, TypeCastException;

    public abstract void setSqlValue(Object var1, int var2, PreparedStatement var3) throws SQLException, TypeCastException;

    public static String asString(Object value) throws TypeCastException {
        return (String)VARCHAR.typeCast(value);
    }

    public static DataType forSqlType(int sqlType) throws DataTypeException {
        int i = 0;
        while (i < TYPES.length) {
            if (sqlType == TYPES[i].getSqlType()) {
                return TYPES[i];
            }
            ++i;
        }
        return UNKNOWN;
    }

    public static DataType forSqlTypeName(String sqlTypeName) throws DataTypeException {
        int i = 0;
        while (i < TYPES.length) {
            if (sqlTypeName.equals(TYPES[i].toString())) {
                return TYPES[i];
            }
            ++i;
        }
        return UNKNOWN;
    }

    public static DataType forObject(Object value) {
        if (value == null) {
            return UNKNOWN;
        }
        int i = 0;
        while (i < TYPES.length) {
            Class typeClass = TYPES[i].getTypeClass();
            if (typeClass.isInstance(value)) {
                return TYPES[i];
            }
            ++i;
        }
        return UNKNOWN;
    }
}

