/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.util.search;

import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbunit.util.search.ISearchCallback;
import org.dbunit.util.search.SearchException;

public abstract class AbstractNodesFilterSearchCallback
implements ISearchCallback {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected static final int NO_MODE = 0;
    protected static final int ALLOW_MODE = 1;
    protected static final int DENY_MODE = 2;
    private int filteringMode = 0;
    private Set filteredNodes = new HashSet();

    protected Set getFilteredNodes() {
        return this.filteredNodes;
    }

    protected int getFilteringMode() {
        return this.filteringMode;
    }

    protected void setAllowedNodes(Set filteredNodes) {
        this.setFilteredNodes(filteredNodes);
        this.filteringMode = 1;
    }

    protected void setAllowedNodes(Object[] filteredNodes) {
        this.setFilteredNodes(filteredNodes);
        this.filteringMode = 1;
    }

    protected void setDeniedNodes(Set filteredNodes) {
        this.setFilteredNodes(filteredNodes);
        this.filteringMode = 2;
    }

    protected void setDeniedNodes(Object[] filteredNodes) {
        this.setFilteredNodes(filteredNodes);
        this.filteringMode = 2;
    }

    public void nodeAdded(Object fromNode) throws SearchException {
    }

    public boolean searchNode(Object node) throws SearchException {
        switch (this.filteringMode) {
            case 1: {
                return this.getFilteredNodes().contains(node);
            }
            case 2: {
                return !this.getFilteredNodes().contains(node);
            }
        }
        return true;
    }

    private void setFilteredNodes(Set filteredNodes) {
        this.filteredNodes = new HashSet(filteredNodes);
    }

    private void setFilteredNodes(Object[] filteredNodes) {
        this.filteredNodes = new HashSet(filteredNodes.length);
        int i = 0;
        while (i < filteredNodes.length) {
            this.filteredNodes.add(filteredNodes[i]);
            ++i;
        }
    }

    public abstract SortedSet getEdges(Object var1) throws SearchException;
}

