/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.threads.HandoffExecutorResolver;
import org.jboss.as.threads.PoolAttributeDefinitions;
import org.jboss.as.threads.QueuelessThreadPoolAdd;
import org.jboss.as.threads.QueuelessThreadPoolMetricsHandler;
import org.jboss.as.threads.QueuelessThreadPoolRemove;
import org.jboss.as.threads.QueuelessThreadPoolWriteAttributeHandler;
import org.jboss.as.threads.ThreadFactoryResolver;
import org.jboss.as.threads.ThreadPoolResourceDescriptionResolver;
import org.jboss.as.threads.ThreadsExtension;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.msc.service.ServiceName;

public class QueuelessThreadPoolResourceDefinition
extends SimpleResourceDefinition {
    private final boolean registerRuntimeOnly;
    private final boolean blocking;
    private final ServiceName serviceNameBase;

    public static QueuelessThreadPoolResourceDefinition create(boolean blocking, boolean registerRuntimeOnly) {
        if (blocking) {
            return QueuelessThreadPoolResourceDefinition.create("blocking-queueless-thread-pool", ThreadsServices.STANDARD_THREAD_FACTORY_RESOLVER, null, ThreadsServices.EXECUTOR, registerRuntimeOnly);
        }
        return QueuelessThreadPoolResourceDefinition.create("queueless-thread-pool", ThreadsServices.STANDARD_THREAD_FACTORY_RESOLVER, ThreadsServices.STANDARD_HANDOFF_EXECUTOR_RESOLVER, ThreadsServices.EXECUTOR, registerRuntimeOnly);
    }

    public static QueuelessThreadPoolResourceDefinition create(boolean blocking, String type, boolean registerRuntimeOnly) {
        if (blocking) {
            return QueuelessThreadPoolResourceDefinition.create(type, ThreadsServices.STANDARD_THREAD_FACTORY_RESOLVER, null, ThreadsServices.EXECUTOR, registerRuntimeOnly);
        }
        return QueuelessThreadPoolResourceDefinition.create(type, ThreadsServices.STANDARD_THREAD_FACTORY_RESOLVER, ThreadsServices.STANDARD_HANDOFF_EXECUTOR_RESOLVER, ThreadsServices.EXECUTOR, registerRuntimeOnly);
    }

    public static QueuelessThreadPoolResourceDefinition create(String type, ThreadFactoryResolver threadFactoryResolver, HandoffExecutorResolver handoffExecutorResolver, ServiceName serviceNameBase, boolean registerRuntimeOnly) {
        boolean blocking = handoffExecutorResolver == null;
        String resolverPrefix = blocking ? "blocking-queueless-thread-pool" : "queueless-thread-pool";
        QueuelessThreadPoolAdd addHandler = new QueuelessThreadPoolAdd(blocking, threadFactoryResolver, handoffExecutorResolver, serviceNameBase);
        QueuelessThreadPoolRemove removeHandler = new QueuelessThreadPoolRemove(addHandler);
        return new QueuelessThreadPoolResourceDefinition(blocking, registerRuntimeOnly, type, serviceNameBase, resolverPrefix, (OperationStepHandler)addHandler, (OperationStepHandler)removeHandler);
    }

    private QueuelessThreadPoolResourceDefinition(boolean blocking, boolean registerRuntimeOnly, String type, ServiceName serviceNameBase, String resolverPrefix, OperationStepHandler addHandler, OperationStepHandler removeHandler) {
        super(PathElement.pathElement((String)type), (ResourceDescriptionResolver)new ThreadPoolResourceDescriptionResolver(resolverPrefix, ThreadsExtension.RESOURCE_NAME, ThreadsExtension.class.getClassLoader()), addHandler, removeHandler);
        this.registerRuntimeOnly = registerRuntimeOnly;
        this.blocking = blocking;
        this.serviceNameBase = serviceNameBase;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)PoolAttributeDefinitions.NAME, null);
        QueuelessThreadPoolWriteAttributeHandler writeHandler = new QueuelessThreadPoolWriteAttributeHandler(this.blocking, this.serviceNameBase);
        writeHandler.registerAttributes(resourceRegistration);
        if (this.registerRuntimeOnly) {
            new QueuelessThreadPoolMetricsHandler(this.serviceNameBase).registerAttributes(resourceRegistration);
        }
    }
}

