/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.util.Map;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.UnversionedNode;
import org.jboss.cache.VersionedNode;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.CommandsFactory;
import org.jboss.cache.factories.ComponentFactory;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.interceptors.InterceptorChain;
import org.jboss.cache.invocation.InvocationContextContainer;
import org.jboss.cache.invocation.NodeInvocationDelegate;
import org.jboss.cache.lock.LockStrategyFactory;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.jboss.cache.optimistic.WorkspaceNodeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeFactory<K, V>
extends ComponentFactory {
    private CacheSPI<K, V> cache;
    private boolean optimistic;
    private Configuration configuration;
    private InvocationContextContainer invocationContextContainer;
    private InterceptorChain interceptorChain;
    private CommandsFactory commandsFactory;
    private LockStrategyFactory lockStrategyFactory;

    @Override
    protected <T> T construct(Class<T> componentType) {
        throw new UnsupportedOperationException("Should never be called!");
    }

    public NodeFactory(CacheSPI<K, V> cache) {
        this.cache = cache;
        this.init();
    }

    public NodeFactory() {
    }

    @Inject
    private void injectDependencies(CacheSPI<K, V> cache, Configuration configuration, InvocationContextContainer invocationContextContainer, InterceptorChain interceptorChain, CommandsFactory commandsFactory, LockStrategyFactory lockStrategyFactory) {
        this.cache = cache;
        this.configuration = configuration;
        this.invocationContextContainer = invocationContextContainer;
        this.interceptorChain = interceptorChain;
        this.commandsFactory = commandsFactory;
        this.lockStrategyFactory = lockStrategyFactory;
    }

    @Start
    public void init() {
        this.optimistic = this.configuration.isNodeLockingOptimistic();
    }

    public NodeSPI<K, V> createDataNode(Object childName, Fqn fqn, NodeSPI<K, V> parent, Map<K, V> data, boolean mapSafe) {
        UnversionedNode un = this.optimistic ? new VersionedNode<K, V>(fqn, parent, data, this.cache) : new UnversionedNode(childName, fqn, data, mapSafe, this.cache);
        un.setDataLoaded(false);
        NodeInvocationDelegate nid = new NodeInvocationDelegate(un);
        nid.initialize(this.configuration, this.invocationContextContainer, this.componentRegistry, this.interceptorChain);
        nid.injectDependencies(this.cache);
        un.injectDependencies(this.cache, this.commandsFactory, this.lockStrategyFactory);
        un.setDelegate(nid);
        return nid;
    }

    public Node<K, V> createNode(Object childName, Node<K, V> parent, Map<K, V> data) {
        return this.createNodeOfType(parent, childName, parent, data);
    }

    public Node<K, V> createNodeOfType(Node<K, V> template, Object childName, Node<K, V> parent, Map<K, V> data) {
        return this.createDataNode(childName, Fqn.fromRelativeElements(parent.getFqn(), childName), (NodeSPI)parent, data, false);
    }

    public WorkspaceNode<K, V> createWorkspaceNode(NodeSPI<K, V> dataNode, TransactionWorkspace workspace) {
        return new WorkspaceNodeImpl<K, V>(dataNode, workspace);
    }

    public NodeSPI<K, V> createRootDataNode() {
        return this.createDataNode(null, Fqn.ROOT, null, null, false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NodeType {
        UNVERSIONED_NODE,
        VERSIONED_NODE,
        WORKSPACE_NODE;

    }
}

