/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands.read;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.DataContainer;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.commands.Visitor;
import org.jboss.cache.commands.read.AbstractDataCommand;
import org.jboss.cache.notifications.Notifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetKeyValueCommand
extends AbstractDataCommand {
    public static final int METHOD_ID = 26;
    private static final Log log = LogFactory.getLog(GetKeyValueCommand.class);
    private static boolean trace = log.isTraceEnabled();
    private Notifier notifier;
    private Object key;
    boolean sendNodeEvent;

    public GetKeyValueCommand(Fqn<?> fqn, Object key, boolean sendNodeEvent) {
        this.fqn = fqn;
        this.key = key;
        this.sendNodeEvent = sendNodeEvent;
    }

    public GetKeyValueCommand() {
    }

    public void initialize(DataContainer dataContainer, Notifier notifier) {
        this.dataContainer = dataContainer;
        this.notifier = notifier;
    }

    @Override
    public Object perform(InvocationContext ctx) {
        NodeSPI n;
        if (trace) {
            log.trace((Object)new StringBuilder("get(").append("\"").append(this.fqn).append("\", \"").append(this.key).append("\", \"").append(this.sendNodeEvent).append("\")"));
        }
        if ((n = this.dataContainer.peek(this.fqn)) == null) {
            log.trace((Object)"node not found");
            return null;
        }
        if (this.sendNodeEvent) {
            this.notifier.notifyNodeVisited(this.fqn, true, ctx);
        }
        Object result = n.getDirect(this.key);
        if (this.sendNodeEvent) {
            this.notifier.notifyNodeVisited(this.fqn, false, ctx);
        }
        return result;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitGetKeyValueCommand(ctx, this);
    }

    public Object getKey() {
        return this.key;
    }

    public boolean isSendNodeEvent() {
        return this.sendNodeEvent;
    }

    public void setKey(Object key) {
        this.key = key;
    }

    @Override
    public int getCommandId() {
        return 26;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.fqn, this.key, this.sendNodeEvent};
    }

    @Override
    public void setParameters(int commandId, Object[] args) {
        this.fqn = (Fqn)args[0];
        this.key = args[1];
        this.sendNodeEvent = (Boolean)args[2];
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GetKeyValueCommand that = (GetKeyValueCommand)o;
        if (this.sendNodeEvent != that.sendNodeEvent) {
            return false;
        }
        return !(this.key != null ? !this.key.equals(that.key) : that.key != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
        result = 31 * result + (this.sendNodeEvent ? 1 : 0);
        return result;
    }

    @Override
    public String toString() {
        return "GetKeyValueCommand{fqn=" + this.fqn + ", key=" + this.key + ", sendNodeEvent=" + this.sendNodeEvent + '}';
    }
}

