/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands.write;

import org.jboss.cache.DataContainer;
import org.jboss.cache.Fqn;
import org.jboss.cache.commands.VersionedDataCommand;
import org.jboss.cache.commands.read.AbstractDataCommand;
import org.jboss.cache.notifications.Notifier;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.transaction.GlobalTransaction;

public abstract class AbstractVersionedDataCommand
extends AbstractDataCommand
implements VersionedDataCommand {
    protected Notifier notifier;
    protected DataVersion dataVersion;
    protected GlobalTransaction globalTransaction;

    public void initialize(Notifier notifier, DataContainer dataContainer) {
        this.notifier = notifier;
        this.dataContainer = dataContainer;
    }

    public DataVersion getDataVersion() {
        return this.dataVersion;
    }

    public void setDataVersion(DataVersion dataVersion) {
        this.dataVersion = dataVersion;
    }

    public GlobalTransaction getGlobalTransaction() {
        return this.globalTransaction;
    }

    public void setGlobalTransaction(GlobalTransaction globalTransaction) {
        this.globalTransaction = globalTransaction;
    }

    public boolean isVersioned() {
        return this.dataVersion != null;
    }

    public Object[] getParameters() {
        if (this.isVersioned()) {
            return new Object[]{this.fqn, this.dataVersion};
        }
        return new Object[]{this.fqn};
    }

    public void setParameters(int commandId, Object[] args) {
        this.fqn = (Fqn)args[0];
        if (this.isVersionedId(commandId)) {
            this.dataVersion = (DataVersion)args[1];
        }
    }

    protected abstract boolean isVersionedId(int var1);

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        AbstractVersionedDataCommand that = (AbstractVersionedDataCommand)o;
        return !(this.fqn == null ? that.fqn != null : !this.fqn.equals(that.fqn));
    }

    public int hashCode() {
        return 31 * super.hashCode() + (this.dataVersion != null ? this.dataVersion.hashCode() : 0);
    }
}

