/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands.write;

import java.util.List;
import org.jboss.cache.DataContainer;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.commands.Visitor;
import org.jboss.cache.commands.read.AbstractDataCommand;
import org.jboss.cache.notifications.Notifier;

public class EvictCommand
extends AbstractDataCommand {
    public static final int METHOD_ID = 8;
    public static final int VERSIONED_METHOD_ID = 9;
    private boolean recursive = false;
    protected Notifier notifier;

    public EvictCommand(Fqn fqn) {
        this.fqn = fqn;
    }

    public EvictCommand() {
    }

    public void initialize(Notifier notifier, DataContainer dataContainer) {
        super.initialize(dataContainer);
        this.notifier = notifier;
    }

    public Object perform(InvocationContext ctx) {
        NodeSPI node = this.dataContainer.peek(this.fqn, false, true);
        if (node == null) {
            return false;
        }
        if (node.isResident()) {
            return true;
        }
        if (this.recursive) {
            List<Fqn> nodesToEvict = this.dataContainer.getNodesForEviction(this.fqn, true);
            for (Fqn aFqn : nodesToEvict) {
                this.evictNode(aFqn, ctx);
            }
            return !nodesToEvict.isEmpty();
        }
        return this.evictNode(this.fqn, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean evictNode(Fqn fqn, InvocationContext ctx) {
        this.notifier.notifyNodeEvicted(fqn, true, ctx);
        try {
            boolean bl = this.dataContainer.evict(fqn);
            return bl;
        }
        finally {
            this.notifier.notifyNodeEvicted(fqn, false, ctx);
        }
    }

    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitEvictFqnCommand(ctx, this);
    }

    public int getCommandId() {
        return 8;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public Object[] getParameters() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " is not meant to be marshalled and replicated!");
    }

    public void setParameters(int commandId, Object[] args) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " is not meant to be marshalled and replicated!");
    }

    public String toString() {
        return "EvictCommand{fqn=" + this.fqn + ", recursive=" + this.recursive + "}";
    }

    public void rollback() {
    }
}

