/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands.write;

import java.util.Collections;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.commands.VersionedDataCommand;
import org.jboss.cache.commands.write.InvalidateCommand;
import org.jboss.cache.config.Option;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.transaction.GlobalTransaction;

public class OptimisticInvalidateCommand
extends InvalidateCommand
implements VersionedDataCommand {
    private static final Log log = LogFactory.getLog(OptimisticInvalidateCommand.class);
    private static boolean trace = log.isTraceEnabled();
    private TransactionManager transactionManager;
    protected GlobalTransaction globalTransaction;
    private DataVersion dataVersion;

    public OptimisticInvalidateCommand(Fqn fqn) {
        super(fqn);
    }

    public OptimisticInvalidateCommand() {
    }

    public void initialize(TransactionManager txManager) {
        this.transactionManager = txManager;
    }

    public Object perform(InvocationContext ctx) {
        NodeSPI node = this.enforceNodeLoading();
        if (trace) {
            log.trace((Object)("Invalidating fqn:" + this.fqn));
        }
        if (node == null) {
            NodeSPI nodeSPI = this.dataContainer.peek(this.fqn, false, true);
            if (nodeSPI == null) {
                if (this.dataVersion == null) {
                    if (trace) {
                        log.trace((Object)"Would have created a tombstone since the node doesn't exist, but the version to invalidate is null and hence cannot create a tombstone!");
                    }
                    return null;
                }
                this.createTombstone(ctx);
                nodeSPI = (NodeSPI)this.dataContainer.getRoot().getChild(this.fqn);
            }
            node = nodeSPI;
        }
        this.removeData(ctx);
        this.invalidateNode(node);
        this.updateDataVersion();
        return null;
    }

    protected void createTombstone(InvocationContext ctx) {
        if (trace) {
            log.trace((Object)("Node doesn't exist; creating a tombstone with data version " + this.dataVersion));
        }
        Option o = ctx.getOptionOverrides();
        boolean origCacheModeLocal = o.isCacheModeLocal();
        o.setCacheModeLocal(true);
        o.setDataVersion(this.dataVersion);
        try {
            Transaction suspended = null;
            if (this.transactionManager != null) {
                suspended = this.transactionManager.suspend();
            }
            this.spi.put(this.fqn, Collections.emptyMap());
            if (suspended != null) {
                this.transactionManager.resume(suspended);
            }
            ctx.getOptionOverrides().setCacheModeLocal(origCacheModeLocal);
        }
        catch (Exception e) {
            log.error((Object)"Unable to create tombstone!", (Throwable)e);
        }
    }

    private void updateDataVersion() {
        if (this.dataVersion != null) {
            NodeSPI n = this.dataContainer.peek(this.fqn, false, true);
            n.setVersion(this.dataVersion);
        }
    }

    protected void removeData(InvocationContext ctx) throws CacheException {
        NodeSPI n = this.dataContainer.peekVersioned(this.fqn, this.dataVersion);
        if (n == null) {
            log.warn((Object)("node " + this.fqn + " not found"));
            return;
        }
        this.notifier.notifyNodeEvicted(this.fqn, true, ctx);
        n.clearDataDirect();
        n.setDataLoaded(false);
        this.notifier.notifyNodeEvicted(this.fqn, false, ctx);
    }

    public DataVersion getDataVersion() {
        return this.dataVersion;
    }

    public void setDataVersion(DataVersion dataVersion) {
        this.dataVersion = dataVersion;
    }

    public GlobalTransaction getGlobalTransaction() {
        return this.globalTransaction;
    }

    public void setGlobalTransaction(GlobalTransaction gtx) {
        this.globalTransaction = gtx;
    }

    public boolean isVersioned() {
        return this.dataVersion != null;
    }

    public String toString() {
        return "OptimisticInvalidateCommand{dataVersion=" + this.dataVersion + " ,fqn=" + this.fqn + '}';
    }

    public Object[] getParameters() {
        return new Object[]{this.fqn, this.dataVersion};
    }

    public void setParameters(int commandId, Object[] args) {
        this.fqn = (Fqn)args[0];
        this.dataVersion = (DataVersion)args[1];
    }

    public void rollback() {
    }
}

