/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.Fqn;
import org.jboss.cache.eviction.NodeEventType;

public class EvictedEventNode
implements Cloneable {
    private Fqn fqn_;
    private NodeEventType type;
    private int elementDifference;
    private long inUseTimeout;
    private long creationTimestamp;

    public EvictedEventNode(Fqn fqn, NodeEventType type, int elementDifference) {
        this(fqn, type);
        this.setElementDifference(elementDifference);
    }

    public EvictedEventNode(Fqn fqn, NodeEventType event) {
        this.setFqn(fqn);
        this.setEventType(event);
        this.creationTimestamp = System.currentTimeMillis();
    }

    public long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public long getInUseTimeout() {
        return this.inUseTimeout;
    }

    public void setInUseTimeout(long inUseTimeout) {
        this.inUseTimeout = inUseTimeout;
    }

    public int getElementDifference() {
        return this.elementDifference;
    }

    public void setElementDifference(int elementDifference_) {
        this.elementDifference = elementDifference_;
    }

    public Fqn getFqn() {
        return this.fqn_;
    }

    public void setFqn(Fqn fqn) {
        this.fqn_ = fqn;
    }

    public void setEventType(NodeEventType event) {
        this.type = event;
    }

    public NodeEventType getEventType() {
        return this.type;
    }

    public String toString() {
        return "EvictedEN[fqn=" + this.fqn_ + " event=" + (Object)((Object)this.type) + " diff=" + this.elementDifference + "]";
    }

    public EvictedEventNode clone(Fqn cloneFqn) {
        EvictedEventNode clone = null;
        try {
            clone = (EvictedEventNode)super.clone();
            clone.setFqn(Fqn.fromRelativeFqn(cloneFqn, this.fqn_));
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }
}

