/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.Map;
import org.jboss.cache.DataContainer;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.Region;
import org.jboss.cache.RegionManager;
import org.jboss.cache.commands.read.GetDataMapCommand;
import org.jboss.cache.commands.read.GetKeyValueCommand;
import org.jboss.cache.commands.read.GetNodeCommand;
import org.jboss.cache.commands.write.ClearDataCommand;
import org.jboss.cache.commands.write.EvictCommand;
import org.jboss.cache.commands.write.PutDataMapCommand;
import org.jboss.cache.commands.write.PutForExternalReadCommand;
import org.jboss.cache.commands.write.PutKeyValueCommand;
import org.jboss.cache.commands.write.RemoveKeyCommand;
import org.jboss.cache.commands.write.RemoveNodeCommand;
import org.jboss.cache.eviction.EvictedEventNode;
import org.jboss.cache.eviction.NodeEventType;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.interceptors.base.CommandInterceptor;

public class EvictionInterceptor
extends CommandInterceptor {
    protected RegionManager regionManager;
    private DataContainer dataContainer;

    @Inject
    public void initialize(DataContainer dataContainer) {
        this.dataContainer = dataContainer;
    }

    @Inject
    void setRegionManager(RegionManager regionManager) {
        this.regionManager = regionManager;
    }

    public Object visitEvictFqnCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
        Region r;
        boolean complete;
        Fqn fqn = command.getFqn();
        Object retVal = this.invokeNextInterceptor(ctx, command);
        boolean bl = complete = retVal != null && (Boolean)retVal != false;
        if (!complete && fqn != null && (r = this.getRegion(fqn, NodeEventType.ADD_NODE_EVENT)) != null) {
            this.registerEvictionEventToRegionManager(new EvictedEventNode(fqn, NodeEventType.ADD_NODE_EVENT, 0), r);
        }
        return retVal;
    }

    public Object visitPutForExternalReadCommand(InvocationContext ctx, PutForExternalReadCommand command) throws Throwable {
        return this.visitPutKeyValueCommand(ctx, command);
    }

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        Region r;
        Object retVal = this.invokeNextInterceptor(ctx, command);
        if (command.getFqn() != null && command.getKey() != null && (r = this.getRegion(command.getFqn(), NodeEventType.ADD_ELEMENT_EVENT)) != null) {
            this.registerEvictionEventToRegionManager(new EvictedEventNode(command.getFqn(), NodeEventType.ADD_ELEMENT_EVENT, 1), r);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitPutDataMapCommand(InvocationContext ctx, PutDataMapCommand command) throws Throwable {
        Region r;
        Object retVal = this.invokeNextInterceptor(ctx, command);
        Fqn fqn = command.getFqn();
        if (fqn != null && (r = this.getRegion(fqn, NodeEventType.ADD_NODE_EVENT)) != null) {
            if (command.getData() == null) {
                if (this.trace) {
                    this.log.trace((Object)("Putting null data under fqn " + fqn + "."));
                }
            } else {
                int size;
                Map map = command.getData();
                synchronized (map) {
                    size = command.getData().size();
                }
                EvictedEventNode event = new EvictedEventNode(fqn, NodeEventType.ADD_NODE_EVENT, size);
                this.registerEvictionEventToRegionManager(event, r);
            }
        }
        return retVal;
    }

    public Object visitRemoveKeyCommand(InvocationContext ctx, RemoveKeyCommand command) throws Throwable {
        Object retVal = this.invokeNextInterceptor(ctx, command);
        if (retVal == null) {
            if (this.trace) {
                this.log.trace((Object)"No event added. Element does not exist");
            }
        } else {
            Region r;
            Fqn fqn = command.getFqn();
            if (fqn != null && command.getKey() != null && (r = this.getRegion(fqn, NodeEventType.REMOVE_ELEMENT_EVENT)) != null) {
                this.registerEvictionEventToRegionManager(new EvictedEventNode(fqn, NodeEventType.REMOVE_ELEMENT_EVENT, 1), r);
            }
        }
        return retVal;
    }

    public Object visitGetNodeCommand(InvocationContext ctx, GetNodeCommand command) throws Throwable {
        Object retVal = this.invokeNextInterceptor(ctx, command);
        return this.handleGetNodeOrDataCommands(retVal, command.getFqn());
    }

    private Object handleGetNodeOrDataCommands(Object retVal, Fqn fqn) {
        Region r;
        if (retVal == null) {
            if (this.trace) {
                this.log.trace((Object)"No event added. Node does not exist");
            }
        } else if (fqn != null && (r = this.getRegion(fqn, NodeEventType.VISIT_NODE_EVENT)) != null) {
            this.registerEvictionEventToRegionManager(new EvictedEventNode(fqn, NodeEventType.VISIT_NODE_EVENT), r);
        }
        return retVal;
    }

    public Object visitGetDataMapCommand(InvocationContext ctx, GetDataMapCommand command) throws Throwable {
        Object retVal = this.invokeNextInterceptor(ctx, command);
        return this.handleGetNodeOrDataCommands(retVal, command.getFqn());
    }

    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        Region r;
        Object retVal = this.invokeNextInterceptor(ctx, command);
        Fqn fqn = command.getFqn();
        if (retVal == null) {
            if (this.trace) {
                this.log.trace((Object)"No event added. Element does not exist");
            }
        } else if (fqn != null && command.getKey() != null && (r = this.getRegion(fqn, NodeEventType.VISIT_NODE_EVENT)) != null) {
            this.registerEvictionEventToRegionManager(new EvictedEventNode(fqn, NodeEventType.VISIT_NODE_EVENT), r);
        }
        return retVal;
    }

    public Object visitRemoveNodeCommand(InvocationContext ctx, RemoveNodeCommand command) throws Throwable {
        Region r;
        Object retVal = this.invokeNextInterceptor(ctx, command);
        if (command.getFqn() != null && (r = this.getRegion(command.getFqn(), NodeEventType.REMOVE_NODE_EVENT)) != null) {
            this.registerEvictionEventToRegionManager(new EvictedEventNode(command.getFqn(), NodeEventType.REMOVE_NODE_EVENT), r);
        }
        return retVal;
    }

    public Object visitClearDataCommand(InvocationContext ctx, ClearDataCommand command) throws Throwable {
        Region r;
        Object retVal = this.invokeNextInterceptor(ctx, command);
        if (command.getFqn() != null && (r = this.getRegion(command.getFqn(), NodeEventType.REMOVE_NODE_EVENT)) != null) {
            this.registerEvictionEventToRegionManager(new EvictedEventNode(command.getFqn(), NodeEventType.REMOVE_NODE_EVENT), r);
        }
        return retVal;
    }

    private void registerEvictionEventToRegionManager(EvictedEventNode event, Region region) {
        if (event == null) {
            return;
        }
        NodeSPI nodeSPI = this.dataContainer.peek(event.getFqn(), false, false);
        if (nodeSPI != null && nodeSPI.isResident()) {
            return;
        }
        region.putNodeEvent(event);
        if (this.trace) {
            this.log.trace((Object)("Adding event " + event + " to region at " + region.getFqn()));
        }
        if (this.trace) {
            this.log.trace((Object)"Finished updating node");
        }
    }

    protected Region getRegion(Fqn fqn, NodeEventType type) {
        Region r = this.regionManager.getRegion(fqn, Region.Type.EVICTION, false);
        if (r != null && r.getEvictionPolicy().canIgnoreEvent(fqn, type)) {
            return null;
        }
        return r;
    }
}

