/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.journal;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.journal.AbstractJournal;
import org.apache.jackrabbit.core.journal.AppendRecord;
import org.apache.jackrabbit.core.journal.DatabaseRecordIterator;
import org.apache.jackrabbit.core.journal.FileRevision;
import org.apache.jackrabbit.core.journal.InstanceRevision;
import org.apache.jackrabbit.core.journal.JournalException;
import org.apache.jackrabbit.core.journal.RecordIterator;
import org.apache.jackrabbit.core.persistence.bundle.util.ConnectionFactory;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseJournal
extends AbstractJournal {
    private static final String SCHEMA_OBJECT_PREFIX_VARIABLE = "${schemaObjectPrefix}";
    private static final String DEFAULT_DDL_NAME = "default.ddl";
    private static final String DEFAULT_JOURNAL_TABLE = "JOURNAL";
    private static final String LOCAL_REVISIONS_TABLE = "LOCAL_REVISIONS";
    private static final long DEFAULT_RECONNECT_DELAY_MS = 10000L;
    private static Logger log = LoggerFactory.getLogger((Class)DatabaseJournal.class);
    private String driver;
    private String url;
    private String databaseType;
    private String user;
    private String password;
    private long reconnectDelayMs;
    private Connection connection;
    private PreparedStatement selectRevisionsStmt;
    private PreparedStatement updateGlobalStmt;
    private PreparedStatement selectGlobalStmt;
    private PreparedStatement insertRevisionStmt;
    private PreparedStatement selectMinLocalRevisionStmt;
    private PreparedStatement cleanRevisionStmt;
    private PreparedStatement getLocalRevisionStmt;
    private PreparedStatement insertLocalRevisionStmt;
    private PreparedStatement updateLocalRevisionStmt;
    private int lockLevel;
    private long lockedRevision;
    private long reconnectTimeMs;
    private boolean janitorEnabled = false;
    private int janitorSleep = 86400;
    private Calendar janitorNextRun = Calendar.getInstance();
    private Thread janitorThread;
    private boolean schemaCheckEnabled;
    private DatabaseRevision databaseRevision;
    protected String selectRevisionsStmtSQL;
    protected String updateGlobalStmtSQL;
    protected String selectGlobalStmtSQL;
    protected String insertRevisionStmtSQL;
    protected String selectMinLocalRevisionStmtSQL;
    protected String cleanRevisionStmtSQL;
    protected String getLocalRevisionStmtSQL;
    protected String insertLocalRevisionStmtSQL;
    protected String updateLocalRevisionStmtSQL;
    protected String schemaObjectPrefix;

    public DatabaseJournal() {
        if (this.janitorNextRun.get(11) >= 3) {
            this.janitorNextRun.add(5, 1);
        }
        this.janitorNextRun.set(11, 3);
        this.janitorNextRun.set(12, 0);
        this.janitorNextRun.set(13, 0);
        this.janitorNextRun.set(14, 0);
        this.schemaCheckEnabled = true;
    }

    public void init(String id, NamespaceResolver resolver) throws JournalException {
        super.init(id, resolver);
        if (this.schemaObjectPrefix == null) {
            this.schemaObjectPrefix = "";
        }
        if (this.reconnectDelayMs == 0L) {
            this.reconnectDelayMs = 10000L;
        }
        this.init();
        try {
            this.connection = this.getConnection();
            DatabaseJournal.setAutoCommit(this.connection, true);
            if (this.isSchemaCheckEnabled()) {
                this.checkSchema();
            }
            if (this.isSchemaCheckEnabled()) {
                this.checkLocalRevisionSchema();
            }
            this.buildSQLStatements();
            this.prepareStatements();
            this.initInstanceRevisionAndJanitor();
        }
        catch (Exception e) {
            String msg = "Unable to create connection.";
            throw new JournalException(msg, e);
        }
        log.info("DatabaseJournal initialized.");
    }

    protected void init() throws JournalException {
        if (this.driver == null) {
            String msg = "Driver not specified.";
            throw new JournalException(msg);
        }
        if (this.url == null) {
            String msg = "Connection URL not specified.";
            throw new JournalException(msg);
        }
        if (this.databaseType == null) {
            try {
                this.databaseType = DatabaseJournal.getDatabaseTypeFromURL(this.url);
            }
            catch (IllegalArgumentException e) {
                String msg = "Unable to derive database type from URL: " + e.getMessage();
                throw new JournalException(msg);
            }
        }
        try {
            Class.forName(this.driver);
        }
        catch (ClassNotFoundException e) {
            String msg = "Unable to load driver class.";
            throw new JournalException(msg, e);
        }
    }

    protected void initInstanceRevisionAndJanitor() throws Exception {
        this.databaseRevision = new DatabaseRevision();
        long localFileRevision = 0L;
        if (this.getRevision() != null) {
            FileRevision currentFileRevision = new FileRevision(new File(this.getRevision()));
            localFileRevision = currentFileRevision.get();
            currentFileRevision.close();
        }
        long localRevision = this.databaseRevision.init(localFileRevision);
        log.info("Initialized local revision to " + localRevision);
        if (this.janitorEnabled) {
            this.janitorThread = new Thread((Runnable)new RevisionTableJanitor(), "Jackrabbit-ClusterRevisionJanitor");
            this.janitorThread.setDaemon(true);
            this.janitorThread.start();
            log.info("Cluster revision janitor thread started; first run scheduled at " + this.janitorNextRun.getTime());
        } else {
            log.info("Cluster revision janitor thread not started");
        }
    }

    public InstanceRevision getInstanceRevision() throws JournalException {
        return this.databaseRevision;
    }

    protected Connection getConnection() throws SQLException, JournalException {
        try {
            return ConnectionFactory.getConnection(this.driver, this.url, this.user, this.password);
        }
        catch (RepositoryException e) {
            String msg = "Unable to load driver class.";
            throw new JournalException(msg, e);
        }
    }

    private static String getDatabaseTypeFromURL(String url) throws IllegalArgumentException {
        int end;
        int start = url.indexOf(58);
        if (start != -1 && (end = url.indexOf(58, start + 1)) != -1) {
            return url.substring(start + 1, end);
        }
        throw new IllegalArgumentException(url);
    }

    public RecordIterator getRecords(long startRevision) throws JournalException {
        try {
            this.checkConnection();
            this.selectRevisionsStmt.clearParameters();
            this.selectRevisionsStmt.clearWarnings();
            this.selectRevisionsStmt.setLong(1, startRevision);
            this.selectRevisionsStmt.execute();
            return new DatabaseRecordIterator(this.selectRevisionsStmt.getResultSet(), this.getResolver(), this.getNamePathResolver());
        }
        catch (SQLException e) {
            this.close(true);
            String msg = "Unable to return record iterator.";
            throw new JournalException(msg, e);
        }
    }

    public RecordIterator getRecords() throws JournalException {
        try {
            this.checkConnection();
            this.selectRevisionsStmt.clearParameters();
            this.selectRevisionsStmt.clearWarnings();
            this.selectRevisionsStmt.setLong(1, Long.MIN_VALUE);
            this.selectRevisionsStmt.execute();
            return new DatabaseRecordIterator(this.selectRevisionsStmt.getResultSet(), this.getResolver(), this.getNamePathResolver());
        }
        catch (SQLException e) {
            this.close(true);
            String msg = "Unable to return record iterator.";
            throw new JournalException(msg, e);
        }
    }

    protected void doLock() throws JournalException {
        ResultSet rs = null;
        boolean succeeded = false;
        try {
            this.checkConnection();
            if (this.lockLevel++ == 0) {
                DatabaseJournal.setAutoCommit(this.connection, false);
            }
        }
        catch (SQLException e) {
            this.close(true);
            String msg = "Unable to set autocommit to false.";
            throw new JournalException(msg, e);
        }
        try {
            this.updateGlobalStmt.clearParameters();
            this.updateGlobalStmt.clearWarnings();
            this.updateGlobalStmt.execute();
            this.selectGlobalStmt.clearParameters();
            this.selectGlobalStmt.clearWarnings();
            this.selectGlobalStmt.execute();
            rs = this.selectGlobalStmt.getResultSet();
            if (!rs.next()) {
                throw new JournalException("No revision available.");
            }
            this.lockedRevision = rs.getLong(1);
            succeeded = true;
        }
        catch (SQLException e) {
            try {
                this.close(true);
                String msg = "Unable to lock global revision table.";
                throw new JournalException(msg, e);
            }
            catch (Throwable throwable) {
                DatabaseJournal.close(rs);
                if (!succeeded) {
                    this.doUnlock(false);
                }
                throw throwable;
            }
        }
        DatabaseJournal.close(rs);
        if (!succeeded) {
            this.doUnlock(false);
        }
    }

    protected void doUnlock(boolean successful) {
        if (--this.lockLevel == 0) {
            if (successful) {
                DatabaseJournal.commit(this.connection);
            } else {
                DatabaseJournal.rollback(this.connection);
            }
            DatabaseJournal.setAutoCommit(this.connection, true);
        }
    }

    protected void appending(AppendRecord record) {
        record.setRevision(this.lockedRevision);
    }

    protected void append(AppendRecord record, InputStream in, int length) throws JournalException {
        try {
            this.checkConnection();
            this.insertRevisionStmt.clearParameters();
            this.insertRevisionStmt.clearWarnings();
            this.insertRevisionStmt.setLong(1, record.getRevision());
            this.insertRevisionStmt.setString(2, this.getId());
            this.insertRevisionStmt.setString(3, record.getProducerId());
            this.insertRevisionStmt.setBinaryStream(4, in, length);
            this.insertRevisionStmt.execute();
        }
        catch (SQLException e) {
            this.close(true);
            String msg = "Unable to append revision " + this.lockedRevision + ".";
            throw new JournalException(msg, e);
        }
    }

    public void close() {
        this.close(false);
        if (this.janitorThread != null) {
            this.janitorThread.interrupt();
        }
    }

    private void close(boolean failure) {
        if (failure) {
            this.reconnectTimeMs = System.currentTimeMillis() + this.reconnectDelayMs;
        }
        DatabaseJournal.close(this.selectRevisionsStmt);
        this.selectRevisionsStmt = null;
        DatabaseJournal.close(this.updateGlobalStmt);
        this.updateGlobalStmt = null;
        DatabaseJournal.close(this.selectGlobalStmt);
        this.selectGlobalStmt = null;
        DatabaseJournal.close(this.insertRevisionStmt);
        this.insertRevisionStmt = null;
        DatabaseJournal.close(this.selectMinLocalRevisionStmt);
        this.selectMinLocalRevisionStmt = null;
        DatabaseJournal.close(this.cleanRevisionStmt);
        this.cleanRevisionStmt = null;
        DatabaseJournal.close(this.getLocalRevisionStmt);
        this.getLocalRevisionStmt = null;
        DatabaseJournal.close(this.insertLocalRevisionStmt);
        this.insertLocalRevisionStmt = null;
        DatabaseJournal.close(this.updateLocalRevisionStmt);
        this.updateLocalRevisionStmt = null;
        DatabaseJournal.close(this.connection);
        this.connection = null;
    }

    private static void setAutoCommit(Connection connection, boolean autoCommit) {
        if (connection != null) {
            try {
                if (connection.getAutoCommit() != autoCommit) {
                    connection.setAutoCommit(autoCommit);
                }
            }
            catch (SQLException e) {
                String msg = "Unable to set autocommit flag to " + autoCommit;
                log.warn(msg, (Throwable)e);
            }
        }
    }

    private static void commit(Connection connection) {
        if (connection != null) {
            try {
                connection.commit();
            }
            catch (SQLException e) {
                String msg = "Error while committing connection: " + e.getMessage();
                log.warn(msg);
            }
        }
    }

    private static void rollback(Connection connection) {
        if (connection != null) {
            try {
                connection.rollback();
            }
            catch (SQLException e) {
                String msg = "Error while rolling back connection: " + e.getMessage();
                log.warn(msg);
            }
        }
    }

    private static void close(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                String msg = "Error while closing connection: " + e.getMessage();
                log.warn(msg);
            }
        }
    }

    private static void close(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                String msg = "Error while closing input stream: " + e.getMessage();
                log.warn(msg);
            }
        }
    }

    private static void close(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                String msg = "Error while closing statement: " + e.getMessage();
                log.warn(msg);
            }
        }
    }

    private static void close(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                String msg = "Error while closing result set: " + e.getMessage();
                log.warn(msg);
            }
        }
    }

    private void checkConnection() throws SQLException, JournalException {
        if (this.connection == null) {
            long delayMs = this.reconnectTimeMs - System.currentTimeMillis();
            if (delayMs > 0L) {
                try {
                    Thread.sleep(delayMs);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.connection = this.getConnection();
            this.prepareStatements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSchema() throws Exception {
        if (!this.tableExists(this.connection.getMetaData(), this.schemaObjectPrefix + DEFAULT_JOURNAL_TABLE)) {
            InputStream in = DatabaseJournal.class.getResourceAsStream(this.databaseType + ".ddl");
            if (in == null) {
                String msg = "No database-specific DDL found: '" + this.databaseType + ".ddl" + "', falling back to '" + DEFAULT_DDL_NAME + "'.";
                log.info(msg);
                in = DatabaseJournal.class.getResourceAsStream(DEFAULT_DDL_NAME);
                if (in == null) {
                    msg = "Unable to load 'default.ddl'.";
                    throw new JournalException(msg);
                }
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            Statement stmt = this.connection.createStatement();
            try {
                String sql = reader.readLine();
                while (sql != null) {
                    if (!sql.startsWith("#") && sql.length() > 0) {
                        sql = this.createSchemaSQL(sql);
                        stmt.executeUpdate(sql);
                    }
                    sql = reader.readLine();
                }
            }
            finally {
                DatabaseJournal.close(in);
                DatabaseJournal.close(stmt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLocalRevisionSchema() throws Exception {
        if (!this.tableExists(this.connection.getMetaData(), this.schemaObjectPrefix + LOCAL_REVISIONS_TABLE)) {
            log.info("Creating " + this.schemaObjectPrefix + LOCAL_REVISIONS_TABLE + " table");
            InputStream in = DatabaseJournal.class.getResourceAsStream(this.databaseType + ".ddl");
            if (in == null) {
                String msg = "No database-specific DDL found: '" + this.databaseType + ".ddl" + "', falling back to '" + DEFAULT_DDL_NAME + "'.";
                log.info(msg);
                in = DatabaseJournal.class.getResourceAsStream(DEFAULT_DDL_NAME);
                if (in == null) {
                    msg = "Unable to load 'default.ddl'.";
                    throw new JournalException(msg);
                }
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            Statement stmt = this.connection.createStatement();
            try {
                String sql = reader.readLine();
                while (sql != null) {
                    if (!sql.startsWith("#") && sql.length() > 0 && sql.indexOf(LOCAL_REVISIONS_TABLE) != -1) {
                        sql = this.createSchemaSQL(sql);
                        stmt.executeUpdate(sql);
                    }
                    sql = reader.readLine();
                }
            }
            finally {
                DatabaseJournal.close(in);
                DatabaseJournal.close(stmt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean tableExists(DatabaseMetaData metaData, String tableName) throws SQLException {
        if (metaData.storesLowerCaseIdentifiers()) {
            tableName = tableName.toLowerCase();
        } else if (metaData.storesUpperCaseIdentifiers()) {
            tableName = tableName.toUpperCase();
        }
        ResultSet rs = metaData.getTables(null, null, tableName, null);
        try {
            boolean bl = rs.next();
            return bl;
        }
        finally {
            rs.close();
        }
    }

    protected String createSchemaSQL(String sql) {
        return Text.replace((String)sql, (String)SCHEMA_OBJECT_PREFIX_VARIABLE, (String)this.schemaObjectPrefix);
    }

    protected void buildSQLStatements() {
        this.selectRevisionsStmtSQL = "select REVISION_ID, JOURNAL_ID, PRODUCER_ID, REVISION_DATA from " + this.schemaObjectPrefix + "JOURNAL where REVISION_ID > ? order by REVISION_ID";
        this.updateGlobalStmtSQL = "update " + this.schemaObjectPrefix + "GLOBAL_REVISION" + " set REVISION_ID = REVISION_ID + 1";
        this.selectGlobalStmtSQL = "select REVISION_ID from " + this.schemaObjectPrefix + "GLOBAL_REVISION";
        this.insertRevisionStmtSQL = "insert into " + this.schemaObjectPrefix + DEFAULT_JOURNAL_TABLE + " (REVISION_ID, JOURNAL_ID, PRODUCER_ID, REVISION_DATA) " + "values (?,?,?,?)";
        this.selectMinLocalRevisionStmtSQL = "select MIN(REVISION_ID) from " + this.schemaObjectPrefix + LOCAL_REVISIONS_TABLE;
        this.cleanRevisionStmtSQL = "delete from " + this.schemaObjectPrefix + "JOURNAL " + "where REVISION_ID < ?";
        this.getLocalRevisionStmtSQL = "select REVISION_ID from " + this.schemaObjectPrefix + "LOCAL_REVISIONS " + "where JOURNAL_ID = ?";
        this.insertLocalRevisionStmtSQL = "insert into " + this.schemaObjectPrefix + "LOCAL_REVISIONS " + "(REVISION_ID, JOURNAL_ID) values (?,?)";
        this.updateLocalRevisionStmtSQL = "update " + this.schemaObjectPrefix + "LOCAL_REVISIONS " + "set REVISION_ID = ? where JOURNAL_ID = ?";
    }

    private void prepareStatements() throws SQLException {
        this.selectRevisionsStmt = this.connection.prepareStatement(this.selectRevisionsStmtSQL);
        this.updateGlobalStmt = this.connection.prepareStatement(this.updateGlobalStmtSQL);
        this.selectGlobalStmt = this.connection.prepareStatement(this.selectGlobalStmtSQL);
        this.insertRevisionStmt = this.connection.prepareStatement(this.insertRevisionStmtSQL);
        this.selectMinLocalRevisionStmt = this.connection.prepareStatement(this.selectMinLocalRevisionStmtSQL);
        this.cleanRevisionStmt = this.connection.prepareStatement(this.cleanRevisionStmtSQL);
        this.getLocalRevisionStmt = this.connection.prepareStatement(this.getLocalRevisionStmtSQL);
        this.insertLocalRevisionStmt = this.connection.prepareStatement(this.insertLocalRevisionStmtSQL);
        this.updateLocalRevisionStmt = this.connection.prepareStatement(this.updateLocalRevisionStmtSQL);
    }

    public String getDriver() {
        return this.driver;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDatabaseType() {
        return this.databaseType;
    }

    public String getSchema() {
        return this.databaseType;
    }

    public String getSchemaObjectPrefix() {
        return this.schemaObjectPrefix;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public long getReconnectDelayMs() {
        return this.reconnectDelayMs;
    }

    public boolean getJanitorEnabled() {
        return this.janitorEnabled;
    }

    public int getJanitorSleep() {
        return this.janitorSleep;
    }

    public int getJanitorFirstRunHourOfDay() {
        return this.janitorNextRun.get(11);
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setDatabaseType(String databaseType) {
        this.databaseType = databaseType;
    }

    public void setSchema(String databaseType) {
        this.databaseType = databaseType;
    }

    public void setSchemaObjectPrefix(String schemaObjectPrefix) {
        this.schemaObjectPrefix = schemaObjectPrefix.toUpperCase();
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setReconnectDelayMs(long reconnectDelayMs) {
        this.reconnectDelayMs = reconnectDelayMs;
    }

    public void setJanitorEnabled(boolean enabled) {
        this.janitorEnabled = enabled;
    }

    public void setJanitorSleep(int sleep) {
        this.janitorSleep = sleep;
    }

    public void setJanitorFirstRunHourOfDay(int hourOfDay) {
        this.janitorNextRun = Calendar.getInstance();
        if (this.janitorNextRun.get(11) >= hourOfDay) {
            this.janitorNextRun.add(5, 1);
        }
        this.janitorNextRun.set(11, hourOfDay);
        this.janitorNextRun.set(12, 0);
        this.janitorNextRun.set(13, 0);
        this.janitorNextRun.set(14, 0);
    }

    public final boolean isSchemaCheckEnabled() {
        return this.schemaCheckEnabled;
    }

    public final void setSchemaCheckEnabled(boolean enabled) {
        this.schemaCheckEnabled = enabled;
    }

    public class RevisionTableJanitor
    implements Runnable {
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    log.info("Next clean-up run scheduled at " + DatabaseJournal.this.janitorNextRun.getTime());
                    long sleepTime = DatabaseJournal.this.janitorNextRun.getTimeInMillis() - System.currentTimeMillis();
                    if (sleepTime > 0L) {
                        Thread.sleep(sleepTime);
                    }
                    this.cleanUpOldRevisions();
                    DatabaseJournal.this.janitorNextRun.add(13, DatabaseJournal.this.janitorSleep);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            log.info("Interrupted: stopping clean-up task.");
        }

        protected void cleanUpOldRevisions() {
            try {
                long minRevision = 0L;
                DatabaseJournal.this.checkConnection();
                DatabaseJournal.this.selectMinLocalRevisionStmt.clearParameters();
                DatabaseJournal.this.selectMinLocalRevisionStmt.clearWarnings();
                DatabaseJournal.this.selectMinLocalRevisionStmt.execute();
                ResultSet rs = DatabaseJournal.this.selectMinLocalRevisionStmt.getResultSet();
                boolean cleanUp = rs.next();
                if (cleanUp) {
                    minRevision = rs.getLong(1);
                }
                rs.close();
                if (cleanUp) {
                    DatabaseJournal.this.cleanRevisionStmt.clearParameters();
                    DatabaseJournal.this.cleanRevisionStmt.clearWarnings();
                    DatabaseJournal.this.cleanRevisionStmt.setLong(1, minRevision);
                    DatabaseJournal.this.cleanRevisionStmt.execute();
                    log.info("Cleaned old revisions up to revision " + minRevision + ".");
                }
            }
            catch (Exception e) {
                log.warn("Failed to clean up old revisions.", (Throwable)e);
                DatabaseJournal.this.close(true);
            }
        }
    }

    public class DatabaseRevision
    implements InstanceRevision {
        private long localRevision;
        private boolean initialized = false;

        protected synchronized long init(long revision) throws JournalException {
            try {
                DatabaseJournal.this.checkConnection();
                DatabaseJournal.this.getLocalRevisionStmt.clearParameters();
                DatabaseJournal.this.getLocalRevisionStmt.clearWarnings();
                DatabaseJournal.this.getLocalRevisionStmt.setString(1, DatabaseJournal.this.getId());
                DatabaseJournal.this.getLocalRevisionStmt.execute();
                ResultSet rs = DatabaseJournal.this.getLocalRevisionStmt.getResultSet();
                boolean exists = rs.next();
                if (exists) {
                    revision = rs.getLong(1);
                }
                rs.close();
                if (!exists) {
                    DatabaseJournal.this.insertLocalRevisionStmt.clearParameters();
                    DatabaseJournal.this.insertLocalRevisionStmt.clearWarnings();
                    DatabaseJournal.this.insertLocalRevisionStmt.setLong(1, revision);
                    DatabaseJournal.this.insertLocalRevisionStmt.setString(2, DatabaseJournal.this.getId());
                    DatabaseJournal.this.insertLocalRevisionStmt.execute();
                }
                this.localRevision = revision;
                this.initialized = true;
                return revision;
            }
            catch (SQLException e) {
                log.warn("Failed to initialize local revision.", (Throwable)e);
                DatabaseJournal.this.close(true);
                throw new JournalException("Failed to initialize local revision", e);
            }
        }

        public synchronized long get() {
            if (!this.initialized) {
                throw new IllegalStateException("instance has not yet been initialized");
            }
            return this.localRevision;
        }

        public synchronized void set(long localRevision) throws JournalException {
            if (!this.initialized) {
                throw new IllegalStateException("instance has not yet been initialized");
            }
            try {
                DatabaseJournal.this.checkConnection();
                DatabaseJournal.this.updateLocalRevisionStmt.clearParameters();
                DatabaseJournal.this.updateLocalRevisionStmt.clearWarnings();
                DatabaseJournal.this.updateLocalRevisionStmt.setLong(1, localRevision);
                DatabaseJournal.this.updateLocalRevisionStmt.setString(2, DatabaseJournal.this.getId());
                DatabaseJournal.this.updateLocalRevisionStmt.execute();
                this.localRevision = localRevision;
            }
            catch (SQLException e) {
                log.warn("Failed to update local revision.", (Throwable)e);
                DatabaseJournal.this.close(true);
            }
        }

        public synchronized void close() {
        }
    }
}

