/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import org.apache.commons.collections.iterators.AbstractIteratorDecorator;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.HierarchyManagerImpl;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.nodetype.xml.AdditionalNamespaceResolver;
import org.apache.jackrabbit.core.query.QueryHandlerContext;
import org.apache.jackrabbit.core.query.lucene.AggregateRule;
import org.apache.jackrabbit.core.query.lucene.AggregateRuleImpl;
import org.apache.jackrabbit.core.query.lucene.IndexingConfiguration;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.PathFactory;
import org.apache.jackrabbit.spi.commons.conversion.IllegalNameException;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.conversion.ParsingNameResolver;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.apache.jackrabbit.spi.commons.name.Pattern;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.lucene.analysis.Analyzer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IndexingConfigurationImpl
implements IndexingConfiguration {
    private static final Logger log = LoggerFactory.getLogger((Class)IndexingConfigurationImpl.class);
    private static final PathFactory PATH_FACTORY = PathFactoryImpl.getInstance();
    private NameResolver resolver;
    private ItemStateManager ism;
    private HierarchyManager hmgr;
    private Map configElements = new HashMap();
    private AggregateRule[] aggregateRules;
    private Map analyzers = new HashMap();
    static /* synthetic */ Class class$org$apache$jackrabbit$core$query$lucene$JackrabbitAnalyzer;
    static /* synthetic */ Class class$org$apache$lucene$analysis$Analyzer;

    public void init(Element config, QueryHandlerContext context, NamespaceMappings nsMappings) throws Exception {
        this.ism = context.getItemStateManager();
        this.hmgr = new HierarchyManagerImpl(context.getRootId(), this.ism);
        AdditionalNamespaceResolver nsResolver = new AdditionalNamespaceResolver(this.getNamespaces(config));
        this.resolver = new ParsingNameResolver(NameFactoryImpl.getInstance(), (NamespaceResolver)nsResolver);
        NodeTypeRegistry ntReg = context.getNodeTypeRegistry();
        Name[] ntNames = ntReg.getRegisteredNodeTypes();
        ArrayList<AggregateRuleImpl> idxAggregates = new ArrayList<AggregateRuleImpl>();
        NodeList indexingConfigs = config.getChildNodes();
        for (int i = 0; i < indexingConfigs.getLength(); ++i) {
            Node configNode = indexingConfigs.item(i);
            if (configNode.getNodeName().equals("index-rule")) {
                IndexingRule element = new IndexingRule(configNode);
                log.debug("Found rule '{}' for NodeType '{}'", (Object)element, (Object)element.getNodeTypeName());
                for (int n = 0; n < ntNames.length; ++n) {
                    if (!ntReg.getEffectiveNodeType(ntNames[n]).includesNodeType(element.getNodeTypeName())) continue;
                    ArrayList<IndexingRule> perNtConfig = (ArrayList<IndexingRule>)this.configElements.get(ntNames[n]);
                    if (perNtConfig == null) {
                        perNtConfig = new ArrayList<IndexingRule>();
                        this.configElements.put(ntNames[n], perNtConfig);
                    }
                    log.debug("Registering it for name '{}'", (Object)ntNames[n]);
                    perNtConfig.add(new IndexingRule(element, ntNames[n]));
                }
                continue;
            }
            if (configNode.getNodeName().equals("aggregate")) {
                idxAggregates.add(new AggregateRuleImpl(configNode, this.resolver, this.ism, this.hmgr));
                continue;
            }
            if (!configNode.getNodeName().equals("analyzers")) continue;
            NodeList childNodes = configNode.getChildNodes();
            for (int j = 0; j < childNodes.getLength(); ++j) {
                Node analyzerNode = childNodes.item(j);
                if (!analyzerNode.getNodeName().equals("analyzer")) continue;
                String analyzerClassName = analyzerNode.getAttributes().getNamedItem("class").getNodeValue();
                try {
                    Class<?> clazz = Class.forName(analyzerClassName);
                    if (clazz == (class$org$apache$jackrabbit$core$query$lucene$JackrabbitAnalyzer == null ? IndexingConfigurationImpl.class$("org.apache.jackrabbit.core.query.lucene.JackrabbitAnalyzer") : class$org$apache$jackrabbit$core$query$lucene$JackrabbitAnalyzer)) {
                        log.warn("Not allowed to configure " + (class$org$apache$jackrabbit$core$query$lucene$JackrabbitAnalyzer == null ? IndexingConfigurationImpl.class$("org.apache.jackrabbit.core.query.lucene.JackrabbitAnalyzer") : class$org$apache$jackrabbit$core$query$lucene$JackrabbitAnalyzer).getName() + " for a property. " + "Using default analyzer for that property.");
                        continue;
                    }
                    if ((class$org$apache$lucene$analysis$Analyzer == null ? IndexingConfigurationImpl.class$("org.apache.lucene.analysis.Analyzer") : class$org$apache$lucene$analysis$Analyzer).isAssignableFrom(clazz)) {
                        Analyzer analyzer = (Analyzer)clazz.newInstance();
                        NodeList propertyChildNodes = analyzerNode.getChildNodes();
                        for (int k = 0; k < propertyChildNodes.getLength(); ++k) {
                            Node propertyNode = propertyChildNodes.item(k);
                            if (!propertyNode.getNodeName().equals("property")) continue;
                            Name propName = this.resolver.getQName(IndexingConfigurationImpl.getTextContent(propertyNode));
                            String fieldName = nsMappings.translateName(propName);
                            int idx = fieldName.indexOf(58);
                            Analyzer prevAnalyzer = this.analyzers.put(fieldName = fieldName.substring(0, idx + 1) + "FULL:" + fieldName.substring(idx + 1), analyzer);
                            if (prevAnalyzer == null) continue;
                            log.warn("Property " + propName.getLocalName() + " has been configured for multiple analyzers. " + " Last configured analyzer is used");
                        }
                        continue;
                    }
                    log.warn("org.apache.lucene.analysis.Analyzer is not a superclass of " + analyzerClassName + ". Ignoring this configure analyzer");
                    continue;
                }
                catch (ClassNotFoundException e) {
                    log.warn("Analyzer class not found: " + analyzerClassName, (Throwable)e);
                }
            }
        }
        this.aggregateRules = idxAggregates.toArray(new AggregateRule[idxAggregates.size()]);
    }

    public AggregateRule[] getAggregateRules() {
        return this.aggregateRules;
    }

    public boolean isIndexed(NodeState state, Name propertyName) {
        IndexingRule rule = this.getApplicableIndexingRule(state);
        if (rule != null) {
            return rule.isIndexed(propertyName);
        }
        return true;
    }

    public float getPropertyBoost(NodeState state, Name propertyName) {
        IndexingRule rule = this.getApplicableIndexingRule(state);
        if (rule != null) {
            return rule.getBoost(propertyName);
        }
        return 1.0f;
    }

    public float getNodeBoost(NodeState state) {
        IndexingRule rule = this.getApplicableIndexingRule(state);
        if (rule != null) {
            return rule.getNodeBoost();
        }
        return 1.0f;
    }

    public boolean isIncludedInNodeScopeIndex(NodeState state, Name propertyName) {
        IndexingRule rule = this.getApplicableIndexingRule(state);
        if (rule != null) {
            return rule.isIncludedInNodeScopeIndex(propertyName);
        }
        return true;
    }

    public boolean useInExcerpt(NodeState state, Name propertyName) {
        IndexingRule rule = this.getApplicableIndexingRule(state);
        if (rule != null) {
            return rule.useInExcerpt(propertyName);
        }
        return true;
    }

    public Analyzer getPropertyAnalyzer(String fieldName) {
        if (this.analyzers.containsKey(fieldName)) {
            return (Analyzer)this.analyzers.get(fieldName);
        }
        return null;
    }

    private IndexingRule getApplicableIndexingRule(NodeState state) {
        ArrayList rules = null;
        List r = (List)this.configElements.get(state.getNodeTypeName());
        if (r != null) {
            rules = new ArrayList();
            rules.addAll(r);
        }
        Iterator it = state.getMixinTypeNames().iterator();
        while (it.hasNext()) {
            r = (List)this.configElements.get(it.next());
            if (r == null) continue;
            if (rules == null) {
                rules = new ArrayList();
            }
            rules.addAll(r);
        }
        if (rules != null) {
            it = rules.iterator();
            while (it.hasNext()) {
                IndexingRule ir = (IndexingRule)it.next();
                if (!ir.appliesTo(state)) continue;
                return ir;
            }
        }
        return null;
    }

    private Properties getNamespaces(Node node) {
        Properties namespaces = new Properties();
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            if (!attribute.getName().startsWith("xmlns:")) continue;
            namespaces.setProperty(attribute.getName().substring(6), attribute.getValue());
        }
        return namespaces;
    }

    private void createPropertyConfigs(Node config, Map propConfigs, List namePatterns) throws IllegalNameException, NamespaceException {
        NodeList childNodes = config.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node n = childNodes.item(i);
            if (!n.getNodeName().equals("property")) continue;
            NamedNodeMap attributes = n.getAttributes();
            float boost = 1.0f;
            Node boostAttr = attributes.getNamedItem("boost");
            if (boostAttr != null) {
                try {
                    boost = Float.parseFloat(boostAttr.getNodeValue());
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            boolean nodeScopeIndex = true;
            Node nsIndex = attributes.getNamedItem("nodeScopeIndex");
            if (nsIndex != null) {
                nodeScopeIndex = Boolean.valueOf(nsIndex.getNodeValue());
            }
            boolean isRegexp = false;
            Node regexp = attributes.getNamedItem("isRegexp");
            if (regexp != null) {
                isRegexp = Boolean.valueOf(regexp.getNodeValue());
            }
            boolean useInExcerpt = true;
            Node excerpt = attributes.getNamedItem("useInExcerpt");
            if (excerpt != null) {
                useInExcerpt = Boolean.valueOf(excerpt.getNodeValue());
            }
            PropertyConfig pc = new PropertyConfig(boost, nodeScopeIndex, useInExcerpt);
            if (isRegexp) {
                namePatterns.add(new NamePattern(IndexingConfigurationImpl.getTextContent(n), pc, this.resolver));
                continue;
            }
            Name propName = this.resolver.getQName(IndexingConfigurationImpl.getTextContent(n));
            propConfigs.put(propName, pc);
        }
    }

    private PathExpression getCondition(Node config) throws MalformedPathException, IllegalNameException, NamespaceException {
        String propertyValue;
        Name propertyName;
        int idx;
        int axis;
        Node conditionAttr = config.getAttributes().getNamedItem("condition");
        if (conditionAttr == null) {
            return null;
        }
        String conditionString = conditionAttr.getNodeValue();
        Name elementTest = null;
        Name nameTest = null;
        if (conditionString.startsWith("ancestor::")) {
            axis = 2;
            idx = "ancestor::".length();
        } else if (conditionString.startsWith("parent::")) {
            axis = 3;
            idx = "parent::".length();
        } else if (conditionString.startsWith("@")) {
            axis = 0;
            idx = "@".length();
        } else {
            axis = 1;
            idx = 0;
        }
        try {
            String name;
            if (conditionString.startsWith("element(", idx)) {
                int colon = conditionString.indexOf(44, idx + "element(".length());
                name = conditionString.substring(idx + "element(".length(), colon).trim();
                if (!name.equals("*")) {
                    nameTest = this.resolver.getQName(ISO9075.decode((String)name));
                }
                idx = conditionString.indexOf(")/@", colon);
                String type = conditionString.substring(colon + 1, idx).trim();
                elementTest = this.resolver.getQName(ISO9075.decode((String)type));
                idx += ")/@".length();
            } else if (axis == 2 || axis == 1 || axis == 3) {
                String name2 = conditionString.substring(idx, conditionString.indexOf(47, idx));
                if (!name2.equals("*")) {
                    nameTest = this.resolver.getQName(ISO9075.decode((String)name2));
                }
                idx += name2.length() + "/@".length();
            }
            int eq = conditionString.indexOf(61, idx);
            name = conditionString.substring(idx, eq).trim();
            propertyName = this.resolver.getQName(ISO9075.decode((String)name));
            int quote = conditionString.indexOf(39, eq) + 1;
            propertyValue = conditionString.substring(quote, conditionString.indexOf(39, quote));
        }
        catch (IndexOutOfBoundsException e) {
            throw new MalformedPathException(conditionString);
        }
        return new PathExpression(axis, elementTest, nameTest, propertyName, propertyValue);
    }

    private static String getTextContent(Node node) {
        StringBuffer content = new StringBuffer();
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (n.getNodeType() != 3) continue;
            content.append(((CharacterData)n).getData());
        }
        return content.toString();
    }

    private class PathExpression {
        static final int SELF = 0;
        static final int CHILD = 1;
        static final int ANCESTOR = 2;
        static final int PARENT = 3;
        private final int axis;
        private final Name elementTest;
        private final Name nameTest;
        private final Name propertyName;
        private final String propertyValue;

        PathExpression(int axis, Name elementTest, Name nameTest, Name propertyName, String propertyValue) {
            this.axis = axis;
            this.elementTest = elementTest;
            this.nameTest = nameTest;
            this.propertyName = propertyName;
            this.propertyValue = propertyValue;
        }

        boolean evaluate(final NodeState context) {
            Iterator<Object> nodeStates;
            block18: {
                if (this.axis == 0) {
                    nodeStates = Collections.singletonList(context).iterator();
                } else if (this.axis == 1) {
                    nodeStates = new AbstractIteratorDecorator(context.getChildNodeEntries().iterator()){

                        public Object next() {
                            ChildNodeEntry cne = (ChildNodeEntry)super.next();
                            try {
                                return IndexingConfigurationImpl.this.ism.getItemState(cne.getId());
                            }
                            catch (ItemStateException e) {
                                NoSuchElementException nsee = new NoSuchElementException("No node with id " + cne.getId() + " found in child axis");
                                nsee.initCause(e);
                                throw nsee;
                            }
                        }
                    };
                } else if (this.axis == 2) {
                    try {
                        nodeStates = new Iterator(){
                            private NodeState next;
                            {
                                this.next = (NodeState)IndexingConfigurationImpl.this.ism.getItemState(context.getParentId());
                            }

                            public void remove() {
                                throw new UnsupportedOperationException();
                            }

                            public boolean hasNext() {
                                return this.next != null;
                            }

                            public Object next() {
                                NodeState tmp = this.next;
                                try {
                                    this.next = this.next.getParentId() != null ? (NodeState)IndexingConfigurationImpl.this.ism.getItemState(this.next.getParentId()) : null;
                                }
                                catch (ItemStateException e) {
                                    this.next = null;
                                }
                                return tmp;
                            }
                        };
                    }
                    catch (ItemStateException e) {
                        nodeStates = Collections.EMPTY_LIST.iterator();
                    }
                } else if (this.axis == 3) {
                    try {
                        if (context.getParentId() != null) {
                            NodeState state = (NodeState)IndexingConfigurationImpl.this.ism.getItemState(context.getParentId());
                            nodeStates = Collections.singletonList(state).iterator();
                            break block18;
                        }
                        nodeStates = Collections.EMPTY_LIST.iterator();
                    }
                    catch (ItemStateException e) {
                        nodeStates = Collections.EMPTY_LIST.iterator();
                    }
                } else {
                    nodeStates = Collections.EMPTY_LIST.iterator();
                }
            }
            while (nodeStates.hasNext()) {
                try {
                    NodeState current = nodeStates.next();
                    if (this.elementTest != null && !current.getNodeTypeName().equals(this.elementTest) || this.nameTest != null && !IndexingConfigurationImpl.this.hmgr.getName(current.getNodeId()).equals(this.nameTest) || !current.hasPropertyName(this.propertyName)) continue;
                    PropertyId propId = new PropertyId(current.getNodeId(), this.propertyName);
                    PropertyState propState = (PropertyState)IndexingConfigurationImpl.this.ism.getItemState(propId);
                    InternalValue[] values = propState.getValues();
                    for (int i = 0; i < values.length; ++i) {
                        if (!values[i].toString().equals(this.propertyValue)) continue;
                        return true;
                    }
                }
                catch (RepositoryException e) {
                }
                catch (ItemStateException itemStateException) {
                }
            }
            return false;
        }
    }

    private class PropertyConfig {
        final float boost;
        final boolean nodeScopeIndex;
        final boolean useInExcerpt;

        PropertyConfig(float boost, boolean nodeScopeIndex, boolean useInExcerpt) {
            this.boost = boost;
            this.nodeScopeIndex = nodeScopeIndex;
            this.useInExcerpt = useInExcerpt;
        }
    }

    private class IndexingRule {
        private final Name nodeTypeName;
        private final Map propConfigs;
        private final List namePatterns;
        private final PathExpression condition;
        private final float boost;

        IndexingRule(IndexingRule original, Name nodeTypeName) {
            this.nodeTypeName = nodeTypeName;
            this.propConfigs = original.propConfigs;
            this.namePatterns = original.namePatterns;
            this.condition = original.condition;
            this.boost = original.boost;
        }

        IndexingRule(Node config) throws MalformedPathException, IllegalNameException, NamespaceException {
            this.nodeTypeName = this.getNodeTypeName(config);
            this.condition = IndexingConfigurationImpl.this.getCondition(config);
            this.boost = this.getNodeBoost(config);
            this.propConfigs = new HashMap();
            this.namePatterns = new ArrayList();
            IndexingConfigurationImpl.this.createPropertyConfigs(config, this.propConfigs, this.namePatterns);
        }

        public Name getNodeTypeName() {
            return this.nodeTypeName;
        }

        public float getNodeBoost() {
            return this.boost;
        }

        public boolean isIndexed(Name propertyName) {
            return this.getConfig(propertyName) != null;
        }

        public float getBoost(Name propertyName) {
            PropertyConfig config = this.getConfig(propertyName);
            if (config != null) {
                return config.boost;
            }
            return 1.0f;
        }

        public boolean isIncludedInNodeScopeIndex(Name propertyName) {
            PropertyConfig config = this.getConfig(propertyName);
            if (config != null) {
                return config.nodeScopeIndex;
            }
            return false;
        }

        public boolean useInExcerpt(Name propertyName) {
            PropertyConfig config = this.getConfig(propertyName);
            if (config != null) {
                return config.useInExcerpt;
            }
            return true;
        }

        public boolean appliesTo(NodeState state) {
            if (!this.nodeTypeName.equals(state.getNodeTypeName())) {
                return false;
            }
            if (this.condition == null) {
                return true;
            }
            return this.condition.evaluate(state);
        }

        private PropertyConfig getConfig(Name propertyName) {
            PropertyConfig config = (PropertyConfig)this.propConfigs.get(propertyName);
            if (config != null) {
                return config;
            }
            if (this.namePatterns.size() > 0) {
                Path path = PATH_FACTORY.create(propertyName);
                Iterator it = this.namePatterns.iterator();
                while (it.hasNext()) {
                    NamePattern np = (NamePattern)it.next();
                    if (!np.matches(path)) continue;
                    return np.getConfig();
                }
            }
            return null;
        }

        private Name getNodeTypeName(Node config) throws IllegalNameException, NamespaceException {
            String ntString = config.getAttributes().getNamedItem("nodeType").getNodeValue();
            return IndexingConfigurationImpl.this.resolver.getQName(ntString);
        }

        private float getNodeBoost(Node config) {
            Node boost = config.getAttributes().getNamedItem("boost");
            if (boost != null) {
                try {
                    return Float.parseFloat(boost.getNodeValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return 1.0f;
        }
    }

    private static final class NamePattern {
        private final Pattern pattern;
        private final PropertyConfig config;

        private NamePattern(String pattern, PropertyConfig config, NameResolver resolver) throws IllegalNameException, NamespaceException {
            String uri = "";
            String localPattern = pattern;
            int idx = pattern.indexOf(58);
            if (idx != -1) {
                uri = resolver.getQName(pattern.substring(0, idx) + ":a").getNamespaceURI();
                localPattern = pattern.substring(idx + 1);
            }
            this.pattern = Pattern.name((String)uri, (String)localPattern);
            this.config = config;
        }

        boolean matches(Path path) {
            return this.pattern.match(path).isFullMatch();
        }

        PropertyConfig getConfig() {
            return this.config;
        }
    }
}

