/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.query.QueryResult;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.query.PropertyTypeRegistry;
import org.apache.jackrabbit.core.query.lucene.AbstractQueryImpl;
import org.apache.jackrabbit.core.query.lucene.FilterMultiColumnQuery;
import org.apache.jackrabbit.core.query.lucene.LuceneQueryFactoryImpl;
import org.apache.jackrabbit.core.query.lucene.MultiColumnQuery;
import org.apache.jackrabbit.core.query.lucene.MultiColumnQueryResult;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.jackrabbit.core.query.lucene.constraint.Constraint;
import org.apache.jackrabbit.core.query.lucene.constraint.ConstraintBuilder;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.apache.jackrabbit.spi.commons.query.jsr283.qom.PropertyValue;
import org.apache.jackrabbit.spi.commons.query.qom.BindVariableValueImpl;
import org.apache.jackrabbit.spi.commons.query.qom.ColumnImpl;
import org.apache.jackrabbit.spi.commons.query.qom.DefaultTraversingQOMTreeVisitor;
import org.apache.jackrabbit.spi.commons.query.qom.OrderingImpl;
import org.apache.jackrabbit.spi.commons.query.qom.QOMTreeVisitor;
import org.apache.jackrabbit.spi.commons.query.qom.QueryObjectModelTree;

public class QueryObjectModelImpl
extends AbstractQueryImpl {
    private final QueryObjectModelTree qomTree;

    public QueryObjectModelImpl(SessionImpl session, ItemManager itemMgr, SearchIndex index, PropertyTypeRegistry propReg, QueryObjectModelTree qomTree) {
        super(session, itemMgr, index, propReg);
        this.qomTree = qomTree;
        this.extractBindVariableNames();
    }

    public boolean needsSystemTree() {
        return true;
    }

    public QueryResult execute(long offset, long limit) throws RepositoryException {
        LuceneQueryFactoryImpl factory = new LuceneQueryFactoryImpl(this.session, this.index.getSortComparatorSource(), this.index.getContext().getHierarchyManager(), this.index.getNamespaceMappings(), this.index.getTextAnalyzer(), this.index.getSynonymProvider(), this.index.getIndexFormatVersion());
        MultiColumnQuery query = factory.create(this.qomTree.getSource());
        if (this.qomTree.getConstraint() != null) {
            Constraint c = ConstraintBuilder.create(this.qomTree.getConstraint(), this.getBindVariableValues(), this.qomTree.getSource().getSelectors(), factory, this.session.getValueFactory());
            query = new FilterMultiColumnQuery(query, c);
        }
        ColumnImpl[] columns = this.qomTree.getColumns();
        Name[] selectProps = new Name[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            selectProps[i] = columns[i].getPropertyQName();
        }
        OrderingImpl[] orderings = this.qomTree.getOrderings();
        Path[] orderProps = new Path[orderings.length];
        boolean[] orderSpecs = new boolean[orderings.length];
        for (int i = 0; i < orderings.length; ++i) {
            boolean bl = orderSpecs[i] = orderings[i].getOrder() == 301;
            if (!(orderings[i].getOperand() instanceof PropertyValue)) {
                throw new UnsupportedRepositoryOperationException("order by with" + orderings[i].getOperand() + " not yet implemented");
            }
            PropertyValue pv = (PropertyValue)orderings[i].getOperand();
            orderProps[i] = PathFactoryImpl.getInstance().create(pv.getPropertyName());
        }
        return new MultiColumnQueryResult(this.index, this.itemMgr, this.session, this.session.getAccessManager(), this, query, null, selectProps, orderProps, orderSpecs, this.getRespectDocumentOrder(), offset, limit);
    }

    private void extractBindVariableNames() {
        try {
            this.qomTree.accept((QOMTreeVisitor)new DefaultTraversingQOMTreeVisitor(){

                public Object visit(BindVariableValueImpl node, Object data) {
                    QueryObjectModelImpl.this.addVariableName(node.getBindVariableQName());
                    return data;
                }
            }, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

