/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization.combined;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.api.jsr283.security.AccessControlPolicy;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.security.authorization.AbstractAccessControlProvider;
import org.apache.jackrabbit.core.security.authorization.AbstractCompiledPermissions;
import org.apache.jackrabbit.core.security.authorization.AccessControlEditor;
import org.apache.jackrabbit.core.security.authorization.AccessControlProvider;
import org.apache.jackrabbit.core.security.authorization.AccessControlUtils;
import org.apache.jackrabbit.core.security.authorization.CompiledPermissions;
import org.apache.jackrabbit.core.security.authorization.combined.CombinedEditor;
import org.apache.jackrabbit.core.security.authorization.principalbased.ACLProvider;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombinedProvider
extends AbstractAccessControlProvider {
    private static Logger log = LoggerFactory.getLogger((Class)CombinedProvider.class);
    private AccessControlProvider[] providers;

    public boolean isAcItem(Path absPath) throws RepositoryException {
        for (int i = 0; i < this.providers.length; ++i) {
            if (!(this.providers[i] instanceof AccessControlUtils) || !((AccessControlUtils)((Object)this.providers[i])).isAcItem(absPath)) continue;
            return true;
        }
        return false;
    }

    public boolean isAcItem(ItemImpl item) throws RepositoryException {
        for (int i = 0; i < this.providers.length; ++i) {
            if (!(this.providers[i] instanceof AccessControlUtils) || !((AccessControlUtils)((Object)this.providers[i])).isAcItem(item)) continue;
            return true;
        }
        return false;
    }

    public void close() {
        for (int i = 0; i < this.providers.length; ++i) {
            this.providers[i].close();
        }
        super.close();
    }

    public void init(Session systemSession, Map configuration) throws RepositoryException {
        super.init(systemSession, configuration);
        this.providers = new AccessControlProvider[2];
        this.providers[0] = new org.apache.jackrabbit.core.security.authorization.acl.ACLProvider();
        HashMap<String, Boolean> config = new HashMap<String, Boolean>(configuration);
        config.put("omit-default-permission", Boolean.TRUE);
        this.providers[0].init(systemSession, config);
        this.providers[1] = new ACLProvider();
        this.providers[1].init(systemSession, configuration);
    }

    public AccessControlPolicy[] getEffectivePolicies(Path absPath) throws ItemNotFoundException, RepositoryException {
        ArrayList<AccessControlPolicy> l = new ArrayList<AccessControlPolicy>();
        for (int i = 0; i < this.providers.length; ++i) {
            l.addAll(Arrays.asList(this.providers[i].getEffectivePolicies(absPath)));
        }
        return l.toArray(new AccessControlPolicy[l.size()]);
    }

    public AccessControlEditor getEditor(Session editingSession) {
        this.checkInitialized();
        ArrayList<AccessControlEditor> editors = new ArrayList<AccessControlEditor>();
        for (int i = 0; i < this.providers.length; ++i) {
            try {
                editors.add(this.providers[i].getEditor(editingSession));
                continue;
            }
            catch (RepositoryException e) {
                log.debug(e.getMessage());
            }
        }
        if (!editors.isEmpty()) {
            return new CombinedEditor(editors.toArray(new AccessControlEditor[editors.size()]));
        }
        log.debug("None of the derived access control providers supports editing.");
        return null;
    }

    public CompiledPermissions compilePermissions(Set principals) throws RepositoryException {
        this.checkInitialized();
        if (this.isAdminOrSystem(principals)) {
            return this.getAdminPermissions();
        }
        return new CompiledPermissionImpl(principals);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canAccessRoot(Set principals) throws RepositoryException {
        this.checkInitialized();
        if (this.isAdminOrSystem(principals)) {
            return true;
        }
        CompiledPermissionImpl cp = new CompiledPermissionImpl(principals);
        try {
            Path rootPath = PathFactoryImpl.getInstance().getRootPath();
            boolean bl = cp.grants(rootPath, 1);
            return bl;
        }
        finally {
            cp.close();
        }
    }

    private class CompiledPermissionImpl
    extends AbstractCompiledPermissions {
        private final List cPermissions = new ArrayList();

        private CompiledPermissionImpl(Set principals) throws RepositoryException {
            for (int i = 0; i < CombinedProvider.this.providers.length; ++i) {
                CompiledPermissions cp = CombinedProvider.this.providers[i].compilePermissions(principals);
                if (cp instanceof AbstractCompiledPermissions) {
                    this.cPermissions.add(cp);
                    continue;
                }
                log.warn("AbstractCompiledPermissions expected. Found " + cp.getClass().getName() + " -> ignore.");
            }
        }

        protected AbstractCompiledPermissions.Result buildResult(Path absPath) throws RepositoryException {
            AbstractCompiledPermissions.Result res = null;
            Iterator it = this.cPermissions.iterator();
            while (it.hasNext()) {
                AbstractCompiledPermissions acp = (AbstractCompiledPermissions)it.next();
                AbstractCompiledPermissions.Result other = acp.getResult(absPath);
                res = res == null ? other : res.combine(other);
            }
            return res;
        }

        public AbstractCompiledPermissions.Result getResult(Path absPath) throws RepositoryException {
            return this.buildResult(absPath);
        }

        public synchronized void close() {
            Iterator it = this.cPermissions.iterator();
            while (it.hasNext()) {
                CompiledPermissions cp = (CompiledPermissions)it.next();
                cp.close();
                it.remove();
            }
            super.close();
        }
    }
}

