/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.simple;

import javax.jcr.AccessDeniedException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.security.auth.Subject;
import org.apache.jackrabbit.api.jsr283.security.AccessControlPolicy;
import org.apache.jackrabbit.api.jsr283.security.Privilege;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.security.AMContext;
import org.apache.jackrabbit.core.security.AbstractAccessControlManager;
import org.apache.jackrabbit.core.security.AccessManager;
import org.apache.jackrabbit.core.security.AnonymousPrincipal;
import org.apache.jackrabbit.core.security.SystemPrincipal;
import org.apache.jackrabbit.core.security.authorization.AccessControlProvider;
import org.apache.jackrabbit.core.security.authorization.NamedAccessControlPolicyImpl;
import org.apache.jackrabbit.core.security.authorization.PrivilegeRegistry;
import org.apache.jackrabbit.core.security.authorization.WorkspaceAccessManager;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;

public class SimpleAccessManager
extends AbstractAccessControlManager
implements AccessManager {
    private static final AccessControlPolicy POLICY = new NamedAccessControlPolicyImpl("Simple AccessControlPolicy");
    private Subject subject;
    private HierarchyManager hierMgr;
    private NamePathResolver resolver;
    private WorkspaceAccessManager wspAccessMgr;
    private PrivilegeRegistry privilegeRegistry;
    private boolean initialized = false;
    private boolean system = false;
    private boolean anonymous = false;

    public void init(AMContext context) throws AccessDeniedException, Exception {
        this.init(context, null, null);
    }

    public void init(AMContext context, AccessControlProvider acProvider, WorkspaceAccessManager wspAccessManager) throws AccessDeniedException, Exception {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
        this.subject = context.getSubject();
        this.hierMgr = context.getHierarchyManager();
        this.resolver = context.getNamePathResolver();
        this.privilegeRegistry = new PrivilegeRegistry((NameResolver)this.resolver);
        this.wspAccessMgr = wspAccessManager;
        this.anonymous = !this.subject.getPrincipals(AnonymousPrincipal.class).isEmpty();
        this.system = !this.subject.getPrincipals(SystemPrincipal.class).isEmpty();
        this.initialized = true;
        if (!this.canAccess(context.getWorkspaceName())) {
            throw new AccessDeniedException("Not allowed to access Workspace " + context.getWorkspaceName());
        }
    }

    public synchronized void close() throws Exception {
        this.checkInitialized();
        this.initialized = false;
    }

    public void checkPermission(ItemId id, int permissions) throws AccessDeniedException, RepositoryException {
        if (!this.isGranted(id, permissions)) {
            throw new AccessDeniedException("Access denied");
        }
    }

    public void checkPermission(Path absPath, int permissions) throws AccessDeniedException, RepositoryException {
        if (!this.isGranted(absPath, permissions)) {
            throw new AccessDeniedException("Access denied");
        }
    }

    public boolean isGranted(ItemId id, int permissions) throws RepositoryException {
        this.checkInitialized();
        if (this.system) {
            return true;
        }
        return !this.anonymous || (permissions & 2) != 2 && (permissions & 4) != 4;
    }

    public boolean isGranted(Path absPath, int permissions) throws RepositoryException {
        return this.internalIsGranted(absPath, permissions);
    }

    public boolean isGranted(Path parentPath, Name childName, int permissions) throws RepositoryException {
        return this.internalIsGranted(parentPath, permissions);
    }

    public boolean canRead(Path itemPath) throws RepositoryException {
        return true;
    }

    private boolean internalIsGranted(Path absPath, int permissions) throws RepositoryException {
        if (!absPath.isAbsolute()) {
            throw new RepositoryException("Absolute path expected");
        }
        this.checkInitialized();
        if (this.system) {
            return true;
        }
        if (this.anonymous) {
            return permissions == 1;
        }
        return true;
    }

    public boolean canAccess(String workspaceName) throws RepositoryException {
        if (this.system || this.wspAccessMgr == null) {
            return true;
        }
        return this.wspAccessMgr.grants(this.subject.getPrincipals(), workspaceName);
    }

    public boolean hasPrivileges(String absPath, Privilege[] privileges) throws PathNotFoundException, RepositoryException {
        this.checkInitialized();
        this.checkValidNodePath(absPath);
        if (privileges == null || privileges.length == 0) {
            return true;
        }
        if (this.system) {
            return true;
        }
        return !this.anonymous || privileges.length == 1 && privileges[0].equals(this.privilegeRegistry.getPrivilege("{http://www.jcp.org/jcr/1.0}read"));
    }

    public Privilege[] getPrivileges(String absPath) throws PathNotFoundException, RepositoryException {
        this.checkInitialized();
        this.checkValidNodePath(absPath);
        Privilege priv = this.anonymous ? this.privilegeRegistry.getPrivilege("{http://www.jcp.org/jcr/1.0}read") : (this.system ? this.privilegeRegistry.getPrivilege("{http://www.jcp.org/jcr/1.0}all") : this.privilegeRegistry.getPrivilege("{http://www.jcp.org/jcr/1.0}all"));
        return new Privilege[]{priv};
    }

    public AccessControlPolicy[] getEffectivePolicies(String absPath) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        this.checkInitialized();
        this.checkPermission(absPath, 32);
        return new AccessControlPolicy[]{POLICY};
    }

    protected void checkInitialized() throws IllegalStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
    }

    protected void checkPermission(String absPath, int permission) throws AccessDeniedException, PathNotFoundException, RepositoryException {
        this.checkValidNodePath(absPath);
        if (this.anonymous && permission != 1) {
            throw new AccessDeniedException("Anonymous may only READ.");
        }
    }

    protected PrivilegeRegistry getPrivilegeRegistry() throws RepositoryException {
        this.checkInitialized();
        return this.privilegeRegistry;
    }

    protected void checkValidNodePath(String absPath) throws PathNotFoundException, RepositoryException {
        Path path = this.resolver.getQPath(absPath);
        if (!path.isAbsolute()) {
            throw new RepositoryException("Absolute path expected. Found: " + absPath);
        }
        if (this.hierMgr.resolveNodePath(path) == null) {
            throw new PathNotFoundException(absPath);
        }
    }
}

