/*
 * Decompiled with CFR 0.152.
 */
package yarfraw.utils.extension;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.georss.georss._10.GeoRssExtension;
import org.georss.georss._10.SimplePositionType;
import org.georss.georss._10.Where;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import yarfraw.core.datamodel.FeedFormat;
import yarfraw.core.datamodel.YarfrawException;
import yarfraw.generated.admin.elements.AdminExtension;
import yarfraw.generated.admin.elements.AdminType;
import yarfraw.generated.atom03.ext.elements.Atom03Extension;
import yarfraw.generated.atom03.ext.elements.ContentType;
import yarfraw.generated.blogger.elements.BloggerExtension;
import yarfraw.generated.feedburner.elements.FeedburnerExtension;
import yarfraw.generated.googlebase.elements.CurrencyCodeEnumeration;
import yarfraw.generated.googlebase.elements.DateTimeRangeType;
import yarfraw.generated.googlebase.elements.GenderEnumeration;
import yarfraw.generated.googlebase.elements.GoogleBaseExtension;
import yarfraw.generated.googlebase.elements.ObjectFactory;
import yarfraw.generated.googlebase.elements.PaymentMethodEnumeration;
import yarfraw.generated.googlebase.elements.PriceTypeEnumeration;
import yarfraw.generated.googlebase.elements.ShippingType;
import yarfraw.generated.itunes.elements.ItunesCategoryType;
import yarfraw.generated.itunes.elements.ItunesExtension;
import yarfraw.generated.itunes.elements.ItunesImageType;
import yarfraw.generated.itunes.elements.ItunesOwnerType;
import yarfraw.generated.mrss.elements.MrssCategoryType;
import yarfraw.generated.mrss.elements.MrssContentType;
import yarfraw.generated.mrss.elements.MrssCopyrightType;
import yarfraw.generated.mrss.elements.MrssCreditType;
import yarfraw.generated.mrss.elements.MrssDescriptionType;
import yarfraw.generated.mrss.elements.MrssExtension;
import yarfraw.generated.mrss.elements.MrssGroupType;
import yarfraw.generated.mrss.elements.MrssHashType;
import yarfraw.generated.mrss.elements.MrssPlayerType;
import yarfraw.generated.mrss.elements.MrssRatingType;
import yarfraw.generated.mrss.elements.MrssRestrictionType;
import yarfraw.generated.mrss.elements.MrssTextType;
import yarfraw.generated.mrss.elements.MrssThumbnailType;
import yarfraw.generated.mrss.elements.MrssTitleType;
import yarfraw.generated.rss10.elements.DcType;
import yarfraw.generated.rss10.elements.DublinCoreExtension;
import yarfraw.generated.rss10.elements.SyndicationExtension;
import yarfraw.generated.rss10.elements.UpdatePeriodEnum;
import yarfraw.generated.slash.elements.SlashExtension;
import yarfraw.generated.wfw.elements.WellFormedWebExtension;
import yarfraw.io.parser.ExtensionElementQname;
import yarfraw.utils.JAXBUtils;
import yarfraw.utils.XMLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionUtils {
    private static final String HTTP_BASE_GOOGLE_COM_CNS_1_0 = "http://base.google.com/ns/1.0";
    private static final String ITUNES_JAXB_CONTEXT = "yarfraw.generated.itunes.elements";
    private static final String MRSS_JAXB_CONTEXT = "yarfraw.generated.mrss.elements";
    private static final String GOOGLEBASE_JAXB_CONTEXT = "yarfraw.generated.googlebase.elements";
    private static final String DUBLINCORE_JAXB_CONTEXT = "yarfraw.generated.rss10.elements";
    private static final String GEORSS_JAXB_CONTEXT = "org.georss.georss._10";
    private static final String WFW_JAXB_CONTEXT = "yarfraw.generated.wfw.elements";
    private static final String SY_JAXB_CONTEXT = "yarfraw.generated.rss10.elements";
    private static final String BLOGGER_JAXB_CONTEXT = "yarfraw.generated.blogger.elements";
    private static final String ADMIN_JAXB_CONTEXT = "yarfraw.generated.admin.elements";
    private static final String FEEDBURNER_JAXB_CONTEXT = "yarfraw.generated.feedburner.elements";
    private static final String SLASH_JAXB_CONTEXT = "yarfraw.generated.slash.elements";
    private static final String ATOM03_JAXB_CONTEXT = "yarfraw.generated.atom03.ext.elements";
    private static final ObjectFactory GOOGLEBASE_FACTORY = new ObjectFactory();
    private static final Log LOG = LogFactory.getLog(ExtensionUtils.class);
    private static JAXBContext DC_CTX = null;
    private static JAXBContext GEORSS_CTX = null;
    private static JAXBContext GOOGLEBASE_CTX = null;
    private static JAXBContext ITUNES_CTX = null;
    private static JAXBContext MRSS_CTX = null;
    private static JAXBContext SY_CTX = null;
    private static JAXBContext WFW_CTX = null;
    private static JAXBContext BLOGGER_CTX = null;
    private static JAXBContext ADMIN_CTX = null;
    private static JAXBContext FEEDBURNER_CTX = null;
    private static JAXBContext SLASH_CTX = null;
    private static JAXBContext ATOM03_CTX = null;

    private ExtensionUtils() {
    }

    public static Atom03Extension extractAtom03Extension(List<Element> otherElements) throws YarfrawException {
        Atom03Extension ret = new Atom03Extension();
        try {
            if (otherElements != null) {
                Unmarshaller u = ExtensionUtils.getContext(ContextEnum.ATOM03).createUnmarshaller();
                Iterator<Element> it = otherElements.iterator();
                while (it.hasNext()) {
                    ContentType c;
                    Element e = it.next();
                    if (e == null) continue;
                    QName name = new QName(e.getNamespaceURI(), e.getLocalName());
                    if (XMLUtils.same(name, ExtensionElementQname.ATOM03_CONTENT_QNAME)) {
                        c = (ContentType)((JAXBElement)u.unmarshal((Node)e)).getValue();
                        ret.getContent().add(c);
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.ATOM03_INFO_QNAME)) {
                        c = (ContentType)((JAXBElement)u.unmarshal((Node)e)).getValue();
                        ret.setInfo(c);
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.ATOM03_ISSUED_QNAME)) {
                        ret.setIssued(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.ATOM03_SUMMARY_QNAME)) {
                        c = (ContentType)((JAXBElement)u.unmarshal((Node)e)).getValue();
                        ret.setSummary(c);
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.ATOM03_TITLE_QNAME)) {
                        c = (ContentType)((JAXBElement)u.unmarshal((Node)e)).getValue();
                        ret.setTitle(c);
                        it.remove();
                        continue;
                    }
                    if (!XMLUtils.same(name, ExtensionElementQname.ATOM03_TAGLINE_QNAME)) continue;
                    c = (ContentType)((JAXBElement)u.unmarshal((Node)e)).getValue();
                    ret.setTagline(c);
                    it.remove();
                }
            }
        }
        catch (JAXBException e) {
            throw new YarfrawException("unable to unmarshal element", e);
        }
        return ret;
    }

    public static ItunesExtension extractItunesExtension(List<Element> otherElements) throws YarfrawException {
        ItunesExtension ret = new ItunesExtension();
        try {
            if (otherElements != null) {
                Unmarshaller u = ExtensionUtils.getContext(ContextEnum.ITUNES).createUnmarshaller();
                Iterator<Element> it = otherElements.iterator();
                while (it.hasNext()) {
                    Element e = it.next();
                    if (e == null) continue;
                    QName name = new QName(e.getNamespaceURI(), e.getLocalName());
                    if (XMLUtils.same(name, ExtensionElementQname.ITUNES_AUTHOR_QNAME)) {
                        ret.setAuthor(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.ITUNES_BLOCK_QNAME)) {
                        ret.setBlock(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.ITUNES_CATEGORY_QNAME)) {
                        ItunesCategoryType cat = (ItunesCategoryType)((JAXBElement)u.unmarshal((Node)e)).getValue();
                        ret.getCategory().add(cat);
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.ITUNES_DURATION_QNAME)) {
                        ret.setDuration(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.ITUNES_EXPLICIT_QNAME)) {
                        ret.setExplicit(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.ITUNES_IMAGE_QNAME)) {
                        ItunesImageType img = (ItunesImageType)((JAXBElement)u.unmarshal((Node)e)).getValue();
                        ret.setImage(img);
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.ITUNES_KEYWORDS_QNAME)) {
                        ret.setKeywords(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.ITUNES_OWNER_QNAME)) {
                        ItunesOwnerType owner = (ItunesOwnerType)((JAXBElement)u.unmarshal((Node)e)).getValue();
                        ret.setOwner(owner);
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.ITUNES_SUBTITLE_QNAME)) {
                        ret.setSubtitle(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.ITUNES_SUMMARY_QNAME)) {
                        ret.setSummary(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (!XMLUtils.same(name, ExtensionElementQname.ITUNES_NewFeedUrl_QNAME)) continue;
                    ret.setNewFeedUrl(e.getTextContent());
                    it.remove();
                }
            }
        }
        catch (JAXBException e) {
            throw new YarfrawException("unable to unmarshal element", e);
        }
        return ret;
    }

    public static DublinCoreExtension extractDublinCoreExtension(List<Element> otherElements) throws YarfrawException {
        DublinCoreExtension ret = new DublinCoreExtension();
        try {
            if (otherElements != null) {
                Iterator<Element> it = otherElements.iterator();
                Unmarshaller u = ExtensionUtils.getContext(ContextEnum.SY).createUnmarshaller();
                while (it.hasNext()) {
                    Element e = it.next();
                    if (e == null) continue;
                    QName name = new QName(e.getNamespaceURI(), e.getLocalName());
                    if (XMLUtils.same(name, ExtensionElementQname.DC_Contributor_QNAME)) {
                        ret.getContributor().add((DcType)((JAXBElement)u.unmarshal((Node)e)).getValue());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.DC_Coverage_QNAME)) {
                        ret.setCoverage((DcType)((JAXBElement)u.unmarshal((Node)e)).getValue());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.DC_Creator_QNAME)) {
                        ret.setCreator((DcType)((JAXBElement)u.unmarshal((Node)e)).getValue());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.DC_Date_QNAME)) {
                        ret.setDate((DcType)((JAXBElement)u.unmarshal((Node)e)).getValue());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.DC_Description_QNAME)) {
                        ret.setDescription((DcType)((JAXBElement)u.unmarshal((Node)e)).getValue());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.DC_Format_QNAME)) {
                        ret.setFormat((DcType)((JAXBElement)u.unmarshal((Node)e)).getValue());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.DC_Identifier_QNAME)) {
                        ret.setIdentifier((DcType)((JAXBElement)u.unmarshal((Node)e)).getValue());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.DC_Language_QNAME)) {
                        ret.setLanguage((DcType)((JAXBElement)u.unmarshal((Node)e)).getValue());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.DC_Publisher_QNAME)) {
                        ret.setPublisher((DcType)((JAXBElement)u.unmarshal((Node)e)).getValue());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.DC_Relation_QNAME)) {
                        ret.setRelation((DcType)((JAXBElement)u.unmarshal((Node)e)).getValue());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.DC_Rights_QNAME)) {
                        ret.setRights((DcType)((JAXBElement)u.unmarshal((Node)e)).getValue());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.DC_Source_QNAME)) {
                        ret.setSource((DcType)((JAXBElement)u.unmarshal((Node)e)).getValue());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.DC_Subject_QNAME)) {
                        ret.getSubject().add((DcType)((JAXBElement)u.unmarshal((Node)e)).getValue());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.DC_Title_QNAME)) {
                        ret.setTitle((DcType)((JAXBElement)u.unmarshal((Node)e)).getValue());
                        it.remove();
                        continue;
                    }
                    if (!XMLUtils.same(name, ExtensionElementQname.DC_Type_QNAME)) continue;
                    ret.setType((DcType)((JAXBElement)u.unmarshal((Node)e)).getValue());
                    it.remove();
                }
            }
        }
        catch (JAXBException e) {
            throw new YarfrawException("unable to unmarshal element", e);
        }
        return ret;
    }

    public static WellFormedWebExtension extractWellFormedWebExtension(List<Element> otherElements) throws YarfrawException {
        WellFormedWebExtension ret = new WellFormedWebExtension();
        if (otherElements != null) {
            Iterator<Element> it = otherElements.iterator();
            while (it.hasNext()) {
                Element e = it.next();
                if (e == null) continue;
                QName name = new QName(e.getNamespaceURI(), e.getLocalName());
                if (XMLUtils.same(name, ExtensionElementQname.WFW_Comment_QNAME)) {
                    ret.setComment(e.getTextContent());
                    it.remove();
                    continue;
                }
                if (!XMLUtils.same(name, ExtensionElementQname.WFW_CommentRss_QNAME)) continue;
                ret.setCommentRss(e.getTextContent());
                it.remove();
            }
        }
        return ret;
    }

    public static AdminExtension extractAdminExtension(List<Element> otherElements) throws YarfrawException {
        AdminExtension ret = new AdminExtension();
        try {
            if (otherElements != null) {
                Iterator<Element> it = otherElements.iterator();
                Unmarshaller u = ExtensionUtils.getContext(ContextEnum.ADMIN).createUnmarshaller();
                while (it.hasNext()) {
                    Element e = it.next();
                    if (e == null) continue;
                    QName name = new QName(e.getNamespaceURI(), e.getLocalName());
                    if (XMLUtils.same(name, ExtensionElementQname.ADMIN_ErrorReportsTo_QNAME)) {
                        if (e.getTextContent() == null) continue;
                        ret.setErrorReportsTo((AdminType)((JAXBElement)u.unmarshal((Node)e)).getValue());
                        continue;
                    }
                    if (!XMLUtils.same(name, ExtensionElementQname.ADMIN_GeneratorAgent_QNAME) || e.getTextContent() == null) continue;
                    ret.setGeneratorAgent((AdminType)((JAXBElement)u.unmarshal((Node)e)).getValue());
                }
            }
        }
        catch (JAXBException e) {
            throw new YarfrawException("unable to unmarshal element", e);
        }
        return ret;
    }

    public static FeedburnerExtension extractFeedburnerExtension(List<Element> otherElements) throws YarfrawException {
        FeedburnerExtension ret = new FeedburnerExtension();
        if (otherElements != null) {
            for (Element e : otherElements) {
                if (e == null) continue;
                QName name = new QName(e.getNamespaceURI(), e.getLocalName());
                if (XMLUtils.same(name, ExtensionElementQname.FEEDBURNER_BrowserFriendly_QNAME)) {
                    ret.setBrowserFriendly(e.getTextContent());
                    continue;
                }
                if (!XMLUtils.same(name, ExtensionElementQname.FEEDBURNER_OrigLink_QNAME)) continue;
                ret.setOrigLink(e.getTextContent());
            }
        }
        return ret;
    }

    public static SlashExtension extractSlashExtension(List<Element> otherElements) throws YarfrawException {
        SlashExtension ret = new SlashExtension();
        try {
            if (otherElements != null) {
                Iterator<Element> it = otherElements.iterator();
                Unmarshaller u = ExtensionUtils.getContext(ContextEnum.SLASH).createUnmarshaller();
                while (it.hasNext()) {
                    Element e = it.next();
                    if (e == null) continue;
                    QName name = new QName(e.getNamespaceURI(), e.getLocalName());
                    if (XMLUtils.same(name, ExtensionElementQname.SLASH_Comments_QNAME)) {
                        ret.setComments((BigInteger)((JAXBElement)u.unmarshal((Node)e)).getValue());
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.SLASH_Department_QNAME)) {
                        ret.setDepartment(e.getTextContent());
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.SLASH_HitParade_QNAME)) {
                        ret.setHitParade(e.getTextContent());
                        continue;
                    }
                    if (!XMLUtils.same(name, ExtensionElementQname.SLASH_Section_QNAME)) continue;
                    ret.setSection(e.getTextContent());
                }
            }
        }
        catch (JAXBException e) {
            throw new YarfrawException("unable to unmarshal element", e);
        }
        return ret;
    }

    public static BloggerExtension extractBloggerExtension(List<Element> otherElements) throws YarfrawException {
        BloggerExtension ret = new BloggerExtension();
        if (otherElements != null) {
            for (Element e : otherElements) {
                if (e == null) continue;
                QName name = new QName(e.getNamespaceURI(), e.getLocalName());
                if (XMLUtils.same(name, ExtensionElementQname.BLOGGER_ConvertLineBreaks_QNAME)) {
                    if (e.getTextContent() == null) continue;
                    ret.setConvertLineBreaks(Boolean.valueOf(e.getTextContent()));
                    continue;
                }
                if (!XMLUtils.same(name, ExtensionElementQname.BLOGGER_Draft_QNAME) || e.getTextContent() == null) continue;
                ret.setDraft(Boolean.valueOf(e.getTextContent()));
            }
        }
        return ret;
    }

    public static SyndicationExtension extractSyndicationExtension(List<Element> otherElements) throws YarfrawException {
        SyndicationExtension ret = new SyndicationExtension();
        try {
            if (otherElements != null) {
                Iterator<Element> it = otherElements.iterator();
                Unmarshaller u = ExtensionUtils.getContext(ContextEnum.SY).createUnmarshaller();
                while (it.hasNext()) {
                    Element e = it.next();
                    if (e == null) continue;
                    QName name = new QName(e.getNamespaceURI(), e.getLocalName());
                    if (XMLUtils.same(name, ExtensionElementQname.SY_UpdateBase_QNAME)) {
                        ret.setUpdateBase(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.SY_UpdateFrequency_QNAME)) {
                        ret.setUpdateFrequency((BigInteger)((JAXBElement)u.unmarshal((Node)e)).getValue());
                        it.remove();
                        continue;
                    }
                    if (!XMLUtils.same(name, ExtensionElementQname.SY_UpdatePeriod_QNAME)) continue;
                    ret.setUpdatePeriod((UpdatePeriodEnum)((Object)((JAXBElement)u.unmarshal((Node)e)).getValue()));
                    it.remove();
                }
            }
        }
        catch (Exception e) {
            throw new YarfrawException("unable to unmarshal element", e);
        }
        return ret;
    }

    public static GoogleBaseExtension extractGoogleBaseExtension(List<Element> otherElements) throws YarfrawException {
        GoogleBaseExtension ret = new GoogleBaseExtension();
        try {
            if (otherElements != null) {
                Unmarshaller u = JAXBContext.newInstance((String)GOOGLEBASE_JAXB_CONTEXT).createUnmarshaller();
                Iterator<Element> it = otherElements.iterator();
                while (it.hasNext()) {
                    Object d;
                    Element e = it.next();
                    if (e == null) continue;
                    QName name = new QName(e.getNamespaceURI(), e.getLocalName());
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_Actor_QNAME)) {
                        ret.getActor().add(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_Agent_QNAME)) {
                        ret.getAgent().add(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_Age_QNAME)) {
                        ret.setAge(e.getTextContent() == null ? null : Short.valueOf(e.getTextContent()));
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_ApparelType_QNAME)) {
                        ret.setApparelType(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_Area_QNAME)) {
                        ret.setArea(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_Artist_QNAME)) {
                        ret.getArtist().add(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_Author_QNAME)) {
                        ret.getAuthor().add(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_Bathrooms_QNAME)) {
                        ret.setBathrooms(e.getTextContent() == null ? null : new BigDecimal(e.getTextContent()));
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_Bedrooms_QNAME)) {
                        ret.setBedrooms(e.getTextContent() == null ? null : Short.valueOf(e.getTextContent()));
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_Brand_QNAME)) {
                        ret.setBrand(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_Color_QNAME)) {
                        ret.getColor().add(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_Condition_QNAME)) {
                        ret.setCondition(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_CourseDateRange_QNAME)) {
                        d = (DateTimeRangeType)((JAXBElement)u.unmarshal((Node)e)).getValue();
                        ret.setCourseDateRange((DateTimeRangeType)d);
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_CourseNumber_QNAME)) {
                        ret.setCourseNumber(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_CourseTimes_QNAME)) {
                        ret.setCourseTimes(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_Currency_QNAME)) {
                        ret.setCurrency((CurrencyCodeEnumeration)((Object)((JAXBElement)u.unmarshal((Node)e)).getValue()));
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_DeliveryNotes_QNAME)) {
                        ret.setDeliveryNotes(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_DeliveryRadius_QNAME)) {
                        ret.setDeliveryRadius(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_DevelopmentStatus_QNAME)) {
                        ret.setDevelopmentStatus(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_Education_QNAME)) {
                        ret.getEducation().add(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_Employer_QNAME)) {
                        ret.getEmployer().add(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_Ethnicity_QNAME)) {
                        ret.getEthnicity().add(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_EventDateRange_QNAME)) {
                        d = (DateTimeRangeType)((JAXBElement)u.unmarshal((Node)e)).getValue();
                        ret.setEventDateRange((DateTimeRangeType)d);
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_ExpirationDate_QNAME)) {
                        d = (XMLGregorianCalendar)((JAXBElement)u.unmarshal((Node)e)).getValue();
                        ret.setExpirationDate((XMLGregorianCalendar)d);
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_ExpirationDateTime_QNAME)) {
                        d = (XMLGregorianCalendar)((JAXBElement)u.unmarshal((Node)e)).getValue();
                        ret.setExpirationDateTime((XMLGregorianCalendar)d);
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_Format_QNAME)) {
                        ret.getFormat().add(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_ForSale_QNAME)) {
                        ret.setForSale((Boolean)((JAXBElement)u.unmarshal((Node)e)).getValue());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_FromLocation_QNAME)) {
                        ret.setFromLocation(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_Gender_QNAME)) {
                        ret.setGender((GenderEnumeration)((Object)((JAXBElement)u.unmarshal((Node)e)).getValue()));
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_HoaDues_QNAME)) {
                        ret.setHoaDues((BigDecimal)((JAXBElement)u.unmarshal((Node)e)).getValue());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_Id_QNAME)) {
                        ret.setId(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_ImageLink_QNAME)) {
                        ret.getImageLink().add(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_ImmigrationStatus_QNAME)) {
                        ret.setImmigrationStatus(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_InterestedIn_QNAME)) {
                        ret.setInterestedIn(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_Isbn_QNAME)) {
                        ret.setIsbn(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_JobFunction_QNAME)) {
                        ret.getJobFunction().add(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_JobIndustry_QNAME)) {
                        ret.getJobIndustry().add(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_JobType_QNAME)) {
                        ret.getJobType().add(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_Label_QNAME)) {
                        ret.getLabel().add(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_License_QNAME)) {
                        ret.getLicense().add(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_ListingType_QNAME)) {
                        ret.getListingType().add(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_Location_QNAME)) {
                        ret.setLocation(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_Make_QNAME)) {
                        ret.setMake(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_Manufacturer_QNAME)) {
                        ret.setManufacturer(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_ManufacturerId_QNAME)) {
                        ret.setManufacturerId(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_MaritalStatus_QNAME)) {
                        ret.setMaritalStatus(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_Megapixels_QNAME)) {
                        ret.setMegapixels(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_Memory_QNAME)) {
                        ret.setMemory(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_Mileage_QNAME)) {
                        ret.setMileage(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_Model_QNAME)) {
                        ret.setModel(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_ModelNumber_QNAME)) {
                        ret.setModelNumber(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_NameOfItemReviewed_QNAME)) {
                        ret.setNameOfItemReviewed(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_NewsSource_QNAME)) {
                        ret.setNewsSource(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_Occupation_QNAME)) {
                        ret.setOccupation(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_OperatingSystems_QNAME)) {
                        ret.setOperatingSystems(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_Pages_QNAME)) {
                        ret.setPages((BigInteger)((JAXBElement)u.unmarshal((Node)e)).getValue());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_PaymentAccepted_QNAME)) {
                        ret.getPaymentAccepted().add((PaymentMethodEnumeration)((Object)((JAXBElement)u.unmarshal((Node)e)).getValue()));
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_PaymentNotes_QNAME)) {
                        ret.setPaymentNotes(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_Pickup_QNAME)) {
                        ret.setPickup((Boolean)((JAXBElement)u.unmarshal((Node)e)).getValue());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_Price_QNAME)) {
                        ret.setPrice(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_PriceType_QNAME)) {
                        ret.setPriceType((PriceTypeEnumeration)((Object)((JAXBElement)u.unmarshal((Node)e)).getValue()));
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_ProcessorSpeed_QNAME)) {
                        ret.setProcessorSpeed(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_ProductType_QNAME)) {
                        ret.getProductType().add(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_ProgrammingLanguage_QNAME)) {
                        ret.getProgrammingLanguage().add(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_PropertyType_QNAME)) {
                        ret.getPropertyType().add(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_PublicationName_QNAME)) {
                        ret.setPublicationName(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_PublicationVolume_QNAME)) {
                        ret.setPublicationVolume(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_PublishDate_QNAME)) {
                        ret.setPublishDate((XMLGregorianCalendar)((JAXBElement)u.unmarshal((Node)e)).getValue());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_Quantity_QNAME)) {
                        ret.setQuantity((BigInteger)((JAXBElement)u.unmarshal((Node)e)).getValue());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_Rating_QNAME)) {
                        ret.setRating(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_RatingType_QNAME)) {
                        ret.setRatingType(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_RelatedLink_QNAME)) {
                        ret.getRelatedLink().add(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_ReviewerType_QNAME)) {
                        ret.setReviewerType(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_ReviewType_QNAME)) {
                        ret.setReviewType(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_Salary_QNAME)) {
                        ret.setSalary((BigDecimal)((JAXBElement)u.unmarshal((Node)e)).getValue());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_SalaryType_QNAME)) {
                        ret.setSalaryType((PriceTypeEnumeration)((Object)((JAXBElement)u.unmarshal((Node)e)).getValue()));
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_SchoolDistrict_QNAME)) {
                        ret.setSchoolDistrict(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_ServiceType_QNAME)) {
                        ret.setServiceType(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_SexualOrientation_QNAME)) {
                        ret.setSexualOrientation(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_Shipping_QNAME)) {
                        ret.getShipping().add((ShippingType)((JAXBElement)u.unmarshal((Node)e)).getValue());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_Size_QNAME)) {
                        ret.getSize().add(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_SquareFootage_QNAME)) {
                        ret.getSquareFootage().add(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_Subject_QNAME)) {
                        ret.getSubject().add(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_SubjectArea_QNAME)) {
                        ret.getSubjectArea().add(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_TaxPercent_QNAME)) {
                        ret.setTaxPercent((BigDecimal)((JAXBElement)u.unmarshal((Node)e)).getValue());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_TaxRegion_QNAME)) {
                        ret.setTaxRegion(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_ToLocation_QNAME)) {
                        ret.setToLocation(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_TravelDateRange_QNAME)) {
                        d = (DateTimeRangeType)((JAXBElement)u.unmarshal((Node)e)).getValue();
                        ret.setTravelDateRange((DateTimeRangeType)d);
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_University_QNAME)) {
                        ret.setUniversity(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_Upc_QNAME)) {
                        ret.setUpc(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_UrlOfItemReviewed_QNAME)) {
                        ret.setUrlOfItemReviewed(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_VehicleType_QNAME)) {
                        ret.getVehicleType().add(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_Vin_QNAME)) {
                        ret.setVin(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_Weight_QNAME)) {
                        ret.setWeight(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GOOGLEBASE_Year_QNAME)) {
                        ret.setYear((XMLGregorianCalendar)((JAXBElement)u.unmarshal((Node)e)).getValue());
                        it.remove();
                        continue;
                    }
                    if (!HTTP_BASE_GOOGLE_COM_CNS_1_0.equals(e.getNamespaceURI())) continue;
                    ret.getAny().add(e);
                    it.remove();
                }
            }
        }
        catch (JAXBException e) {
            throw new YarfrawException("unable to unmarshal element", e);
        }
        return ret;
    }

    public static GeoRssExtension extractGeoRssExtension(List<Element> otherElements) throws YarfrawException {
        GeoRssExtension ret = new GeoRssExtension();
        try {
            if (otherElements != null) {
                Unmarshaller u = JAXBContext.newInstance((String)GEORSS_JAXB_CONTEXT).createUnmarshaller();
                Iterator<Element> it = otherElements.iterator();
                while (it.hasNext()) {
                    SimplePositionType pos;
                    Element e = it.next();
                    if (e == null) continue;
                    QName name = new QName(e.getNamespaceURI(), e.getLocalName());
                    if (XMLUtils.same(name, ExtensionElementQname.GEORSS_WHERE_QNAME)) {
                        Where copy = (Where)((JAXBElement)u.unmarshal((Node)e)).getValue();
                        ret.setWhere(copy);
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GEORSS_BOX_QNAME)) {
                        pos = (SimplePositionType)((JAXBElement)u.unmarshal((Node)e)).getValue();
                        ret.setBox(pos);
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GEORSS_LINE_QNAME)) {
                        pos = (SimplePositionType)((JAXBElement)u.unmarshal((Node)e)).getValue();
                        ret.setLine(pos);
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.GEORSS_POINT_QNAME)) {
                        pos = (SimplePositionType)((JAXBElement)u.unmarshal((Node)e)).getValue();
                        ret.setPoint(pos);
                        it.remove();
                        continue;
                    }
                    if (!XMLUtils.same(name, ExtensionElementQname.GEORSS_POLYGON_QNAME)) continue;
                    pos = (SimplePositionType)((JAXBElement)u.unmarshal((Node)e)).getValue();
                    ret.setPolygon(pos);
                    it.remove();
                }
            }
        }
        catch (JAXBException e) {
            throw new YarfrawException("unable to unmarshal element", e);
        }
        return ret;
    }

    public static MrssExtension extractMrssExtension(List<Element> otherElements) throws YarfrawException {
        MrssExtension ret = new MrssExtension();
        try {
            if (otherElements != null) {
                Unmarshaller u = JAXBContext.newInstance((String)MRSS_JAXB_CONTEXT).createUnmarshaller();
                Iterator<Element> it = otherElements.iterator();
                while (it.hasNext()) {
                    Object copy;
                    Element e = it.next();
                    if (e == null) continue;
                    QName name = new QName(e.getNamespaceURI(), e.getLocalName());
                    if (XMLUtils.same(name, ExtensionElementQname.MRSS_CATEGORY_QNAME)) {
                        MrssCategoryType cat = (MrssCategoryType)((JAXBElement)u.unmarshal((Node)e)).getValue();
                        ret.getCategory().add(cat);
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.MRSS_CONTENT_QNAME)) {
                        MrssContentType content = (MrssContentType)((JAXBElement)u.unmarshal((Node)e)).getValue();
                        ret.getContent().add(content);
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.MRSS_COPYRIGHT_QNAME)) {
                        copy = (MrssCopyrightType)((JAXBElement)u.unmarshal((Node)e)).getValue();
                        ret.setCopyright((MrssCopyrightType)copy);
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.MRSS_CREDIT_QNAME)) {
                        copy = (MrssCreditType)((JAXBElement)u.unmarshal((Node)e)).getValue();
                        ret.getCredit().add((MrssCreditType)copy);
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.MRSS_DESCRIPTION_QNAME)) {
                        copy = (MrssDescriptionType)((JAXBElement)u.unmarshal((Node)e)).getValue();
                        ret.setDescription((MrssDescriptionType)copy);
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.MRSS_GROUP_QNAME)) {
                        copy = (MrssGroupType)((JAXBElement)u.unmarshal((Node)e)).getValue();
                        ret.getGroup().add((MrssGroupType)copy);
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.MRSS_HASH_QNAME)) {
                        copy = (MrssHashType)((JAXBElement)u.unmarshal((Node)e)).getValue();
                        ret.setHash((MrssHashType)copy);
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.MRSS_KEYWORDS_QNAME)) {
                        ret.setKeywords(e.getTextContent());
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.MRSS_PLAYER_QNAME)) {
                        copy = (MrssPlayerType)((JAXBElement)u.unmarshal((Node)e)).getValue();
                        ret.setPlayer((MrssPlayerType)copy);
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.MRSS_RATING_QNAME)) {
                        copy = (MrssRatingType)((JAXBElement)u.unmarshal((Node)e)).getValue();
                        ret.setRating((MrssRatingType)copy);
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.MRSS_RESTRICTION_QNAME)) {
                        copy = (MrssRestrictionType)((JAXBElement)u.unmarshal((Node)e)).getValue();
                        ret.setRestriction((MrssRestrictionType)copy);
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.MRSS_TEXT_QNAME)) {
                        copy = (MrssTextType)((JAXBElement)u.unmarshal((Node)e)).getValue();
                        ret.setText((MrssTextType)copy);
                        it.remove();
                        continue;
                    }
                    if (XMLUtils.same(name, ExtensionElementQname.MRSS_THUMBNAIL_QNAME)) {
                        copy = (MrssThumbnailType)((JAXBElement)u.unmarshal((Node)e)).getValue();
                        ret.setThumbnail((MrssThumbnailType)copy);
                        it.remove();
                        continue;
                    }
                    if (!XMLUtils.same(name, ExtensionElementQname.MRSS_TITLE_QNAME)) continue;
                    copy = (MrssTitleType)((JAXBElement)u.unmarshal((Node)e)).getValue();
                    ret.setTitle((MrssTitleType)copy);
                    it.remove();
                }
            }
        }
        catch (JAXBException e) {
            throw new YarfrawException("unable to unmarshal element", e);
        }
        return ret;
    }

    public static List<Element> toItunesElements(ItunesExtension extensionObject) throws YarfrawException {
        return ExtensionUtils.toElements(extensionObject, ContextEnum.ITUNES);
    }

    public static List<Element> toGeoRssElements(GeoRssExtension extensionObject) throws YarfrawException {
        return ExtensionUtils.toElements(extensionObject, ContextEnum.GEORSS);
    }

    public static List<Element> toGoogleBaseElements(GoogleBaseExtension extensionObject) throws YarfrawException {
        JAXBElement<GoogleBaseExtension> jaxb = GOOGLEBASE_FACTORY.createGoogleBaseExtension(extensionObject);
        return ExtensionUtils.toElements(jaxb, ContextEnum.GOOGLEBASE);
    }

    public static List<Element> toMrssElements(MrssExtension extensionObject) throws YarfrawException {
        return ExtensionUtils.toElements(extensionObject, ContextEnum.MRSS);
    }

    public static List<Element> toWellFormedWebElements(WellFormedWebExtension extensionObject) throws YarfrawException {
        return ExtensionUtils.toElements(extensionObject, ContextEnum.WFW);
    }

    public static List<Element> toDublinCoreElements(DublinCoreExtension extensionObject) throws YarfrawException {
        return ExtensionUtils.toElements(extensionObject, ContextEnum.DC);
    }

    public static List<Element> toSyndicationElements(SyndicationExtension extensionObject) throws YarfrawException {
        return ExtensionUtils.toElements(extensionObject, ContextEnum.SY);
    }

    public static List<Element> toBloggerAtomElements(BloggerExtension extensionObject) throws YarfrawException {
        return ExtensionUtils.toElements(extensionObject, ContextEnum.BLOGGER);
    }

    public static List<Element> toAdminAtomElements(AdminExtension extensionObject) throws YarfrawException {
        return ExtensionUtils.toElements(extensionObject, ContextEnum.ADMIN);
    }

    public static List<Element> toFeedburnerElements(FeedburnerExtension extensionObject) throws YarfrawException {
        return ExtensionUtils.toElements(extensionObject, ContextEnum.FEEDBURNER);
    }

    public static List<Element> toSlahsElements(SlashExtension extensionObject) throws YarfrawException {
        return ExtensionUtils.toElements(extensionObject, ContextEnum.SLASH);
    }

    private static synchronized JAXBContext getContext(ContextEnum ctxEnum) throws JAXBException {
        if (ctxEnum == ContextEnum.DC) {
            if (DC_CTX == null) {
                DC_CTX = JAXBContext.newInstance((String)"yarfraw.generated.rss10.elements");
            }
            return DC_CTX;
        }
        if (ctxEnum == ContextEnum.ATOM03) {
            if (ATOM03_CTX == null) {
                ATOM03_CTX = JAXBContext.newInstance((String)ATOM03_JAXB_CONTEXT);
            }
            return ATOM03_CTX;
        }
        if (ctxEnum == ContextEnum.ADMIN) {
            if (ADMIN_CTX == null) {
                ADMIN_CTX = JAXBContext.newInstance((String)ADMIN_JAXB_CONTEXT);
            }
            return ADMIN_CTX;
        }
        if (ctxEnum == ContextEnum.BLOGGER) {
            if (BLOGGER_CTX == null) {
                BLOGGER_CTX = JAXBContext.newInstance((String)BLOGGER_JAXB_CONTEXT);
            }
            return BLOGGER_CTX;
        }
        if (ctxEnum == ContextEnum.FEEDBURNER) {
            if (FEEDBURNER_CTX == null) {
                FEEDBURNER_CTX = JAXBContext.newInstance((String)FEEDBURNER_JAXB_CONTEXT);
            }
            return FEEDBURNER_CTX;
        }
        if (ctxEnum == ContextEnum.SLASH) {
            if (SLASH_CTX == null) {
                SLASH_CTX = JAXBContext.newInstance((String)SLASH_JAXB_CONTEXT);
            }
            return SLASH_CTX;
        }
        if (ctxEnum == ContextEnum.GEORSS) {
            if (GEORSS_CTX == null) {
                GEORSS_CTX = JAXBContext.newInstance((String)GEORSS_JAXB_CONTEXT);
            }
            return GEORSS_CTX;
        }
        if (ctxEnum == ContextEnum.GOOGLEBASE) {
            if (GOOGLEBASE_CTX == null) {
                GOOGLEBASE_CTX = JAXBContext.newInstance((String)GOOGLEBASE_JAXB_CONTEXT);
            }
            return GOOGLEBASE_CTX;
        }
        if (ctxEnum == ContextEnum.ITUNES) {
            if (ITUNES_CTX == null) {
                ITUNES_CTX = JAXBContext.newInstance((String)ITUNES_JAXB_CONTEXT);
            }
            return ITUNES_CTX;
        }
        if (ctxEnum == ContextEnum.MRSS) {
            if (MRSS_CTX == null) {
                MRSS_CTX = JAXBContext.newInstance((String)MRSS_JAXB_CONTEXT);
            }
            return MRSS_CTX;
        }
        if (ctxEnum == ContextEnum.SY) {
            if (SY_CTX == null) {
                SY_CTX = JAXBContext.newInstance((String)"yarfraw.generated.rss10.elements");
            }
            return SY_CTX;
        }
        if (ctxEnum == ContextEnum.WFW) {
            if (WFW_CTX == null) {
                WFW_CTX = JAXBContext.newInstance((String)WFW_JAXB_CONTEXT);
            }
            return WFW_CTX;
        }
        throw new UnsupportedOperationException("Unknown JAXB context: " + (Object)((Object)ctxEnum));
    }

    private static List<Element> toElements(Object extensionObject, ContextEnum ctxEnum) throws YarfrawException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        ArrayList<Element> ret = new ArrayList<Element>();
        try {
            Document doc = dbf.newDocumentBuilder().newDocument();
            Marshaller m = ExtensionUtils.getContext(ctxEnum).createMarshaller();
            m.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)JAXBUtils.getNamespacePrefixMapper(FeedFormat.RSS20));
            m.marshal(extensionObject, (Node)doc);
            Element e = doc.getDocumentElement();
            NodeList list = e.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node n = list.item(i);
                if (n instanceof Element) {
                    Element element = (Element)n;
                    ret.add(element);
                    continue;
                }
                LOG.error((Object)("Ignore unexpected node " + n.getNodeName() + ", this should not happen"));
            }
        }
        catch (ParserConfigurationException e) {
            throw new YarfrawException("Parserconfig exception", e);
        }
        catch (JAXBException e) {
            e.printStackTrace();
            throw new YarfrawException("JAXB exception", e);
        }
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ContextEnum {
        DC,
        SY,
        ITUNES,
        GOOGLEBASE,
        WFW,
        MRSS,
        GEORSS,
        BLOGGER,
        ADMIN,
        FEEDBURNER,
        SLASH,
        ATOM03;

    }
}

