/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bytes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;

public class ByteBlockChopper {
    private static final Log log = LogFactory.getLog(ByteBlockChopper.class);

    private ByteBlockChopper() {
    }

    public static List chopItUp(byte[] byteArray) {
        List<Object> bytes = null;
        if (byteArray != null) {
            int byteCount = byteArray.length;
            int blockSize = JbpmConfiguration.Configs.getInt("jbpm.byte.block.size");
            if (byteCount > blockSize) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("chopping up " + byteCount + " bytes"));
                }
                bytes = new ArrayList();
                int offset = 0;
                while (byteCount - offset > blockSize) {
                    bytes.add(ByteBlockChopper.subArray(byteArray, offset, blockSize));
                    offset += blockSize;
                }
                bytes.add(ByteBlockChopper.subArray(byteArray, offset, byteCount - offset));
            } else if (byteCount > 0) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("no need to chop " + byteCount + " bytes"));
                }
                bytes = Collections.singletonList(byteArray);
            }
        }
        return bytes;
    }

    private static byte[] subArray(byte[] array, int offset, int length) {
        byte[] subArray = new byte[length];
        System.arraycopy(array, offset, subArray, 0, length);
        if (log.isTraceEnabled()) {
            log.trace((Object)("chopped " + length + " bytes at offset " + offset));
        }
        return subArray;
    }

    public static byte[] glueChopsBackTogether(List byteBlocks) {
        byte[] byteArray = null;
        if (byteBlocks != null) {
            int blockCount = byteBlocks.size();
            switch (blockCount) {
                case 0: {
                    break;
                }
                case 1: {
                    byteArray = (byte[])byteBlocks.get(0);
                    if (!log.isTraceEnabled()) break;
                    log.trace((Object)("no need to glue " + byteArray.length + " bytes"));
                    break;
                }
                default: {
                    int blockSize = JbpmConfiguration.Configs.getInt("jbpm.byte.block.size");
                    byte[] lastBlock = (byte[])byteBlocks.get(blockCount - 1);
                    int byteCount = blockSize * (blockCount - 1) + lastBlock.length;
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("gluing " + byteCount + " bytes back together"));
                    }
                    byteArray = new byte[byteCount];
                    int offset = 0;
                    int n = blockCount;
                    for (int i = 0; i < n; ++i) {
                        byte[] block = (byte[])byteBlocks.get(i);
                        int length = block.length;
                        System.arraycopy(block, 0, byteArray, offset, length);
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("glued " + length + " bytes at offset " + offset));
                        }
                        if (length < blockSize && i < n - 1) {
                            Arrays.fill(byteArray, offset + length, offset + blockSize, (byte)0);
                            offset += blockSize;
                            if (!log.isTraceEnabled()) continue;
                            log.trace((Object)("zero filled " + (blockSize - length) + " trailing bytes"));
                            continue;
                        }
                        offset += length;
                    }
                }
            }
        }
        return byteArray;
    }
}

