/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.configuration;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.configuration.ConfigurationException;
import org.jbpm.configuration.ObjectFactory;
import org.jbpm.configuration.ObjectInfo;
import org.jbpm.util.ClassLoaderUtil;

public class ObjectFactoryImpl
implements ObjectFactory {
    private static final long serialVersionUID = 2L;
    private final Map namedObjectInfos;
    private final Map singletons = new HashMap();
    private final transient Map objects = new HashMap();
    private final transient Collection objectsUnderConstruction = new HashSet();
    private transient ClassLoader classLoader;
    private static final Log log = LogFactory.getLog(ObjectFactoryImpl.class);

    public ObjectFactoryImpl() {
        this.namedObjectInfos = new HashMap();
    }

    ObjectFactoryImpl(Map namedObjectInfos) {
        this.namedObjectInfos = namedObjectInfos;
    }

    public ObjectFactoryImpl(Map namedObjectInfos, List objectInfos) {
        this.namedObjectInfos = namedObjectInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObjectInfo(ObjectInfo objectInfo) {
        if (!objectInfo.hasName()) {
            throw new ConfigurationException(objectInfo + " has no name");
        }
        String name = objectInfo.getName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("adding object info: " + name));
        }
        Map map = this.namedObjectInfos;
        synchronized (map) {
            this.namedObjectInfos.put(name, objectInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectInfo getObjectInfo(String name) {
        Map map = this.namedObjectInfos;
        synchronized (map) {
            ObjectInfo objectInfo = (ObjectInfo)this.namedObjectInfos.get(name);
            if (objectInfo == null) {
                throw new ConfigurationException("no info for object '" + name + "'; defined objects: " + this.namedObjectInfos.keySet());
            }
            return objectInfo;
        }
    }

    public Object createObject(String name) {
        ObjectInfo objectInfo = this.getObjectInfo(name);
        return this.createObject(objectInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasObject(String name) {
        Map map = this.namedObjectInfos;
        synchronized (map) {
            return this.namedObjectInfos.containsKey(name);
        }
    }

    public Object createObject(int index) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createObject(ObjectInfo objectInfo) {
        Map map = this.objects;
        synchronized (map) {
            this.objects.clear();
            this.objectsUnderConstruction.clear();
            return this.getObject(objectInfo);
        }
    }

    Object getObject(String name) {
        ObjectInfo objectInfo = this.getObjectInfo(name);
        return this.getObject(objectInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getObject(ObjectInfo objectInfo) {
        Map registry;
        String registryKey;
        String string = registryKey = objectInfo.hasName() ? objectInfo.getName() : null;
        if (registryKey == null) {
            return objectInfo.createObject(this);
        }
        Map map = registry = objectInfo.isSingleton() ? this.singletons : this.objects;
        if (registry.containsKey(registryKey)) {
            return registry.get(registryKey);
        }
        if (this.objectsUnderConstruction.contains(registryKey)) {
            throw new ConfigurationException("circular reference to object '" + registryKey + "'");
        }
        this.objectsUnderConstruction.add(registryKey);
        try {
            Object object = objectInfo.createObject(this);
            registry.put(registryKey, object);
            Object object2 = object;
            return object2;
        }
        finally {
            this.objectsUnderConstruction.remove(registryKey);
        }
    }

    Class classForName(String className) throws ClassNotFoundException {
        if (this.classLoader == null) {
            this.classLoader = ClassLoaderUtil.getClassLoader();
        }
        return Class.forName(className, false, this.classLoader);
    }
}

