/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.configuration;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jbpm.JbpmException;
import org.jbpm.configuration.BeanInfo;
import org.jbpm.configuration.BooleanInfo;
import org.jbpm.configuration.CharacterInfo;
import org.jbpm.configuration.DoubleInfo;
import org.jbpm.configuration.FloatInfo;
import org.jbpm.configuration.IntegerInfo;
import org.jbpm.configuration.JbpmContextInfo;
import org.jbpm.configuration.JbpmTypeObjectInfo;
import org.jbpm.configuration.ListInfo;
import org.jbpm.configuration.LongInfo;
import org.jbpm.configuration.MapInfo;
import org.jbpm.configuration.NullInfo;
import org.jbpm.configuration.ObjectFactoryImpl;
import org.jbpm.configuration.ObjectInfo;
import org.jbpm.configuration.RefInfo;
import org.jbpm.configuration.SetInfo;
import org.jbpm.configuration.StringInfo;
import org.jbpm.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ObjectFactoryParser
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Class[] constructorParameterTypes = new Class[]{Element.class, ObjectFactoryParser.class};
    private static final Map defaultMappings = ObjectFactoryParser.getDefaultMappings();
    private Map mappings;
    private final Map namedObjectInfos = new HashMap();

    public static Map getDefaultMappings() {
        HashMap mappings = new HashMap();
        ObjectFactoryParser.addMapping(mappings, "bean", BeanInfo.class);
        ObjectFactoryParser.addMapping(mappings, "ref", RefInfo.class);
        ObjectFactoryParser.addMapping(mappings, "list", ListInfo.class);
        ObjectFactoryParser.addMapping(mappings, "set", SetInfo.class);
        ObjectFactoryParser.addMapping(mappings, "map", MapInfo.class);
        ObjectFactoryParser.addMapping(mappings, "string", StringInfo.class);
        ObjectFactoryParser.addMapping(mappings, "int", IntegerInfo.class);
        ObjectFactoryParser.addMapping(mappings, "integer", IntegerInfo.class);
        ObjectFactoryParser.addMapping(mappings, "long", LongInfo.class);
        ObjectFactoryParser.addMapping(mappings, "float", FloatInfo.class);
        ObjectFactoryParser.addMapping(mappings, "double", DoubleInfo.class);
        ObjectFactoryParser.addMapping(mappings, "char", CharacterInfo.class);
        ObjectFactoryParser.addMapping(mappings, "character", CharacterInfo.class);
        ObjectFactoryParser.addMapping(mappings, "boolean", BooleanInfo.class);
        ObjectFactoryParser.addMapping(mappings, "true", BooleanInfo.class);
        ObjectFactoryParser.addMapping(mappings, "false", BooleanInfo.class);
        ObjectFactoryParser.addMapping(mappings, "null", NullInfo.class);
        ObjectFactoryParser.addMapping(mappings, "jbpm-context", JbpmContextInfo.class);
        ObjectFactoryParser.addMapping(mappings, "jbpm-type", JbpmTypeObjectInfo.class);
        return mappings;
    }

    private static void addMapping(Map mappings, String elementTagName, Class objectInfoClass) {
        try {
            Constructor constructor = objectInfoClass.getDeclaredConstructor(constructorParameterTypes);
            mappings.put(elementTagName, constructor);
        }
        catch (NoSuchMethodException e) {
            throw new JbpmException("could not add mapping for element '" + elementTagName + "', constructor(" + Element.class.getName() + "," + ObjectFactoryParser.class.getName() + ") missing from " + objectInfoClass, e);
        }
    }

    public static ObjectFactoryImpl parseXmlString(String xml) {
        return ObjectFactoryParser.createObjectFactory(XmlUtil.parseXmlText(xml));
    }

    public static ObjectFactoryImpl parseInputStream(InputStream inputStream) {
        return ObjectFactoryParser.createObjectFactory(XmlUtil.parseXmlInputStream(inputStream));
    }

    public static ObjectFactoryImpl parseResource(String resource) {
        return ObjectFactoryParser.createObjectFactory(XmlUtil.parseXmlResource(resource, false));
    }

    private static ObjectFactoryImpl createObjectFactory(Document document) {
        return ObjectFactoryParser.createObjectFactory(document.getDocumentElement());
    }

    public static ObjectFactoryImpl createObjectFactory(Element infosElement) {
        ObjectFactoryParser parser = new ObjectFactoryParser();
        Iterator iter = XmlUtil.elementIterator(infosElement);
        while (iter.hasNext()) {
            Element infoElement = (Element)iter.next();
            parser.parse(infoElement);
        }
        return new ObjectFactoryImpl(parser.namedObjectInfos);
    }

    public void parseElementsFromResource(String resource, ObjectFactoryImpl objectFactory) {
        this.parseElements(XmlUtil.parseXmlResource(resource, false), objectFactory);
    }

    public void parseElementsStream(InputStream inputStream, ObjectFactoryImpl objectFactory) {
        this.parseElements(XmlUtil.parseXmlInputStream(inputStream), objectFactory);
    }

    private void parseElements(Document document, ObjectFactoryImpl objectFactory) {
        this.parseElements(document.getDocumentElement(), objectFactory);
    }

    public void parseElements(Element infosElement, ObjectFactoryImpl objectFactory) {
        Iterator iter = XmlUtil.elementIterator(infosElement);
        while (iter.hasNext()) {
            Element infoElement = (Element)iter.next();
            ObjectInfo objectInfo = this.parse(infoElement);
            objectFactory.addObjectInfo(objectInfo);
        }
    }

    public ObjectFactoryParser() {
        this(ObjectFactoryParser.getDefaultMappings());
    }

    public ObjectFactoryParser(Map mappings) {
        this.mappings = mappings;
    }

    public ObjectInfo parse(Element element) {
        String tagName = element.getTagName().toLowerCase();
        Constructor constructor = (Constructor)this.mappings.get(tagName);
        if (constructor == null) {
            throw new JbpmException("no ObjectInfo class specified for element: " + tagName);
        }
        try {
            ObjectInfo objectInfo = (ObjectInfo)constructor.newInstance(element, this);
            if (objectInfo.hasName()) {
                this.addNamedObjectInfo(objectInfo.getName(), objectInfo);
            }
            return objectInfo;
        }
        catch (InstantiationException e) {
            throw new JbpmException("failed to instantiate " + constructor.getDeclaringClass(), e);
        }
        catch (IllegalAccessException e) {
            throw new JbpmException(this.getClass() + " has no access to " + constructor, e);
        }
        catch (InvocationTargetException e) {
            throw new JbpmException(constructor + " threw exception", e);
        }
    }

    public void addNamedObjectInfo(String name, ObjectInfo objectInfo) {
        this.namedObjectInfos.put(name, objectInfo);
    }

    public void addMapping(String elementName, Class objectInfoClass) {
        if (this.mappings == defaultMappings) {
            this.mappings = new HashMap(defaultMappings);
        }
        ObjectFactoryParser.addMapping(this.mappings, elementName, objectInfoClass);
    }
}

