/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.context.def;

import java.io.Serializable;

public class Access
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String access = "read,write";

    public Access() {
    }

    public Access(String access) {
        if (access != null) {
            this.access = access.length() > 0 ? access.toLowerCase() : " ";
        }
    }

    public boolean isReadable() {
        return this.hasAccess("read");
    }

    public boolean isWritable() {
        return this.hasAccess("write");
    }

    public boolean isRequired() {
        return this.hasAccess("required");
    }

    public boolean isLock() {
        return this.hasAccess("lock");
    }

    public boolean hasAccess(String accessLiteral) {
        return this.access != null ? this.access.indexOf(accessLiteral.toLowerCase()) != -1 : false;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Access)) {
            return false;
        }
        Access other = (Access)object;
        return this.isReadable() == other.isReadable() && this.isWritable() == other.isWritable() && this.isRequired() == other.isRequired() && this.isLock() == other.isLock();
    }

    public int hashCode() {
        int result = 265979407 + Access.hashCode(this.isReadable());
        result = 752346139 * result + Access.hashCode(this.isWritable());
        result = 376739687 * result + Access.hashCode(this.isRequired());
        result = 750974239 * result + Access.hashCode(this.isLock());
        return result;
    }

    private static int hashCode(boolean value) {
        return value ? 1231 : 1237;
    }

    public String toString() {
        return this.access;
    }
}

