/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.context.exe;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmException;
import org.jbpm.configuration.ObjectFactoryImpl;
import org.jbpm.configuration.ObjectFactoryParser;
import org.jbpm.context.exe.Converter;
import org.jbpm.context.exe.JbpmTypeMatcher;
import org.jbpm.context.exe.VariableInstance;
import org.jbpm.util.ClassLoaderUtil;

public class JbpmType {
    private static Map typesByResource = new HashMap();
    private JbpmTypeMatcher jbpmTypeMatcher;
    private Converter converter;
    private Class variableInstanceClass;

    public JbpmType(JbpmTypeMatcher jbpmTypeMatcher, Converter converter, Class variableInstanceClass) {
        this.jbpmTypeMatcher = jbpmTypeMatcher;
        this.converter = converter;
        this.variableInstanceClass = variableInstanceClass;
    }

    public boolean matches(Object value) {
        return this.jbpmTypeMatcher.matches(value);
    }

    public VariableInstance newVariableInstance() {
        try {
            VariableInstance variableInstance = (VariableInstance)this.variableInstanceClass.newInstance();
            variableInstance.converter = this.converter;
            return variableInstance;
        }
        catch (InstantiationException e) {
            throw new JbpmException("failed to instantiate " + this.variableInstanceClass, e);
        }
        catch (IllegalAccessException e) {
            throw new JbpmException(this.getClass() + " has no access to " + this.variableInstanceClass, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getJbpmTypes() {
        if (JbpmConfiguration.Configs.hasObject("jbpm.types")) {
            return (List)JbpmConfiguration.Configs.getObject("jbpm.types");
        }
        String resource = JbpmConfiguration.Configs.getString("resource.varmapping");
        Map map = typesByResource;
        synchronized (map) {
            List types = (List)typesByResource.get(resource);
            if (types == null) {
                InputStream resourceStream = ClassLoaderUtil.getStream(resource);
                ObjectFactoryImpl objectFactory = ObjectFactoryParser.parseInputStream(resourceStream);
                types = (List)objectFactory.createObject("jbpm.types");
                typesByResource.put(resource, types);
            }
            return types;
        }
    }
}

