/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.node;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.util.ClassLoaderUtil;
import org.jbpm.util.XmlUtil;
import org.w3c.dom.Element;

public class NodeTypes {
    private static Map typesByResource = new HashMap();
    private static final Log log = LogFactory.getLog(NodeTypes.class);

    public static Collection getNodeTypes() {
        return NodeTypes.getTypes().values();
    }

    public static Set getNodeNames() {
        return NodeTypes.getTypes().keySet();
    }

    public static Class getNodeType(String name) {
        return (Class)NodeTypes.getTypes().get(name);
    }

    public static String getNodeName(Class type) {
        for (Map.Entry entry : NodeTypes.getTypes().entrySet()) {
            if (type != entry.getValue()) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map getTypes() {
        String resource = JbpmConfiguration.Configs.getString("resource.node.types");
        Map map = typesByResource;
        synchronized (map) {
            Map types = (Map)typesByResource.get(resource);
            if (types == null) {
                types = NodeTypes.initialiseNodeTypes(resource);
                typesByResource.put(resource, types);
            }
            return types;
        }
    }

    private static Map initialiseNodeTypes(String resource) {
        HashMap<String, Class> types = new HashMap<String, Class>();
        InputStream nodeTypesStream = ClassLoaderUtil.getStream(resource);
        Element nodeTypesElement = XmlUtil.parseXmlInputStream(nodeTypesStream).getDocumentElement();
        Iterator iter = XmlUtil.elementIterator(nodeTypesElement, "node-type");
        while (iter.hasNext()) {
            Element nodeTypeElement = (Element)iter.next();
            String elementTag = nodeTypeElement.getAttribute("element");
            String className = nodeTypeElement.getAttribute("class");
            try {
                Class nodeClass = ClassLoaderUtil.classForName(className);
                types.put(elementTag, nodeClass);
            }
            catch (ClassNotFoundException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("node '" + elementTag + "' will not be available, class not found: " + className));
            }
        }
        return types;
    }

    public static Map createInverseMapping(Map map) {
        HashMap names = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            names.put(entry.getValue(), entry.getKey());
        }
        return names;
    }
}

