/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.node;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.dom4j.tree.DefaultElement;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.context.def.VariableAccess;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.log.ProcessStateLog;
import org.jbpm.graph.node.SubProcessResolver;
import org.jbpm.job.SignalTokenJob;
import org.jbpm.jpdl.JpdlException;
import org.jbpm.jpdl.el.impl.JbpmExpressionEvaluator;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.msg.MessageService;
import org.jbpm.util.Clock;

public class ProcessState
extends Node {
    private static final long serialVersionUID = 1L;
    private static SubProcessResolver defaultSubProcessResolver;
    protected ProcessDefinition subProcessDefinition;
    protected Set variableAccesses;
    protected String subProcessName;
    private static final String[] EVENT_TYPES;
    public static final String[] supportedEventTypes;
    private static final Log log;

    public static void setDefaultSubProcessResolver(SubProcessResolver subProcessResolver) {
        defaultSubProcessResolver = subProcessResolver;
    }

    public static SubProcessResolver getSubProcessResolver() {
        return defaultSubProcessResolver != null ? defaultSubProcessResolver : (SubProcessResolver)JbpmConfiguration.Configs.getObject("jbpm.sub.process.resolver");
    }

    public ProcessState() {
    }

    public ProcessState(String name) {
        super(name);
    }

    public String[] getSupportedEventTypes() {
        return (String[])EVENT_TYPES.clone();
    }

    public void read(Element processStateElement, JpdlXmlReader jpdlReader) {
        Element subProcessElement = processStateElement.element("sub-process");
        if (subProcessElement != null) {
            String binding = subProcessElement.attributeValue("binding");
            if ("late".equalsIgnoreCase(binding)) {
                this.subProcessName = subProcessElement.attributeValue("name");
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this + " will be late bound to process definition: " + this.subProcessName));
                }
            } else {
                this.subProcessDefinition = this.resolveSubProcess(subProcessElement, jpdlReader);
            }
        }
        this.variableAccesses = new HashSet(jpdlReader.readVariableAccesses(processStateElement));
    }

    private ProcessDefinition resolveSubProcess(Element subProcessElement, JpdlXmlReader jpdlReader) {
        SubProcessResolver subProcessResolver = ProcessState.getSubProcessResolver();
        try {
            ProcessDefinition subProcess = subProcessResolver.findSubProcess(subProcessElement);
            if (subProcess != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("bound " + this + " to " + subProcess));
                }
                return subProcess;
            }
        }
        catch (JpdlException e) {
            jpdlReader.addError(e.getMessage());
        }
        String subProcessName = subProcessElement.attributeValue("name");
        if (subProcessName != null && subProcessName.equals(this.processDefinition.getName())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("bound " + this + " to its own " + this.processDefinition));
            }
            return this.processDefinition;
        }
        return null;
    }

    public void execute(ExecutionContext executionContext) {
        MessageService messageService;
        JbpmContext jbpmContext;
        Token superProcessToken = executionContext.getToken();
        ProcessDefinition usedSubProcessDefinition = this.subProcessDefinition;
        if (this.subProcessDefinition == null && this.subProcessName != null) {
            DefaultElement subProcessElement = new DefaultElement("sub-process");
            subProcessElement.addAttribute("name", (String)JbpmExpressionEvaluator.evaluate(this.subProcessName, executionContext, String.class));
            SubProcessResolver subProcessResolver = ProcessState.getSubProcessResolver();
            usedSubProcessDefinition = subProcessResolver.findSubProcess((Element)subProcessElement);
        }
        ProcessInstance subProcessInstance = superProcessToken.createSubProcessInstance(usedSubProcessDefinition);
        this.fireEvent("subprocess-created", executionContext);
        if (this.variableAccesses != null && !this.variableAccesses.isEmpty()) {
            ContextInstance superContextInstance = executionContext.getContextInstance();
            ContextInstance subContextInstance = subProcessInstance.getContextInstance();
            subContextInstance.setTransientVariables(superContextInstance.getTransientVariables());
            for (VariableAccess variableAccess : this.variableAccesses) {
                String variableName;
                Object value;
                if (!variableAccess.isReadable() || (value = superContextInstance.getVariable(variableName = variableAccess.getVariableName(), superProcessToken)) == null) continue;
                String mappedName = variableAccess.getMappedName();
                if (log.isDebugEnabled()) {
                    log.debug((Object)(superProcessToken + " reads '" + variableName + "' into '" + mappedName + '\''));
                }
                subContextInstance.setVariable(mappedName, value);
            }
        }
        if ((jbpmContext = JbpmContext.getCurrentJbpmContext()) != null && JbpmConfiguration.Configs.getBoolean("jbpm.sub.process.async") && (messageService = jbpmContext.getServices().getMessageService()) != null) {
            SignalTokenJob job = new SignalTokenJob(subProcessInstance.getRootToken());
            job.setDueDate(new Date());
            messageService.send(job);
        } else {
            subProcessInstance.signal();
        }
    }

    public void leave(ExecutionContext executionContext, Transition transition) {
        ProcessInstance subProcessInstance = executionContext.getSubProcessInstance();
        Token superProcessToken = subProcessInstance.getSuperProcessToken();
        if (this.variableAccesses != null && !this.variableAccesses.isEmpty()) {
            ContextInstance superContextInstance = executionContext.getContextInstance();
            ContextInstance subContextInstance = subProcessInstance.getContextInstance();
            for (VariableAccess variableAccess : this.variableAccesses) {
                String mappedName;
                Object value;
                if (!variableAccess.isWritable() || (value = subContextInstance.getVariable(mappedName = variableAccess.getMappedName())) == null) continue;
                String variableName = variableAccess.getVariableName();
                if (log.isDebugEnabled()) {
                    log.debug((Object)(superProcessToken + " writes '" + variableName + "' from '" + mappedName + '\''));
                }
                superContextInstance.setVariable(variableName, value, superProcessToken);
            }
        }
        this.fireEvent("subprocess-end", executionContext);
        superProcessToken.setSubProcessInstance(null);
        superProcessToken.addLog(new ProcessStateLog(this, superProcessToken.getNodeEnter(), Clock.getCurrentTime(), subProcessInstance));
        super.leave(executionContext, this.getDefaultLeavingTransition());
    }

    protected void addNodeLog(Token token) {
    }

    public ProcessDefinition getSubProcessDefinition() {
        return this.subProcessDefinition;
    }

    public void setSubProcessDefinition(ProcessDefinition subProcessDefinition) {
        this.subProcessDefinition = subProcessDefinition;
    }

    static {
        EVENT_TYPES = new String[]{"subprocess-created", "subprocess-end", "node-enter", "node-leave", "before-signal", "after-signal"};
        supportedEventTypes = (String[])EVENT_TYPES.clone();
        log = LogFactory.getLog(ProcessState.class);
    }
}

