/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenMBeanAttributeInfoSupport;
import javax.management.openmbean.OpenMBeanConstructorInfo;
import javax.management.openmbean.OpenMBeanInfoSupport;
import javax.management.openmbean.OpenMBeanOperationInfo;
import javax.management.openmbean.OpenMBeanOperationInfoSupport;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenMBeanParameterInfoSupport;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.jmx.model.ChildAddOperationFinder;
import org.jboss.as.jmx.model.ModelControllerMBeanHelper;
import org.jboss.as.jmx.model.NameConverter;
import org.jboss.as.jmx.model.TypeConverter;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class MBeanInfoFactory {
    private static final OpenMBeanParameterInfo[] EMPTY_PARAMETERS = new OpenMBeanParameterInfo[0];
    private final boolean standalone;
    private final ImmutableManagementResourceRegistration resourceRegistration;
    private final ModelNode providedDescription;
    private final PathAddress pathAddress;

    private MBeanInfoFactory(boolean standalone, PathAddress address, ImmutableManagementResourceRegistration resourceRegistration) {
        this.standalone = standalone;
        this.resourceRegistration = resourceRegistration;
        DescriptionProvider provider = resourceRegistration.getModelDescription(PathAddress.EMPTY_ADDRESS);
        this.providedDescription = provider != null ? provider.getModelDescription(null) : new ModelNode();
        this.pathAddress = address;
    }

    private static MBeanInfoFactory createFactory(boolean standalone, PathAddress address, ImmutableManagementResourceRegistration resourceRegistration) throws InstanceNotFoundException {
        return new MBeanInfoFactory(standalone, address, resourceRegistration);
    }

    static MBeanInfo createMBeanInfo(boolean standalone, PathAddress address, ImmutableManagementResourceRegistration resourceRegistration) throws InstanceNotFoundException {
        return MBeanInfoFactory.createFactory(standalone, address, resourceRegistration).createMBeanInfo();
    }

    private MBeanInfo createMBeanInfo() {
        return new OpenMBeanInfoSupport(ModelControllerMBeanHelper.CLASS_NAME, this.getDescription(this.providedDescription), this.getAttributes(), this.getConstructors(), this.getOperations(), this.getNotifications());
    }

    private String getDescription(ModelNode node) {
        if (!node.hasDefined("description")) {
            return "-";
        }
        String description = node.get("description").asString();
        if (description.trim().length() == 0) {
            return "-";
        }
        return description;
    }

    private OpenMBeanAttributeInfo[] getAttributes() {
        ArrayList<OpenMBeanAttributeInfo> infos = new ArrayList<OpenMBeanAttributeInfo>();
        if (this.providedDescription.hasDefined("attributes")) {
            for (String name : this.providedDescription.require("attributes").keys()) {
                infos.add(this.getAttribute(name));
            }
        }
        return infos.toArray(new OpenMBeanAttributeInfo[infos.size()]);
    }

    private OpenMBeanAttributeInfo getAttribute(String name) {
        String escapedName = NameConverter.convertToCamelCase(name);
        ModelNode attribute = this.providedDescription.require("attributes").require(name);
        AttributeAccess access = this.resourceRegistration.getAttributeAccess(PathAddress.EMPTY_ADDRESS, name);
        boolean writable = !this.standalone ? false : (access != null ? access.getAccessType() == AttributeAccess.AccessType.READ_WRITE : false);
        return new OpenMBeanAttributeInfoSupport(escapedName, this.getDescription(attribute), TypeConverter.convertToMBeanType(attribute), true, writable, false);
    }

    private OpenMBeanConstructorInfo[] getConstructors() {
        return null;
    }

    private OpenMBeanOperationInfo[] getOperations() {
        boolean root = this.pathAddress.size() == 0;
        ArrayList<OpenMBeanOperationInfo> ops = new ArrayList<OpenMBeanOperationInfo>();
        for (Map.Entry entry : this.resourceRegistration.getOperationDescriptions(PathAddress.EMPTY_ADDRESS, false).entrySet()) {
            String opName = (String)entry.getKey();
            if (opName.equals("add") || opName.equals("describe") || root && (opName.equals("read-resource") || opName.equals("read-attribute") || opName.equals("read-resource-description") || opName.equals("read-children-names") || opName.equals("read-children-types") || opName.equals("read-children-resources") || opName.equals("read-operation-names") || opName.equals("read-operation-description") || opName.equals("read-resource") || opName.equals("read-resource") || opName.equals("write-attribute") || opName.equals("validate-address") || opName.equals("composite") || opName.equals("upload-deployment-stream") || opName.equals("root-resource-hack"))) continue;
            OperationEntry opEntry = (OperationEntry)entry.getValue();
            if (!this.standalone && !opEntry.getFlags().contains(OperationEntry.Flag.READ_ONLY)) continue;
            ops.add(this.getOperation(NameConverter.convertToCamelCase((String)entry.getKey()), null, opEntry));
        }
        this.addChildAddOperations(ops, this.resourceRegistration);
        return ops.toArray(new OpenMBeanOperationInfo[ops.size()]);
    }

    private void addChildAddOperations(List<OpenMBeanOperationInfo> ops, ImmutableManagementResourceRegistration resourceRegistration) {
        for (Map.Entry<PathElement, ChildAddOperationFinder.ChildAddOperationEntry> entry : ChildAddOperationFinder.findAddChildOperations(resourceRegistration).entrySet()) {
            OpenMBeanParameterInfoSupport addWildcardChildName = null;
            if (entry.getValue().getElement().isWildcard()) {
                addWildcardChildName = new OpenMBeanParameterInfoSupport("name", "The name of the " + entry.getValue().getElement().getKey() + " to add.", SimpleType.STRING);
            }
            ops.add(this.getOperation(NameConverter.createValidAddOperationName(entry.getKey()), addWildcardChildName, entry.getValue().getOperationEntry()));
        }
    }

    private OpenMBeanOperationInfo getOperation(String name, OpenMBeanParameterInfo addWildcardChildName, OperationEntry entry) {
        ModelNode opNode = entry.getDescriptionProvider().getModelDescription(null);
        OpenMBeanParameterInfo[] params = this.getParameterInfos(opNode);
        if (addWildcardChildName != null) {
            OpenMBeanParameterInfo[] newParams = new OpenMBeanParameterInfo[params.length + 1];
            newParams[0] = addWildcardChildName;
            System.arraycopy(params, 0, newParams, 1, params.length);
            params = newParams;
        }
        return new OpenMBeanOperationInfoSupport(name, this.getDescription(opNode), params, this.getReturnType(opNode), 3);
    }

    private OpenMBeanParameterInfo[] getParameterInfos(ModelNode opNode) {
        if (!opNode.hasDefined("request-properties")) {
            return EMPTY_PARAMETERS;
        }
        ArrayList<OpenMBeanParameterInfoSupport> params = new ArrayList<OpenMBeanParameterInfoSupport>();
        for (Property prop : opNode.get("request-properties").asPropertyList()) {
            ModelNode value = prop.getValue();
            String paramName = NameConverter.convertToCamelCase(prop.getName());
            params.add(new OpenMBeanParameterInfoSupport(paramName, this.getDescription(prop.getValue()), TypeConverter.convertToMBeanType(value)));
        }
        return params.toArray(new OpenMBeanParameterInfo[params.size()]);
    }

    private OpenType<?> getReturnType(ModelNode opNode) {
        if (!opNode.hasDefined("reply-properties")) {
            return SimpleType.VOID;
        }
        if (opNode.get("reply-properties").asList().size() == 0) {
            return SimpleType.VOID;
        }
        ModelNode reply = opNode.get("reply-properties");
        return TypeConverter.convertToMBeanType(reply);
    }

    private MBeanNotificationInfo[] getNotifications() {
        return null;
    }
}

