/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.resolver.impl;

import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.Version;
import org.osgi.framework.resource.Capability;
import org.osgi.framework.resource.Requirement;
import org.osgi.framework.resource.Resource;
import org.osgi.framework.resource.Wiring;
import org.osgi.service.resolver.Environment;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static String getSymbolicName(Resource resource) {
        List<Capability> caps = resource.getCapabilities(null);
        for (Capability cap : caps) {
            if (!cap.getNamespace().equals("osgi.identity")) continue;
            return cap.getAttributes().get("osgi.identity").toString();
        }
        return null;
    }

    public static Version getVersion(Resource resource) {
        List<Capability> caps = resource.getCapabilities(null);
        for (Capability cap : caps) {
            if (!cap.getNamespace().equals("osgi.identity")) continue;
            return (Version)cap.getAttributes().get("version");
        }
        return null;
    }

    public static boolean isFragment(Resource resource) {
        Capability icap = resource.getCapabilities("osgi.identity").get(0);
        String type = (String)icap.getAttributes().get("type");
        return "osgi.fragment".equals(type);
    }

    public static boolean isOptional(Requirement req) {
        String resolution = req.getDirectives().get("resolution");
        return "optional".equals(resolution);
    }

    public static List<Requirement> getDynamicRequirements(List<Requirement> reqs) {
        ArrayList<Requirement> result = new ArrayList<Requirement>();
        if (reqs != null) {
            for (Requirement req : reqs) {
                String resolution = req.getDirectives().get("resolution");
                if (resolution == null || !resolution.equals("dynamic")) continue;
                result.add(req);
            }
        }
        return result;
    }

    public static Capability getSatisfyingCapability(Environment env, Resource br, Requirement req) {
        List<Capability> caps;
        Wiring wiring = env.getWirings().get(br);
        List<Capability> list = caps = wiring != null ? wiring.getResourceCapabilities(null) : br.getCapabilities(null);
        if (caps != null) {
            for (Capability cap : caps) {
                if (!cap.getNamespace().equals(req.getNamespace()) || !req.matches(cap)) continue;
                return cap;
            }
        }
        return null;
    }
}

