/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.remoting.wrapper;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import org.dom4j.Element;
import org.hibernate.collection.spi.PersistentCollection;
import org.jboss.seam.remoting.wrapper.BaseWrapper;
import org.jboss.seam.remoting.wrapper.ConversionException;
import org.jboss.seam.remoting.wrapper.ConversionScore;
import org.jboss.seam.remoting.wrapper.Wrapper;

public class BagWrapper
extends BaseWrapper
implements Wrapper {
    private static final byte[] BAG_TAG_OPEN = "<bag>".getBytes();
    private static final byte[] BAG_TAG_CLOSE = "</bag>".getBytes();
    private static final byte[] ELEMENT_TAG_OPEN = "<element>".getBytes();
    private static final byte[] ELEMENT_TAG_CLOSE = "</element>".getBytes();

    @Override
    public void marshal(OutputStream out) throws IOException {
        out.write(BAG_TAG_OPEN);
        if (this.value instanceof PersistentCollection && !((PersistentCollection)this.value).wasInitialized()) {
            out.write(BAG_TAG_CLOSE);
            return;
        }
        Collection<Object> vals = null;
        if (this.value.getClass().isArray()) {
            vals = new ArrayList();
            for (int i = 0; i < Array.getLength(this.value); ++i) {
                vals.add(Array.get(this.value, i));
            }
        } else if (Collection.class.isAssignableFrom(this.value.getClass())) {
            vals = (Collection)this.value;
        } else {
            throw new RuntimeException(String.format("Can not marshal object as bag: [%s]", this.value));
        }
        for (Object e : vals) {
            out.write(ELEMENT_TAG_OPEN);
            this.context.createWrapperFromObject(e, this.path).marshal(out);
            out.write(ELEMENT_TAG_CLOSE);
        }
        out.write(BAG_TAG_CLOSE);
    }

    @Override
    public Object convert(Type type) throws ConversionException {
        block10: {
            ArrayList<Wrapper> vals;
            block11: {
                block9: {
                    vals = new ArrayList<Wrapper>();
                    for (Element e : this.element.elements("element")) {
                        vals.add(this.context.createWrapperFromElement((Element)e.elements().get(0)));
                    }
                    if (!(type instanceof Class) || !((Class)type).isArray()) break block9;
                    Class<?> arrayType = ((Class)type).getComponentType();
                    this.value = Array.newInstance(arrayType, vals.size());
                    for (int i = 0; i < vals.size(); ++i) {
                        Array.set(this.value, i, ((Wrapper)vals.get(i)).convert(arrayType));
                    }
                    break block10;
                }
                if (!(type instanceof Class) || !Collection.class.isAssignableFrom((Class)type)) break block11;
                try {
                    this.value = this.getConcreteClass((Class)type).newInstance();
                }
                catch (Exception ex) {
                    throw new ConversionException(String.format("Could not create instance of target type [%s].", type));
                }
                for (Wrapper w : vals) {
                    ((Collection)this.value).add(w.convert((Type)((Object)Object.class)));
                }
                break block10;
            }
            if (!(type instanceof ParameterizedType) || !Collection.class.isAssignableFrom((Class)((ParameterizedType)type).getRawType())) break block10;
            Class rawType = (Class)((ParameterizedType)type).getRawType();
            Object genType = Object.class;
            int i$ = 0;
            Type[] arr$ = ((ParameterizedType)type).getActualTypeArguments();
            int len$ = arr$.length;
            if (i$ < len$) {
                Type t = arr$[i$];
                genType = t;
            }
            try {
                this.value = this.getConcreteClass(rawType).newInstance();
            }
            catch (Exception ex) {
                throw new ConversionException(String.format("Could not create instance of target type [%s].", rawType));
            }
            for (Wrapper w : vals) {
                ((Collection)this.value).add(w.convert((Type)genType));
            }
        }
        return this.value;
    }

    private Class getConcreteClass(Class c) {
        if (c.isInterface()) {
            if (Set.class.isAssignableFrom(c)) {
                return HashSet.class;
            }
            if (Queue.class.isAssignableFrom(c)) {
                return LinkedList.class;
            }
            return ArrayList.class;
        }
        return c;
    }

    @Override
    public ConversionScore conversionScore(Class cls) {
        if (cls.isArray()) {
            return ConversionScore.compatible;
        }
        if (cls.equals(Object.class)) {
            return ConversionScore.compatible;
        }
        if (Collection.class.isAssignableFrom(cls)) {
            return ConversionScore.compatible;
        }
        return ConversionScore.nomatch;
    }
}

