/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl;

import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.indexes.spi.IndexManager;

public class WorkQueuePerIndexSplitter {
    private IdentityHashMap<IndexManager, List<LuceneWork>> queues = new IdentityHashMap();

    public List<LuceneWork> getIndexManagerQueue(IndexManager indexManager) {
        List<LuceneWork> list = this.queues.get(indexManager);
        if (list == null) {
            list = new LinkedList<LuceneWork>();
            this.queues.put(indexManager, list);
        }
        return list;
    }

    public void commitOperations(IndexingMonitor monitor) {
        for (Map.Entry<IndexManager, List<LuceneWork>> entry : this.queues.entrySet()) {
            entry.getKey().performOperations(entry.getValue(), monitor);
        }
    }
}

