/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.junit;

import java.security.AccessController;
import java.security.PrivilegedAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SecurityActions {
    private SecurityActions() {
        throw new UnsupportedOperationException("No instantiation");
    }

    static ClassLoader getThreadContextClassLoader() {
        return AccessController.doPrivileged(GetTcclAction.INSTANCE);
    }

    static boolean existsClass(String className) {
        try {
            SecurityActions.loadClass(className);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    static Class<?> loadClass(String className) {
        try {
            return Class.forName(className, true, SecurityActions.getThreadContextClassLoader());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load class", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum GetTcclAction implements PrivilegedAction<ClassLoader>
    {
        INSTANCE;


        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

