/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.core.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.InvocationException;
import org.jboss.arquillian.core.spi.Manager;
import org.jboss.arquillian.core.spi.ObserverMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObserverImpl
implements ObserverMethod,
Comparable<ObserverMethod> {
    private Object target;
    private Method method;

    public static ObserverImpl of(Object extension, Method observerMethod) {
        return new ObserverImpl(extension, observerMethod);
    }

    ObserverImpl(Object target, Method method) {
        this.target = target;
        this.method = method;
    }

    public Type getType() {
        return this.method.getGenericParameterTypes()[0];
    }

    public Method getMethod() {
        return this.method;
    }

    public boolean invoke(Manager manager, Object event) {
        try {
            Object[] arguments = this.resolveArguments(manager, event);
            if (this.containsNull(arguments)) {
                return false;
            }
            this.method.invoke(this.target, arguments);
            return true;
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                Throwable cause = ((InvocationTargetException)e).getTargetException();
                if (cause instanceof InvocationException) {
                    throw (InvocationException)cause;
                }
                throw new InvocationException(cause);
            }
            throw new InvocationException((Throwable)e);
        }
    }

    @Override
    public int compareTo(ObserverMethod o) {
        if (o == null) {
            return 1;
        }
        Integer a = this.getPresedence(this.getMethod());
        Integer b = this.getPresedence(o.getMethod());
        return b.compareTo(a);
    }

    private Integer getPresedence(Method method) {
        Annotation[][] arr$ = method.getParameterAnnotations();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = arr$[i$]) {
                if (annotation.annotationType() != Observes.class) continue;
                return ((Observes)annotation).precedence();
            }
        }
        return 0;
    }

    private Object[] resolveArguments(Manager manager, Object event) {
        Class<?>[] argumentTypes = this.getMethod().getParameterTypes();
        int numberOfArguments = argumentTypes.length;
        Object[] arguments = new Object[numberOfArguments];
        arguments[0] = event;
        for (int i = 1; i < numberOfArguments; ++i) {
            Class<?> argumentType = argumentTypes[i];
            arguments[i] = manager.resolve(argumentType);
        }
        return arguments;
    }

    private boolean containsNull(Object[] arguments) {
        for (Object argument : arguments) {
            if (argument != null) continue;
            return true;
        }
        return false;
    }
}

